/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class PropertyRemover
extends AbstractInconsistencyRepair {
    private final NodeTypeDataManager nodeTypeManager;

    public PropertyRemover(WorkspaceStorageConnectionFactory connFactory, JDBCDataContainerConfig containerConfig, NodeTypeDataManager nodeTypeManager) {
        super(connFactory, containerConfig);
        this.nodeTypeManager = nodeTypeManager;
    }

    void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            PropertyDefinitionDatas def;
            boolean multiValued;
            block7: {
                String parentId = this.getIdentifier(resultSet, "PARENT_ID");
                InternalQName propertyName = InternalQName.parse(resultSet.getString("NAME"));
                multiValued = resultSet.getBoolean("P_MULTIVALUED");
                def = null;
                try {
                    NodeData parent = (NodeData)conn.getItemData(parentId);
                    def = this.nodeTypeManager.getPropertyDefinitions(propertyName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
                }
                catch (PrimaryTypeNotFoundException e) {
                    if (!LOG.isTraceEnabled()) break block7;
                    LOG.trace((Object)e.getMessage(), (Throwable)((Object)e));
                }
            }
            if (def != null && def.getDefinition(multiValued) != null && !def.getDefinition(multiValued).isResidualSet()) {
                throw new SQLException("Propety is required by its parent.");
            }
            String propertyId = this.getIdentifier(resultSet, "ID");
            QPath path = new QPath(new QPathEntry[]{this.getQPathEntry(resultSet)});
            TransientPropertyData data = new TransientPropertyData(path, propertyId, 0, 0, null, false, new ArrayList<ValueData>());
            conn.delete(data);
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
        catch (IllegalNameException e) {
            throw new SQLException(e);
        }
    }
}

