/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLMultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLSingleDbJDBCConnection;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class MySQLConnectionFactory
extends GenericConnectionFactory {
    public MySQLConnectionFactory(DataSource dbDataSource, JDBCDataContainerConfig containerConfig) {
        super(dbDataSource, containerConfig);
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                return new MySQLMultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
            }
            return new MySQLSingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

