/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SwapFile
extends SpoolFile {
    private static final long serialVersionUID = 4048760909657109754L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SwapFile");
    protected static final ConcurrentMap<String, WeakReference<SwapFile>> CURRENT_SWAP_FILES = new ConcurrentHashMap<String, WeakReference<SwapFile>>();
    protected final AtomicReference<CountDownLatch> spoolLatch = new AtomicReference();
    private final FileCleaner swapCleaner;

    protected SwapFile(File parent, String child, FileCleaner cleaner) {
        super(parent, child);
        this.swapCleaner = cleaner;
    }

    public static SwapFile get(File parent, String child) throws IOException {
        return SwapFile.get(parent, child, SpoolConfig.getDefaultSpoolConfig().fileCleaner);
    }

    public static SwapFile get(File parent, String child, FileCleaner cleaner) throws IOException {
        SwapFile swapped;
        SwapFile newsf = new SwapFile(parent, child, cleaner);
        String absPath = PrivilegedFileHelper.getAbsolutePath((File)newsf);
        WeakReference swappedRef = (WeakReference)CURRENT_SWAP_FILES.get(absPath);
        if (swappedRef != null && (swapped = (SwapFile)swappedRef.get()) != null) {
            do {
                CountDownLatch spoolLatch;
                if ((spoolLatch = swapped.spoolLatch.get()) == null) continue;
                try {
                    spoolLatch.await();
                }
                catch (InterruptedException e) {
                    throw new IOException("Swap file read error " + PrivilegedFileHelper.getAbsolutePath((File)swapped) + ". " + e){

                        public Throwable getCause() {
                            return e;
                        }
                    };
                }
            } while (!swapped.spoolLatch.compareAndSet(null, new CountDownLatch(1)));
            return swapped;
        }
        if (swappedRef != null) {
            CURRENT_SWAP_FILES.remove(absPath, swappedRef);
        }
        newsf.spoolLatch.set(new CountDownLatch(1));
        WeakReference<SwapFile> currentValue = CURRENT_SWAP_FILES.putIfAbsent(absPath, new WeakReference<SwapFile>(newsf));
        if (currentValue != null) {
            return SwapFile.get(parent, child, cleaner);
        }
        return newsf;
    }

    public boolean isSpooled() {
        return this.spoolLatch.get() == null;
    }

    public void spoolDone() {
        CountDownLatch sl = this.spoolLatch.get();
        this.spoolLatch.set(null);
        sl.countDown();
    }

    public static SwapFile createTempFile(String prefix, String suffix, File directory) throws IOException {
        throw new IOException("Not applicable. Call get(File, String) method instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.delete();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        String path = PrivilegedFileHelper.getAbsolutePath((File)this);
        WeakReference currentValue = (WeakReference)CURRENT_SWAP_FILES.get(path);
        if (currentValue == null || currentValue.get() == this || currentValue.get() == null) {
            CURRENT_SWAP_FILES.remove(path, currentValue);
            SwapFile swapFile = this;
            synchronized (swapFile) {
                this.users.clear();
                final SwapFile sf = this;
                PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        if (sf.exists()) {
                            if (SwapFile.super.delete()) {
                                return true;
                            }
                            if (SwapFile.this.swapCleaner != null) {
                                SwapFile.this.swapCleaner.addFile(SwapFile.super.getAbsoluteFile());
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Could not remove swap file on finalize : " + PrivilegedFileHelper.getAbsolutePath((File)SwapFile.super.getAbsoluteFile())));
                            }
                            return false;
                        }
                        return true;
                    }
                };
                return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
            }
        }
        return false;
    }
}

