/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AccessLogAdapter;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class ContainerBase
extends LifecycleMBeanBase
implements Container {
    private static final Log log = LogFactory.getLog(ContainerBase.class);
    protected HashMap<String, Container> children = new HashMap();
    protected int backgroundProcessorDelay = -1;
    protected List<ContainerListener> listeners = new CopyOnWriteArrayList<ContainerListener>();
    protected Loader loader = null;
    protected Log logger = null;
    protected String logName = null;
    protected Manager manager = null;
    protected Cluster cluster = null;
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = new StandardPipeline(this);
    private volatile Realm realm = null;
    private final ReadWriteLock realmLock = new ReentrantReadWriteLock();
    protected DirContext resources = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    protected boolean startChildren = true;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private volatile boolean threadDone = false;
    protected volatile AccessLog accessLog = null;
    private volatile boolean accessLogScanComplete = false;
    private int startStopThreads = 1;
    protected ThreadPoolExecutor startStopExecutor;

    @Override
    public int getStartStopThreads() {
        return this.startStopThreads;
    }

    private int getStartStopThreadsInternal() {
        int result = this.getStartStopThreads();
        if (result > 0) {
            return result;
        }
        result = Runtime.getRuntime().availableProcessors() + result;
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    @Override
    public void setStartStopThreads(int startStopThreads) {
        this.startStopThreads = startStopThreads;
        ThreadPoolExecutor executor = this.startStopExecutor;
        if (executor != null) {
            int newThreads = this.getStartStopThreadsInternal();
            executor.setMaximumPoolSize(newThreads);
            executor.setCorePoolSize(newThreads);
        }
    }

    @Override
    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    @Override
    public String getInfo() {
        return this.getClass().getName();
    }

    @Override
    public Loader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.parent != null) {
            return this.parent.getLoader();
        }
        return null;
    }

    @Override
    public synchronized void setLoader(Loader loader) {
        Loader oldLoader = this.loader;
        if (oldLoader == loader) {
            return;
        }
        this.loader = loader;
        if (this.getState().isAvailable() && oldLoader != null && oldLoader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldLoader)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setLoader: stop: ", (Throwable)e);
            }
        }
        if (loader != null) {
            loader.setContainer(this);
        }
        if (this.getState().isAvailable() && loader != null && loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)loader)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setLoader: start: ", (Throwable)e);
            }
        }
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    @Override
    public Log getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        this.logger = LogFactory.getLog((String)this.logName());
        return this.logger;
    }

    @Override
    public Manager getManager() {
        if (this.manager != null) {
            return this.manager;
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    @Override
    public synchronized void setManager(Manager manager) {
        Manager oldManager = this.manager;
        if (oldManager == manager) {
            return;
        }
        this.manager = manager;
        if (this.getState().isAvailable() && oldManager != null && oldManager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldManager)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setManager: stop: ", (Throwable)e);
            }
        }
        if (manager != null) {
            manager.setContainer(this);
        }
        if (this.getState().isAvailable() && manager != null && manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)manager)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setManager: start: ", (Throwable)e);
            }
        }
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    @Deprecated
    public Object getMappingObject() {
        return this;
    }

    @Override
    public Cluster getCluster() {
        if (this.cluster != null) {
            return this.cluster;
        }
        if (this.parent != null) {
            return this.parent.getCluster();
        }
        return null;
    }

    @Override
    public synchronized void setCluster(Cluster cluster) {
        Cluster oldCluster = this.cluster;
        if (oldCluster == cluster) {
            return;
        }
        this.cluster = cluster;
        if (this.getState().isAvailable() && oldCluster != null && oldCluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldCluster)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setCluster: stop: ", (Throwable)e);
            }
        }
        if (cluster != null) {
            cluster.setContainer(this);
        }
        if (this.getState().isAvailable() && cluster != null && cluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.setCluster: start: ", (Throwable)e);
            }
        }
        this.support.firePropertyChange("cluster", oldCluster, this.cluster);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean getStartChildren() {
        return this.startChildren;
    }

    public void setStartChildren(boolean startChildren) {
        boolean oldStartChildren = this.startChildren;
        this.startChildren = startChildren;
        this.support.firePropertyChange("startChildren", oldStartChildren, this.startChildren);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Realm getRealm() {
        Lock l = this.realmLock.readLock();
        try {
            l.lock();
            if (this.realm != null) {
                Realm realm = this.realm;
                return realm;
            }
            if (this.parent != null) {
                Realm realm = this.parent.getRealm();
                return realm;
            }
            Realm realm = null;
            return realm;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Realm getRealmInternal() {
        Lock l = this.realmLock.readLock();
        try {
            l.lock();
            Realm realm = this.realm;
            return realm;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRealm(Realm realm) {
        Lock l = this.realmLock.writeLock();
        try {
            l.lock();
            Realm oldRealm = this.realm;
            if (oldRealm == realm) {
                return;
            }
            this.realm = realm;
            if (this.getState().isAvailable() && oldRealm != null && oldRealm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldRealm)).stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"ContainerBase.setRealm: stop: ", (Throwable)e);
                }
            }
            if (realm != null) {
                realm.setContainer(this);
            }
            if (this.getState().isAvailable() && realm != null && realm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)realm)).start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"ContainerBase.setRealm: start: ", (Throwable)e);
                }
            }
            this.support.firePropertyChange("realm", oldRealm, this.realm);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public DirContext getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        if (this.parent != null) {
            return this.parent.getResources();
        }
        return null;
    }

    @Override
    public synchronized void setResources(DirContext resources) {
        DirContext oldResources = this.resources;
        if (oldResources == resources) {
            return;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        this.resources = new ProxyDirContext(env, resources);
        this.support.firePropertyChange("resources", oldResources, this.resources);
    }

    @Override
    public void addChild(Container child) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAddChild dp = new PrivilegedAddChild(child);
            AccessController.doPrivileged(dp);
        } else {
            this.addChildInternal(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildInternal(Container child) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add child " + child + " " + this));
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(child.getName()) != null) {
                throw new IllegalArgumentException("addChild:  Child name '" + child.getName() + "' is not unique");
            }
            child.setParent(this);
            this.children.put(child.getName(), child);
        }
        if ((this.getState().isAvailable() || LifecycleState.STARTING_PREP.equals((Object)this.getState())) && this.startChildren) {
            try {
                child.start();
            }
            catch (LifecycleException e) {
                log.error((Object)"ContainerBase.addChild: start: ", (Throwable)e);
                throw new IllegalStateException("ContainerBase.addChild: start: " + e);
            }
        }
        this.fireContainerEvent("addChild", child);
    }

    @Override
    public void addContainerListener(ContainerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container findChild(String name) {
        if (name == null) {
            return null;
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            return this.children.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container[] findChildren() {
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            Container[] results = new Container[this.children.size()];
            return this.children.values().toArray(results);
        }
    }

    @Override
    public ContainerListener[] findContainerListeners() {
        ContainerListener[] results = new ContainerListener[]{};
        return this.listeners.toArray(results);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.getFirst().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(Container child) {
        if (child == null) {
            return;
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(child.getName()) == null) {
                return;
            }
            this.children.remove(child.getName());
        }
        try {
            if (child.getState().isAvailable()) {
                child.stop();
            }
        }
        catch (LifecycleException e) {
            log.error((Object)"ContainerBase.removeChild: stop: ", (Throwable)e);
        }
        this.fireContainerEvent("removeChild", child);
        try {
            if (!LifecycleState.DESTROYING.equals((Object)child.getState())) {
                child.destroy();
            }
        }
        catch (LifecycleException e) {
            log.error((Object)"ContainerBase.removeChild: destroy: ", (Throwable)e);
        }
    }

    @Override
    public void removeContainerListener(ContainerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        LinkedBlockingQueue<Runnable> startStopQueue = new LinkedBlockingQueue<Runnable>();
        this.startStopExecutor = new ThreadPoolExecutor(this.getStartStopThreadsInternal(), this.getStartStopThreadsInternal(), 10L, TimeUnit.SECONDS, startStopQueue, new StartStopThreadFactory(this.getName() + "-startStop-"));
        this.startStopExecutor.allowCoreThreadTimeOut(true);
        super.initInternal();
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Realm realm;
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).start();
        }
        this.logger = null;
        this.getLogger();
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).start();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).start();
        }
        if ((realm = this.getRealmInternal()) != null && realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).start();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).start();
        }
        Container[] children = this.findChildren();
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        for (int i = 0; i < children.length; ++i) {
            results.add(this.startStopExecutor.submit(new StartChild(children[i])));
        }
        boolean fail = false;
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("containerBase.threadedStartFailed"), (Throwable)e);
                fail = true;
            }
        }
        if (fail) {
            throw new LifecycleException(sm.getString("containerBase.threadedStartFailed"));
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.setState(LifecycleState.STARTING);
        this.threadStart();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        Realm realm;
        this.threadStop();
        this.setState(LifecycleState.STOPPING);
        if (this.pipeline instanceof Lifecycle && ((Lifecycle)((Object)this.pipeline)).getState().isAvailable()) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] children = this.findChildren();
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        for (int i = 0; i < children.length; ++i) {
            results.add(this.startStopExecutor.submit(new StopChild(children[i])));
        }
        boolean fail = false;
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("containerBase.threadedStopFailed"), (Throwable)e);
                fail = true;
            }
        }
        if (fail) {
            throw new LifecycleException(sm.getString("containerBase.threadedStopFailed"));
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).stop();
        }
        if ((realm = this.getRealmInternal()) != null && realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).stop();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).stop();
        }
        if (this.manager != null && this.manager instanceof Lifecycle && ((Lifecycle)((Object)this.manager)).getState().isAvailable()) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        Realm realm;
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).destroy();
        }
        if ((realm = this.getRealmInternal()) != null && realm instanceof Lifecycle) {
            ((Lifecycle)((Object)realm)).destroy();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).destroy();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).destroy();
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).destroy();
        }
        for (Container child : this.findChildren()) {
            this.removeChild(child);
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        if (this.startStopExecutor != null) {
            this.startStopExecutor.shutdownNow();
        }
        super.destroyInternal();
    }

    @Override
    public void logAccess(Request request, Response response, long time, boolean useDefault) {
        boolean logged = false;
        if (this.getAccessLog() != null) {
            this.getAccessLog().log(request, response, time);
            logged = true;
        }
        if (this.getParent() != null) {
            this.getParent().logAccess(request, response, time, useDefault && !logged);
        }
    }

    @Override
    public AccessLog getAccessLog() {
        Valve[] valves;
        if (this.accessLogScanComplete) {
            return this.accessLog;
        }
        AccessLogAdapter adapter = null;
        for (Valve valve : valves = this.getPipeline().getValves()) {
            if (!(valve instanceof AccessLog)) continue;
            if (adapter == null) {
                adapter = new AccessLogAdapter((AccessLog)((Object)valve));
                continue;
            }
            adapter.add((AccessLog)((Object)valve));
        }
        if (adapter != null) {
            this.accessLog = adapter;
        }
        this.accessLogScanComplete = true;
        return this.accessLog;
    }

    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
    }

    @Override
    public void backgroundProcess() {
        Realm realm;
        if (!this.getState().isAvailable()) {
            return;
        }
        if (this.cluster != null) {
            try {
                this.cluster.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.cluster", new Object[]{this.cluster}), (Throwable)e);
            }
        }
        if (this.loader != null) {
            try {
                this.loader.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.loader", new Object[]{this.loader}), (Throwable)e);
            }
        }
        if (this.manager != null) {
            try {
                this.manager.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.manager", new Object[]{this.manager}), (Throwable)e);
            }
        }
        if ((realm = this.getRealmInternal()) != null) {
            try {
                realm.backgroundProcess();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.realm", new Object[]{realm}), (Throwable)e);
            }
        }
        for (Valve current = this.pipeline.getFirst(); current != null; current = current.getNext()) {
            try {
                current.backgroundProcess();
                continue;
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("containerBase.backgroundProcess.valve", new Object[]{current}), (Throwable)e);
            }
        }
        this.fireLifecycleEvent("periodic", null);
    }

    @Override
    public void fireContainerEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        ContainerEvent event = new ContainerEvent(this, type, data);
        for (ContainerListener listener : this.listeners) {
            listener.containerEvent(event);
        }
    }

    protected String logName() {
        if (this.logName != null) {
            return this.logName;
        }
        String loggerName = null;
        for (Container current = this; current != null; current = current.getParent()) {
            String name = current.getName();
            if (name == null || name.equals("")) {
                name = "/";
            } else if (name.startsWith("##")) {
                name = "/" + name;
            }
            loggerName = "[" + name + "]" + (loggerName != null ? "." + loggerName : "");
        }
        this.logName = ContainerBase.class.getName() + "." + loggerName;
        return this.logName;
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this);
    }

    public ObjectName[] getChildren() {
        ObjectName[] result = new ObjectName[this.children.size()];
        Iterator<Container> it = this.children.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Container next = it.next();
            if (!(next instanceof ContainerBase)) continue;
            result[i++] = ((ContainerBase)next).getObjectName();
        }
        return result;
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.backgroundProcessorDelay <= 0) {
            return;
        }
        this.threadDone = false;
        String threadName = "ContainerBackgroundProcessor[" + this.toString() + "]";
        this.thread = new Thread((Runnable)new ContainerBackgroundProcessor(), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    private static class StartStopThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public StartStopThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class StopChild
    implements Callable<Void> {
        private Container child;

        public StopChild(Container child) {
            this.child = child;
        }

        @Override
        public Void call() throws LifecycleException {
            if (this.child.getState().isAvailable()) {
                this.child.stop();
            }
            return null;
        }
    }

    private static class StartChild
    implements Callable<Void> {
        private Container child;

        public StartChild(Container child) {
            this.child = child;
        }

        @Override
        public Void call() throws LifecycleException {
            this.child.start();
            return null;
        }
    }

    protected class ContainerBackgroundProcessor
    implements Runnable {
        protected ContainerBackgroundProcessor() {
        }

        @Override
        public void run() {
            Throwable t = null;
            String unexpectedDeathMessage = sm.getString("containerBase.backgroundProcess.unexpectedThreadDeath", new Object[]{Thread.currentThread().getName()});
            try {
                while (!ContainerBase.this.threadDone) {
                    try {
                        Thread.sleep((long)ContainerBase.this.backgroundProcessorDelay * 1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (ContainerBase.this.threadDone) continue;
                    Container parent = (Container)ContainerBase.this.getMappingObject();
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (parent.getLoader() != null) {
                        cl = parent.getLoader().getClassLoader();
                    }
                    this.processChildren(parent, cl);
                }
            }
            catch (RuntimeException e) {
                t = e;
                throw e;
            }
            catch (Error e) {
                t = e;
                throw e;
            }
            finally {
                if (!ContainerBase.this.threadDone) {
                    log.error((Object)unexpectedDeathMessage, t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processChildren(Container container, ClassLoader cl) {
            try {
                if (container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(container.getLoader().getClassLoader());
                }
                container.backgroundProcess();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                log.error((Object)"Exception invoking periodic operation: ", t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            Container[] children = container.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getBackgroundProcessorDelay() > 0) continue;
                this.processChildren(children[i], cl);
            }
        }
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction<Void> {
        private Container child;

        PrivilegedAddChild(Container child) {
            this.child = child;
        }

        @Override
        public Void run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }
}

