/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class LazyPageList<E>
extends PageList {
    private static final Log LOG = ExoLogger.getLogger((String)LazyPageList.class.getName());
    private QueryData queryData_;
    private SearchDataCreator<E> dataCreator_;
    private int total_;
    private int pageSize_;

    public LazyPageList(QueryData queryData, int pageSize, SearchDataCreator<E> dataCreator) {
        block3: {
            super(pageSize);
            this.queryData_ = queryData.clone();
            this.dataCreator_ = dataCreator;
            this.pageSize_ = pageSize;
            this.total_ = 0;
            if (queryData.getQueryStatement() != null) {
                try {
                    SessionProvider provider = WCMCoreUtils.getUserSessionProvider();
                    Session session = provider.getSession(queryData.getWorkSpace(), WCMCoreUtils.getRepository());
                    this.total_ = (int)session.getWorkspace().getQueryManager().createQuery(queryData.getQueryStatement(), queryData.getLanguage_()).execute().getRows().getSize();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)("Can not execute the query: " + queryData.getQueryStatement()), (Throwable)e);
                }
            }
        }
        this.setAvailablePage(this.total_);
    }

    protected void populateCurrentPage(int page) throws Exception {
        block4: {
            this.currentListPage_ = new ArrayList();
            if (this.queryData_.getQueryStatement() != null) {
                try {
                    SessionProvider provider = WCMCoreUtils.getUserSessionProvider();
                    Session session = provider.getSession(this.queryData_.getWorkSpace(), WCMCoreUtils.getRepository());
                    Query query = session.getWorkspace().getQueryManager().createQuery(this.queryData_.getQueryStatement(), this.queryData_.getLanguage_());
                    ((QueryImpl)query).setOffset((long)((page - 1) * this.pageSize_));
                    ((QueryImpl)query).setLimit((long)this.pageSize_);
                    ((QueryImpl)query).setCaseInsensitiveOrder(true);
                    QueryResult ret = query.execute();
                    NodeIterator iter = ret.getNodes();
                    RowIterator rowIter = ret.getRows();
                    while (iter.hasNext()) {
                        this.currentListPage_.add(this.dataCreator_.createData(iter.nextNode(), rowIter.nextRow()));
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)("Can not execute the query: " + this.queryData_.getQueryStatement()), (Throwable)e);
                }
            }
        }
    }

    public List<E> getAll() throws Exception {
        return new ArrayList();
    }
}

