/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.streams;

import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.service.AsyncCallback;
import org.exoplatform.social.common.service.AsyncProcessor;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.SocialServiceContext;

public abstract class SocialChromatticAsyncProcessor
implements AsyncProcessor {
    private static final Log LOG = ExoLogger.getLogger(SocialChromatticAsyncProcessor.class);
    protected SocialServiceContext socialContext;
    final String name;
    protected final PortalContainer container;
    protected ChromatticManager manager;
    protected ChromatticLifeCycle lifeCycle;
    private AtomicBoolean startedRequest = new AtomicBoolean(false);

    public SocialChromatticAsyncProcessor(SocialServiceContext socialContext) {
        this("SocialChromatticAsyncProcessor", socialContext);
    }

    public SocialChromatticAsyncProcessor(String name, SocialServiceContext socialContext) {
        this.socialContext = socialContext;
        this.name = name;
        this.container = PortalContainer.getInstance();
        this.manager = (ChromatticManager)this.container.getComponentInstanceOfType(ChromatticManager.class);
        if (this.manager != null) {
            this.lifeCycle = this.manager.getLifeCycle("soc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessContext process(ProcessContext processContext) {
        try {
            this.start(processContext);
            processContext = this.execute(processContext);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            processContext.setException((Throwable)e);
        }
        finally {
            this.end(processContext);
        }
        return processContext;
    }

    public ProcessContext process(ProcessContext processContext, AsyncCallback callback) {
        try {
            processContext = this.execute(processContext);
            if (!processContext.isFailed()) {
                callback.done(processContext);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            processContext.setException((Throwable)e);
            return processContext;
        }
        return processContext;
    }

    protected abstract ProcessContext execute(ProcessContext var1) throws Exception;

    public void start(ProcessContext processContext) {
        this.startedRequest.set(this.startSynchronization());
    }

    public void end(ProcessContext processContext) {
        this.stopSynchronization(this.startedRequest.get());
    }

    private boolean startSynchronization() {
        if (this.lifeCycle.getManager().getSynchronization() == null) {
            this.lifeCycle.getManager().beginRequest();
            return true;
        }
        return false;
    }

    private void stopSynchronization(boolean requestClose) {
        if (requestClose) {
            this.lifeCycle.getManager().endRequest(true);
        }
    }

    public String getName() {
        return this.name;
    }
}

