/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class KeywordsBox
extends AbstractFullBox {
    public static final String TYPE = "kywd";
    private String language;
    private String[] keywords;

    public KeywordsBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    protected long getContentSize() {
        long contentSize = 3L;
        for (String keyword : this.keywords) {
            contentSize += (long)(1 + KeywordsBox.utf8StringLengthInBytes(keyword) + 1);
        }
        return contentSize;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        int keywordCount = in.readUInt8();
        this.keywords = new String[keywordCount];
        for (int i = 0; i < keywordCount; ++i) {
            in.readUInt8();
            this.keywords[i] = in.readString();
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeIso639(this.language);
        isos.writeUInt8(this.keywords.length);
        for (String keyword : this.keywords) {
            isos.writeUInt8(KeywordsBox.utf8StringLengthInBytes(keyword) + 1);
            isos.writeStringZeroTerm(keyword);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("KeywordsBox[language=").append(this.getLanguage());
        for (int i = 0; i < this.keywords.length; ++i) {
            buffer.append(";keyword").append(i).append("=").append(this.keywords[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

