/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.drives.impl.ManageDrivePlugin;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class ManageDriveServiceImpl
implements ManageDriveService,
Startable {
    private static String WORKSPACE = "exo:workspace";
    private static String ALL_DRIVES_CACHED = "allDrives";
    private static String ALL_DRIVES_CACHED_WITH_VIRTUAL = "allDrives_withVirtual";
    private static String ALL_DRIVES_CACHED_BY_ROLES = "_allDrivesByRoles";
    private static String ALL_MAIN_CACHED_DRIVE = "_mainDrives";
    private static String ALL_PERSONAL_CACHED_DRIVE = "_personalDrives";
    private static String ALL_GROUP_CACHED_DRIVES = "_groupDrives";
    private static String ALL_GROUP_PERMISSION = "*:${groupId}";
    private static String PERMISSIONS = "exo:accessPermissions";
    private static String VIEWS = "exo:views";
    private static String ICON = "exo:icon";
    private static String PATH = "exo:path";
    private static String VIEW_REFERENCES = "exo:viewPreferences";
    private static String VIEW_NON_DOCUMENT = "exo:viewNonDocument";
    private static String VIEW_SIDEBAR = "exo:viewSideBar";
    private static String SHOW_HIDDEN_NODE = "exo:showHiddenNode";
    private static String ALLOW_CREATE_FOLDER = "exo:allowCreateFolders";
    private static String ALLOW_NODETYPES_ON_TREE = "exo:allowNodeTypesOnTree";
    private List<ManageDrivePlugin> drivePlugins_ = new ArrayList<ManageDrivePlugin>();
    private RepositoryService repositoryService_;
    private String baseDrivePath_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private DMSConfiguration dmsConfiguration_;
    private static final Log LOG = ExoLogger.getLogger((String)ManageDriveServiceImpl.class.getName());
    private static final String DELETED_DRIVE_NAMES = "DeletedDriveNames";
    private ExoCache<Serializable, Object> drivesCache_;
    private DriveData groupDriveTemplate_ = null;
    private boolean newRoleUpdated = false;

    public ManageDriveServiceImpl(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration, CacheService caService) throws Exception {
        this.repositoryService_ = jcrService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.baseDrivePath_ = this.nodeHierarchyCreator_.getJcrPath("exoDrivesPath");
        this.dmsConfiguration_ = dmsConfiguration;
        this.drivesCache_ = caService.getCacheInstance("wcm.drive");
    }

    public void start() {
        block3: {
            try {
                for (ManageDrivePlugin plugin : this.drivePlugins_) {
                    plugin.init();
                }
                this.getAllDrives(true);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)e.getMessage());
            }
        }
    }

    public void stop() {
    }

    @Override
    public void init() throws Exception {
        for (ManageDrivePlugin plugin : this.drivePlugins_) {
            plugin.init();
        }
        this.getAllDrives();
    }

    public void setManageDrivePlugin(ManageDrivePlugin drivePlugin) {
        this.drivePlugins_.add(drivePlugin);
    }

    @Override
    public List<DriveData> getAllDrives() throws Exception {
        return this.getAllDrives(false);
    }

    @Override
    public List<DriveData> getAllDrives(boolean withVirtualDrives) throws Exception {
        List allDrives = withVirtualDrives ? (List)this.drivesCache_.get((Serializable)((Object)(this.getRepoName() + "_" + ALL_DRIVES_CACHED_WITH_VIRTUAL))) : (List)this.drivesCache_.get((Serializable)((Object)(this.getRepoName() + "_" + ALL_DRIVES_CACHED)));
        if (allDrives != null && allDrives.size() > 0 && this.groupDriveTemplate_ != null) {
            return new ArrayList<DriveData>(allDrives);
        }
        Session session = this.getSession();
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        NodeIterator itr = driveHome.getNodes();
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        DriveData data = null;
        Node drive = null;
        while (itr.hasNext()) {
            data = new DriveData();
            drive = itr.nextNode();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewSideBar(Boolean.parseBoolean(drive.getProperty(VIEW_SIDEBAR).getString()));
            data.setShowHiddenNode(Boolean.parseBoolean(drive.getProperty(SHOW_HIDDEN_NODE).getString()));
            data.setAllowCreateFolders(drive.getProperty(ALLOW_CREATE_FOLDER).getString());
            data.setAllowNodeTypesOnTree(drive.getProperty(ALLOW_NODETYPES_ON_TREE).getString());
            if ("Groups".equals(data.getName())) {
                this.groupDriveTemplate_ = data.clone();
                if (!withVirtualDrives) continue;
                driveList.add(data);
                continue;
            }
            driveList.add(data);
        }
        if (withVirtualDrives) {
            this.drivesCache_.put((Serializable)((Object)(this.getRepoName() + "_" + ALL_DRIVES_CACHED_WITH_VIRTUAL)), driveList);
        } else {
            this.drivesCache_.put((Serializable)((Object)(this.getRepoName() + "_" + ALL_DRIVES_CACHED)), driveList);
        }
        session.logout();
        return new ArrayList<DriveData>(driveList);
    }

    @Override
    public DriveData getDriveByName(String name) throws Exception {
        if (name.startsWith(".")) {
            String groupName = name.replace(".", "/");
            if (this.groupDriveTemplate_ == null) {
                return null;
            }
            DriveData drive = this.groupDriveTemplate_.clone();
            drive.setHomePath(this.groupDriveTemplate_.getHomePath().replace("${groupId}", groupName));
            drive.setName(name);
            drive.setPermissions("*:" + groupName);
            return drive;
        }
        Session session = this.getSession();
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (driveHome.hasNode(name)) {
            Node drive = driveHome.getNode(name);
            DriveData data = new DriveData();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewSideBar(Boolean.parseBoolean(drive.getProperty(VIEW_SIDEBAR).getString()));
            data.setShowHiddenNode(Boolean.parseBoolean(drive.getProperty(SHOW_HIDDEN_NODE).getString()));
            data.setAllowCreateFolders(drive.getProperty(ALLOW_CREATE_FOLDER).getString());
            try {
                data.setAllowNodeTypesOnTree(drive.getProperty(ALLOW_NODETYPES_ON_TREE).getString());
            }
            catch (PathNotFoundException e) {
                data.setAllowNodeTypesOnTree("*");
            }
            session.logout();
            return data;
        }
        session.logout();
        return null;
    }

    @Override
    public void addDrive(String name, String workspace, String permissions, String homePath, String views, String icon, boolean viewReferences, boolean viewNonDocument, boolean viewSideBar, boolean showHiddenNode, String allowCreateFolder, String allowNodeTypesOnTree) throws Exception {
        Session session = this.getSession();
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (!driveHome.hasNode(name)) {
            Node driveNode = driveHome.addNode(name, "exo:drive");
            driveNode.setProperty(WORKSPACE, workspace);
            driveNode.setProperty(PERMISSIONS, permissions);
            driveNode.setProperty(PATH, homePath);
            driveNode.setProperty(VIEWS, views);
            driveNode.setProperty(ICON, icon);
            driveNode.setProperty(VIEW_REFERENCES, Boolean.toString(viewReferences));
            driveNode.setProperty(VIEW_NON_DOCUMENT, Boolean.toString(viewNonDocument));
            driveNode.setProperty(VIEW_SIDEBAR, Boolean.toString(viewSideBar));
            driveNode.setProperty(ALLOW_CREATE_FOLDER, allowCreateFolder);
            driveNode.setProperty(SHOW_HIDDEN_NODE, Boolean.toString(showHiddenNode));
            driveNode.setProperty(ALLOW_NODETYPES_ON_TREE, allowNodeTypesOnTree);
            driveHome.save();
        } else {
            Node driveNode = driveHome.getNode(name);
            driveNode.setProperty(WORKSPACE, workspace);
            driveNode.setProperty(PERMISSIONS, permissions);
            driveNode.setProperty(PATH, homePath);
            driveNode.setProperty(VIEWS, views);
            driveNode.setProperty(ICON, icon);
            driveNode.setProperty(VIEW_REFERENCES, Boolean.toString(viewReferences));
            driveNode.setProperty(VIEW_NON_DOCUMENT, Boolean.toString(viewNonDocument));
            driveNode.setProperty(VIEW_SIDEBAR, Boolean.toString(viewSideBar));
            driveNode.setProperty(ALLOW_CREATE_FOLDER, allowCreateFolder);
            driveNode.setProperty(SHOW_HIDDEN_NODE, Boolean.toString(showHiddenNode));
            driveNode.setProperty(ALLOW_NODETYPES_ON_TREE, allowNodeTypesOnTree);
            driveNode.save();
        }
        this.drivesCache_.clearCache();
        session.save();
        session.logout();
    }

    @Override
    public List<DriveData> getAllDriveByPermission(String permission) throws Exception {
        ArrayList<DriveData> driveByPermission;
        block3: {
            driveByPermission = new ArrayList<DriveData>();
            try {
                List<DriveData> driveList = this.getAllDrives();
                for (DriveData drive : driveList) {
                    if (!drive.hasPermission(drive.getAllPermissions(), permission)) continue;
                    driveByPermission.add(drive);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return driveByPermission;
    }

    @Override
    public void removeDrive(String driveName) throws Exception {
        Session session = this.getSession();
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (driveHome.hasNode(driveName)) {
            driveHome.getNode(driveName).remove();
            driveHome.save();
        }
        this.drivesCache_.clearCache();
        session.logout();
        this.updateDeletedDrivesLog(driveName);
    }

    private Session getSession() throws Exception {
        ManageableRepository manaRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        return manaRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
    }

    private String getRepoName() {
        try {
            String repositoryName = this.repositoryService_.getCurrentRepository().getConfiguration().getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The repository name is: " + repositoryName));
            }
            return repositoryName;
        }
        catch (RepositoryException e) {
            if (e.getMessage().equalsIgnoreCase("Repository 'null' not found.")) {
                String repositoryName = System.getProperty("gatein.tenant.repository.name");
                return repositoryName;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Repository exception occurs:", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public boolean isUsedView(String viewName) throws Exception {
        Session session = this.getSession();
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        NodeIterator iter = driveHome.getNodes();
        while (iter.hasNext()) {
            String[] views;
            Node drive = iter.nextNode();
            for (String view : views = drive.getProperty("exo:views").getString().split(",")) {
                if (!viewName.equals(view)) continue;
                session.logout();
                return true;
            }
        }
        session.logout();
        return false;
    }

    @Override
    public List<DriveData> getDriveByUserRoles(String userId, List<String> userRoles) throws Exception {
        Object drivesByRoles = this.drivesCache_.get((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_DRIVES_CACHED_BY_ROLES)));
        if (drivesByRoles != null) {
            return new ArrayList<DriveData>((List)drivesByRoles);
        }
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        if (userId != null) {
            block0: for (DriveData drive : this.getAllDrives()) {
                String[] allPermission = drive.getAllPermissions();
                boolean flag = false;
                block1: for (String permission : allPermission) {
                    if (permission.equalsIgnoreCase("${userId}")) {
                        if (!driveList.contains(drive)) {
                            driveList.add(drive);
                        }
                        flag = true;
                        continue block0;
                    }
                    if (permission.equalsIgnoreCase("*")) {
                        if (!driveList.contains(drive)) {
                            driveList.add(drive);
                        }
                        flag = true;
                        continue block0;
                    }
                    if (flag) continue;
                    for (String rolse : userRoles) {
                        if (!drive.hasPermission(allPermission, rolse)) continue;
                        if (driveList.contains(drive)) continue block1;
                        driveList.add(drive);
                        continue block1;
                    }
                }
            }
            for (DriveData drive : this.getGroupDrives(userId, userRoles)) {
                if (driveList.contains(drive)) continue;
                driveList.add(drive);
            }
        } else {
            block4: for (DriveData drive : this.getAllDrives()) {
                String[] allPermission;
                for (String permission : allPermission = drive.getAllPermissions()) {
                    if (!permission.equalsIgnoreCase("*")) continue;
                    driveList.add(drive);
                    continue block4;
                }
            }
        }
        Collections.sort(driveList);
        this.drivesCache_.put((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_DRIVES_CACHED_BY_ROLES)), driveList);
        return new ArrayList<DriveData>(driveList);
    }

    @Override
    public List<DriveData> getGroupDrives(String userId, List<String> userRoles) throws Exception {
        Object drives = this.drivesCache_.get((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_GROUP_CACHED_DRIVES)));
        if (drives != null) {
            return new ArrayList<DriveData>((List)drives);
        }
        ArrayList<DriveData> groupDrives = new ArrayList<DriveData>();
        DriveData groupDrive = this.getDriveByName("Groups");
        if (groupDrive == null) {
            return groupDrives;
        }
        String[] allPermission = groupDrive.getAllPermissions();
        boolean flag = false;
        for (String role : userRoles) {
            if (!groupDrive.hasPermission(allPermission, role) && !ALL_GROUP_PERMISSION.equals(allPermission[0])) continue;
            flag = true;
            break;
        }
        if (flag) {
            for (String role : userRoles) {
                String group = role.substring(role.indexOf(":") + 1);
                if (this.groupDriveTemplate_ == null || group.charAt(0) != '/') continue;
                DriveData drive = this.groupDriveTemplate_.clone();
                drive.setHomePath(this.groupDriveTemplate_.getHomePath().replace("${groupId}", group));
                drive.setName(group.replace("/", "."));
                drive.setPermissions("*:" + group);
                if (groupDrives.contains(drive)) continue;
                groupDrives.add(drive);
            }
        }
        Collections.sort(groupDrives);
        this.drivesCache_.put((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_GROUP_CACHED_DRIVES)), groupDrives);
        return new ArrayList<DriveData>(groupDrives);
    }

    @Override
    public List<DriveData> getMainDrives(String userId, List<String> userRoles) throws Exception {
        Object drives = this.drivesCache_.get((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_MAIN_CACHED_DRIVE)));
        if (drives != null) {
            return new ArrayList<DriveData>((List)drives);
        }
        ArrayList<DriveData> generalDrives = new ArrayList<DriveData>();
        List<DriveData> groupDrives = this.getGroupDrives(userId, userRoles);
        List<DriveData> personalDrives = this.getPersonalDrives(userId);
        for (DriveData drive : this.getDriveByUserRoles(userId, userRoles)) {
            if (groupDrives.contains(drive) || personalDrives.contains(drive)) continue;
            generalDrives.add(drive);
        }
        Collections.sort(generalDrives);
        this.drivesCache_.put((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_MAIN_CACHED_DRIVE)), generalDrives);
        return new ArrayList<DriveData>(generalDrives);
    }

    @Override
    public List<DriveData> getPersonalDrives(String userId) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userId);
        Object drives = this.drivesCache_.get((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_PERSONAL_CACHED_DRIVE)));
        if (drives != null) {
            return new ArrayList<DriveData>((List)drives);
        }
        ArrayList<DriveData> personalDrives = new ArrayList<DriveData>();
        String userPath = userNode.getPath();
        for (DriveData drive : this.getAllDrives()) {
            if (drive.getHomePath().startsWith(this.nodeHierarchyCreator_.getJcrPath("usersPath") + "/${userId}")) {
                personalDrives.add(drive);
                continue;
            }
            if (!drive.getHomePath().startsWith(userPath + "/")) continue;
            personalDrives.add(drive);
        }
        Collections.sort(personalDrives);
        this.drivesCache_.put((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_PERSONAL_CACHED_DRIVE)), personalDrives);
        return new ArrayList<DriveData>(personalDrives);
    }

    @Override
    public boolean isVitualDrive(String driveName) {
        if (this.groupDriveTemplate_ == null) {
            return false;
        }
        return this.groupDriveTemplate_.getName().equals(driveName);
    }

    @Override
    public void clearAllDrivesCache() {
        this.drivesCache_.clearCache();
    }

    @Override
    public void clearGroupCache(String userId) {
        this.drivesCache_.remove((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_GROUP_CACHED_DRIVES)));
        this.drivesCache_.remove((Serializable)((Object)(this.getRepoName() + "_" + userId + ALL_DRIVES_CACHED_BY_ROLES)));
    }

    @Override
    public boolean newRoleUpdated() {
        return this.newRoleUpdated;
    }

    @Override
    public void setNewRoleUpdated(boolean newRoleUpdated) {
        this.newRoleUpdated = newRoleUpdated;
    }

    @Override
    public String getDriveOfDefaultWorkspace() throws Exception {
        DriveData collaDrive = this.getDriveByName("Collaboration");
        if (collaDrive != null && collaDrive.getHomePath().equals("/")) {
            return "Collaboration";
        }
        List<DriveData> listDrive = this.getAllDrives();
        String defautlWsName = this.repositoryService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        for (DriveData drive : listDrive) {
            if (!drive.getWorkspace().equals(defautlWsName) || !drive.getHomePath().equals("/")) continue;
            return drive.getName();
        }
        return null;
    }

    @Override
    public Set<String> getDeletedDriveNames() throws Exception {
        return Utils.getAllEditedConfiguredData(this.getClass().getSimpleName(), DELETED_DRIVE_NAMES, true);
    }

    private void updateDeletedDrivesLog(String driveName) throws Exception {
        Utils.addEditedConfiguredData(driveName, this.getClass().getSimpleName(), DELETED_DRIVE_NAMES, true);
    }
}

