/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.cms.views.PortletTemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class ApplicationTemplateManagerServiceImpl
implements ApplicationTemplateManagerService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)ApplicationTemplateManagerServiceImpl.class.getName());
    public static final String EDITED_CONFIGURED_TEMPLATES = "EditedConfiguredTemplates";
    private RepositoryService repositoryService;
    private List<PortletTemplatePlugin> portletTemplatePlugins = new ArrayList<PortletTemplatePlugin>();
    Map<String, List<String>> managedApplicationNames = new HashMap<String, List<String>>();
    private Map<String, String> storedWorkspaces = new HashMap<String, String>();
    private String basedApplicationTemplatesPath;
    private DMSConfiguration dmsConfiguration_;
    private NodeHierarchyCreator hierarchyCreator;
    private TemplateService templateService;
    private Map<String, Set<String>> configuredTemplates_;

    public ApplicationTemplateManagerServiceImpl(RepositoryService repositoryService, NodeHierarchyCreator hierarchyCreator, DMSConfiguration dmsConfiguration) throws Exception {
        this.repositoryService = repositoryService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.hierarchyCreator = hierarchyCreator;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    @Override
    public void addPlugin(PortletTemplatePlugin portletTemplatePlugin) throws Exception {
        this.portletTemplatePlugins.add(portletTemplatePlugin);
    }

    @Override
    public void addTemplate(Node portletTemplateHome, PortletTemplatePlugin.PortletTemplateConfig config) throws Exception {
        Set<String> templateSet;
        Node category = null;
        try {
            category = portletTemplateHome.getNode(config.getCategory());
        }
        catch (Exception e) {
            category = portletTemplateHome.addNode(config.getCategory(), "nt:unstructured");
            portletTemplateHome.save();
        }
        if (!category.hasNode(config.getTemplateName())) {
            this.templateService.createTemplate(category, config.getTitle(), config.getTemplateName(), new ByteArrayInputStream(config.getTemplateData().getBytes()), new String[]{"*"});
        }
        if ((templateSet = this.configuredTemplates_.get(portletTemplateHome.getName())) == null) {
            templateSet = new HashSet<String>();
        }
        templateSet.add(category.getName() + "/" + config.getTemplateName());
        this.configuredTemplates_.put(portletTemplateHome.getName(), templateSet);
    }

    @Override
    public Node getApplicationTemplateHome(String portletName, SessionProvider provider) throws Exception {
        Node basedApplicationTemplateHome = this.getBasedApplicationTemplatesHome(provider);
        try {
            return basedApplicationTemplateHome.getNode(portletName);
        }
        catch (PathNotFoundException pne) {
            Node templateHome = basedApplicationTemplateHome.addNode(portletName);
            basedApplicationTemplateHome.save();
            return templateHome;
        }
    }

    @Override
    public List<String> getAllManagedPortletName(String repository) throws Exception {
        return this.managedApplicationNames.get(repository);
    }

    @Override
    public Node getTemplateByName(String portletName, String category, String templateName, SessionProvider sessionProvider) throws Exception {
        Node basedApplicationTemplateHome = this.getBasedApplicationTemplatesHome(sessionProvider);
        return basedApplicationTemplateHome.getNode(portletName + "/" + category + "/" + templateName);
    }

    @Override
    public List<Node> getTemplatesByCategory(String portletName, String category, SessionProvider sessionProvider) throws Exception {
        Node basedApplicationTemplateHome = this.getBasedApplicationTemplatesHome(sessionProvider);
        Node applicationHome = basedApplicationTemplateHome.getNode(portletName);
        Node categoryNode = applicationHome.getNode(category);
        ArrayList<Node> templateNodes = new ArrayList<Node>();
        NodeIterator iterator = categoryNode.getNodes();
        while (iterator.hasNext()) {
            templateNodes.add(iterator.nextNode());
        }
        return templateNodes;
    }

    @Override
    public Node getTemplateByPath(String templatePath, SessionProvider sessionProvider) throws Exception {
        Node basedTemplateNode = this.getBasedApplicationTemplatesHome(sessionProvider);
        return (Node)basedTemplateNode.getSession().getItem(templatePath);
    }

    @Override
    public void removeTemplate(String portletName, String category, String templateName, SessionProvider sessionProvider) throws Exception {
        Node templateNode = this.getTemplateByName(portletName, category, templateName, sessionProvider);
        Session session = templateNode.getSession();
        templateNode.remove();
        session.save();
    }

    private Node getBasedApplicationTemplatesHome(SessionProvider sessionProvider) throws Exception {
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
        Node basedTemplateHome = (Node)session.getItem(this.basedApplicationTemplatesPath);
        return basedTemplateHome;
    }

    private void importPredefinedTemplateToDB(Node storedTemplateHomeNode) throws Exception {
        HashMap<String, ArrayList<PortletTemplatePlugin.PortletTemplateConfig>> map = new HashMap<String, ArrayList<PortletTemplatePlugin.PortletTemplateConfig>>();
        String repository = ((ManageableRepository)storedTemplateHomeNode.getSession().getRepository()).getConfiguration().getName();
        List<String> managedApplicationsPerRepo = this.managedApplicationNames.get(repository);
        if (managedApplicationsPerRepo == null) {
            managedApplicationsPerRepo = new ArrayList<String>();
        }
        for (PortletTemplatePlugin plugin : this.portletTemplatePlugins) {
            ArrayList<PortletTemplatePlugin.PortletTemplateConfig> list;
            String portletName = plugin.getPortletName();
            if (!managedApplicationsPerRepo.contains(portletName)) {
                managedApplicationsPerRepo.add(portletName);
            }
            if ((list = (ArrayList<PortletTemplatePlugin.PortletTemplateConfig>)map.get(portletName)) == null) {
                list = new ArrayList<PortletTemplatePlugin.PortletTemplateConfig>();
            }
            list.addAll(plugin.getPortletTemplateConfigs());
            map.put(portletName, list);
        }
        for (String portletName : managedApplicationsPerRepo) {
            Node templateNode = storedTemplateHomeNode.hasNode(portletName) ? storedTemplateHomeNode.getNode(portletName) : storedTemplateHomeNode.addNode(portletName, "nt:unstructured");
            storedTemplateHomeNode.save();
            for (PortletTemplatePlugin.PortletTemplateConfig config : (List)map.get(portletName)) {
                StringBuilder tBuilder = new StringBuilder();
                tBuilder.append(config.getCategory()).append("/").append(config.getTemplateName());
                if (Utils.getAllEditedConfiguredData(this.getClass().getSimpleName(), EDITED_CONFIGURED_TEMPLATES, true).contains(tBuilder.toString())) continue;
                this.addTemplate(templateNode, config);
            }
        }
        this.managedApplicationNames.put(repository, managedApplicationsPerRepo);
        storedTemplateHomeNode.getSession().save();
    }

    public void start() {
        RepositoryEntry repositoryEntry;
        block5: {
            this.configuredTemplates_ = new HashMap<String, Set<String>>();
            repositoryEntry = null;
            try {
                repositoryEntry = this.repositoryService.getCurrentRepository().getConfiguration();
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        String repoName = repositoryEntry.getName();
        String workspaceName = repositoryEntry.getSystemWorkspaceName();
        this.storedWorkspaces.put(repoName, workspaceName);
        this.basedApplicationTemplatesPath = this.hierarchyCreator.getJcrPath("viewTemplatesPath");
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        for (String repository : this.storedWorkspaces.keySet()) {
            try {
                Node storedTemplateHome = this.getBasedApplicationTemplatesHome(sessionProvider);
                this.importPredefinedTemplateToDB(storedTemplateHome);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Exception when import predefine application template into repository: " + repository), (Throwable)e);
            }
        }
        sessionProvider.close();
    }

    public void stop() {
    }

    @Override
    public Set<String> getConfiguredAppTemplateMap(String portletName) {
        return this.configuredTemplates_ == null ? null : this.configuredTemplates_.get(portletName);
    }
}

