/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core.impl;

import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WebSchemaModificationAction
implements Action {
    private static final Log LOG = ExoLogger.getLogger((String)WebSchemaModificationAction.class.getName());

    public boolean execute(Context context) throws Exception {
        block6: {
            Property property = (Property)context.get((Object)"currentItem");
            String propertyName = property.getName();
            if (!(propertyName.equals("jcr:data") || propertyName.equals("exo:priority") || propertyName.equals("exo:active") || propertyName.equals("exo:restorePath"))) {
                return propertyName.equalsIgnoreCase("exo:active");
            }
            Node grandParent = property.getParent().getParent();
            if (propertyName.equals("jcr:data") && !grandParent.getPrimaryNodeType().getName().equals("nt:file")) {
                return false;
            }
            WebSchemaConfigService schemaConfigService = WCMCoreUtils.getService(WebSchemaConfigService.class);
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Node node = null;
            node = propertyName.equals("jcr:data") ? grandParent : property.getParent();
            try {
                if (propertyName.equals("exo:restorePath")) {
                    schemaConfigService.updateSchemaOnRemove(sessionProvider, node);
                } else {
                    schemaConfigService.updateSchemaOnModify(sessionProvider, node);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)("Error when update schema when modify node: " + node.getPath()), (Throwable)e);
            }
        }
        return true;
    }
}

