/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionChangesLog
implements CompositeChangesLog,
Externalizable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.TransactionChangesLog");
    private static final long serialVersionUID = 4866736965040228027L;
    protected String systemId;
    protected List<PlainChangesLog> changesLogs = new ArrayList<PlainChangesLog>();

    public TransactionChangesLog() {
    }

    public TransactionChangesLog(PlainChangesLog changesLog) {
        this.changesLogs.add(changesLog);
    }

    @Override
    public void addLog(PlainChangesLog log) {
        this.changesLogs.add(log);
    }

    @Override
    public void removeLog(PlainChangesLog log) {
        this.changesLogs.remove(log);
    }

    @Override
    public ChangesLogIterator getLogIterator() {
        return new ChangesLogIterator(this.changesLogs);
    }

    @Override
    public List<ItemState> getAllStates() {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (PlainChangesLog changesLog : this.changesLogs) {
            for (ItemState state : changesLog.getAllStates()) {
                states.add(state);
            }
        }
        return states;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (PlainChangesLog changesLog : this.changesLogs) {
            size += changesLog.getSize();
        }
        return size;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public ItemState getItemState(String itemIdentifier) {
        for (int i = this.changesLogs.size() - 1; i >= 0; --i) {
            PlainChangesLog changesLog = this.changesLogs.get(i);
            ItemState state = ((PlainChangesLogImpl)changesLog).getItemState(itemIdentifier);
            if (state == null) continue;
            return state;
        }
        return null;
    }

    public ItemState getItemState(NodeData parentData, QPathEntry name, ItemType itemType) {
        for (int i = this.changesLogs.size() - 1; i >= 0; --i) {
            PlainChangesLog changesLog = this.changesLogs.get(i);
            try {
                ItemState state = ((PlainChangesLogImpl)changesLog).getItemState(parentData, name, itemType);
                if (state == null) continue;
                return state;
            }
            catch (IllegalPathException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return null;
    }

    public List<ItemState> getChildrenChanges(String rootIdentifier, boolean forNodes) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (PlainChangesLog changesLog : this.changesLogs) {
            List<ItemState> subList = ((PlainChangesLogImpl)changesLog).getChildrenChanges(rootIdentifier, forNodes);
            list.addAll(subList);
        }
        return list;
    }

    @Override
    public String dump() {
        StringBuilder str = new StringBuilder("ChangesLog: size").append(this.changesLogs.size()).append("\n ");
        for (PlainChangesLog cLog : this.changesLogs) {
            str.append(cLog.dump()).append("\n");
        }
        return str.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.systemId != null) {
            out.writeInt(1);
            byte[] buff = this.systemId.getBytes("UTF-8");
            out.writeInt(buff.length);
            out.write(buff);
        } else {
            out.writeInt(-1);
        }
        int listSize = this.changesLogs.size();
        out.writeInt(listSize);
        for (int i = 0; i < listSize; ++i) {
            out.writeObject(this.changesLogs.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readInt() == 1) {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            this.systemId = new String(buf, "UTF-8");
        }
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.changesLogs.add((PlainChangesLog)in.readObject());
        }
    }
}

