/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.LexicalScope;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AssignOperation;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.util.Lists;
import com.google.caja.util.Sets;
import com.google.caja.util.SyntheticAttributeKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScopeAnalyzer {
    private static final SyntheticAttributeKey<LexicalScope> CONTAINING_SCOPE = new SyntheticAttributeKey<LexicalScope>(LexicalScope.class, "containingScope");
    private static final SyntheticAttributeKey<LexicalScope> DEFINING_SCOPE = new SyntheticAttributeKey<LexicalScope>(LexicalScope.class, "definingScope");
    static final Collection<String> ECMASCRIPT_BUILTINS = Collections.unmodifiableCollection(Sets.newLinkedHashSet("Array", "Boolean", "Date", "decodeURI", "decodeURIComponent", "encodeURI", "encodeURIComponent", "Error", "EvalError", "Function", "Infinity", "isFinite", "isNaN", "Number", "Object", "parseFloat", "parseInt", "Math", "NaN", "RangeError", "ReferenceError", "RegExp", "String", "SyntaxError", "TypeError", "URIError", "undefined"));

    ScopeAnalyzer() {
    }

    protected boolean introducesScope(AncestorChain<?> ac) {
        Object node = ac.node;
        return node instanceof FunctionConstructor || node instanceof CatchStmt || node instanceof WithStmt;
    }

    protected boolean hoist(AncestorChain<?> d, LexicalScope s) {
        if (d.node instanceof Declaration && s.isCatchScope()) {
            return d.parent != null && !(d.parent.node instanceof CatchStmt);
        }
        return s.isWithScope();
    }

    protected void initScope(LexicalScope scope) {
        if (scope.isFunctionScope()) {
            AncestorChain<FunctionConstructor> fn = scope.root.cast(FunctionConstructor.class);
            if (((FunctionConstructor)fn.node).getIdentifierName() != null) {
                scope.symbols.declare(((FunctionConstructor)fn.node).getIdentifierName(), fn);
            }
            scope.symbols.declare("this", fn);
            scope.symbols.declare("arguments", fn);
        } else if (scope.parent == null) {
            for (String builtin : ECMASCRIPT_BUILTINS) {
                scope.symbols.declare(builtin, scope.root);
            }
        }
    }

    final List<LexicalScope> computeLexicalScopes(AncestorChain<?> root) {
        LexicalScope globalScope = new LexicalScope(root, null);
        this.initScope(globalScope);
        List<LexicalScope> scopes = Lists.newArrayList(globalScope);
        this.computeLexicalScopes(root, globalScope, scopes);
        return scopes;
    }

    /*
     * WARNING - void declaration
     */
    private void computeLexicalScopes(AncestorChain<?> ac, LexicalScope parent, List<LexicalScope> scopes) {
        LexicalScope scope = parent;
        if (this.introducesScope(ac) && scope.root != ac) {
            scope = new LexicalScope(ac, parent);
            scopes.add(scope);
            this.initScope(scope);
        }
        assert (ac.node instanceof Identifier || !ac.node.getAttributes().containsKey(CONTAINING_SCOPE)) : "Scope already attached to node";
        ac.node.getAttributes().set(CONTAINING_SCOPE, scope);
        if (ac.node instanceof Declaration) {
            void var6_7;
            AncestorChain<Declaration> d = ac.cast(Declaration.class);
            LexicalScope lexicalScope = scope;
            while (var6_7.parent != null && this.hoist(d, (LexicalScope)var6_7)) {
                LexicalScope lexicalScope2 = var6_7.parent;
            }
            ac.node.getAttributes().set(DEFINING_SCOPE, var6_7);
            var6_7.symbols.declare(ac.cast(Declaration.class));
        }
        for (ParseTreeNode parseTreeNode : ac.node.children()) {
            this.computeLexicalScopes(AncestorChain.instance(ac, parseTreeNode), scope, scopes);
        }
    }

    List<Use> getUses(AncestorChain<?> root) {
        List<Use> uses = Lists.newArrayList();
        ScopeAnalyzer.findUses(root, uses);
        return uses;
    }

    private static void findUses(AncestorChain<?> ac, List<Use> out) {
        Operator op;
        if (ac.node instanceof Reference) {
            out.add(new Use(ac.cast(Reference.class)));
            return;
        }
        if (ac.node instanceof Operation && (op = ((Operation)ac.cast(Operation.class).node).getOperator()) == Operator.MEMBER_ACCESS) {
            ScopeAnalyzer.findUses(AncestorChain.instance(ac, ac.node.children().get(0)), out);
            return;
        }
        for (ParseTreeNode parseTreeNode : ac.node.children()) {
            ScopeAnalyzer.findUses(AncestorChain.instance(ac, parseTreeNode), out);
        }
    }

    static LexicalScope containingScopeForNode(ParseTreeNode node) {
        return node.getAttributes().get(CONTAINING_SCOPE);
    }

    static LexicalScope definingScopeForNode(Declaration decl) {
        return decl.getAttributes().get(DEFINING_SCOPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Use {
        final AncestorChain<? extends Reference> ref;

        Use(AncestorChain<? extends Reference> usage) {
            this.ref = usage;
        }

        boolean isLeftHandSideExpression() {
            AncestorChain<ParseTreeNode> ac = this.ref;
            while (Use.isObjectInMemberAccess(ac)) {
                ac = ac.parent;
            }
            return ac.parent != null && ac.parent.node instanceof AssignOperation && ac.node == ac.parent.node.children().get(0);
        }

        boolean isMemberAccess() {
            return Use.isObjectInMemberAccess(this.ref);
        }

        private static boolean isObjectInMemberAccess(AncestorChain<?> ac) {
            if (ac.parent == null || !(ac.parent.node instanceof Operation)) {
                return false;
            }
            Operator op = ((Operation)ac.parent.cast(Operation.class).node).getOperator();
            return op == Operator.MEMBER_ACCESS || op == Operator.SQUARE_BRACKET && ac.node == ac.parent.node.children().get(0);
        }

        String getSymbolName() {
            return ((Reference)this.ref.node).getIdentifierName();
        }
    }
}

