/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import org.exoplatform.ecm.webui.component.explorer.search.UIConstraintsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/search/UICompareExactlyForm.gtmpl", events={@EventConfig(listeners={SelectActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UICompareExactlyForm
extends UIForm
implements UIPopupComponent {
    private static final String FILTER = "filter";
    private static final String RESULT = "result";
    private static final String TEMP_RESULT = "tempSel";
    private List<String> listValue_;

    public void activate() {
    }

    public void deActivate() {
    }

    public void init(String properties, QueryResult result) throws Exception {
        this.listValue_ = new ArrayList<String>();
        ArrayList<SelectItemOption> opts = new ArrayList<SelectItemOption>();
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FILTER, FILTER, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(RESULT, RESULT, opts).setSize(15).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TEMP_RESULT, TEMP_RESULT, opts));
        NodeIterator iter = result.getNodes();
        String[] props = new String[]{};
        if (properties.indexOf(",") > -1) {
            props = properties.split(",");
        }
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (props.length > 0) {
                for (String pro : props) {
                    if (!node.hasProperty(pro)) continue;
                    Property property = node.getProperty(pro);
                    this.setPropertyResult(property);
                }
                continue;
            }
            if (!node.hasProperty(properties)) continue;
            Property property = node.getProperty(properties);
            this.setPropertyResult(property);
        }
        Collections.sort(this.listValue_);
        for (String value : this.listValue_) {
            opts.add(new SelectItemOption(value, (Object)value));
        }
    }

    public void setPropertyResult(Property property) throws Exception {
        if (property.getDefinition().isMultiple()) {
            Value[] values;
            for (Value value : values = property.getValues()) {
                if (this.listValue_.contains(value.getString())) continue;
                this.listValue_.add(value.getString());
            }
        } else {
            Value value = property.getValue();
            if (!this.listValue_.contains(value.getString())) {
                this.listValue_.add(value.getString());
            }
        }
    }

    public static class SelectActionListener
    extends EventListener<UICompareExactlyForm> {
        public void execute(Event<UICompareExactlyForm> event) throws Exception {
            UICompareExactlyForm uiForm = (UICompareExactlyForm)((Object)event.getSource());
            String value = (String)uiForm.getUIFormSelectBox(UICompareExactlyForm.RESULT).getValue();
            UIPopupContainer uiPopupAction = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            UISearchContainer uiSearchContainer = (UISearchContainer)uiPopupAction.getParent();
            UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)uiSearchContainer.findFirstComponentOfType(UIConstraintsForm.class);
            uiConstraintsForm.getUIStringInput("containExactly").setValue((Object)value);
            uiPopupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiConstraintsForm);
        }
    }

    public static class CancelActionListener
    extends EventListener<UICompareExactlyForm> {
        public void execute(Event<UICompareExactlyForm> event) throws Exception {
            UISearchContainer uiSearchContainer = (UISearchContainer)((UICompareExactlyForm)((Object)event.getSource())).getAncestorOfType(UISearchContainer.class);
            UIPopupContainer uiPopup = (UIPopupContainer)uiSearchContainer.getChild(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

