/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.versions.UIDiff;
import org.exoplatform.ecm.webui.component.explorer.versions.UILabelForm;
import org.exoplatform.ecm.webui.component.explorer.versions.UIRemoveLabelForm;
import org.exoplatform.ecm.webui.component.explorer.versions.UIViewVersion;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/versions/UIVersionInfo.gtmpl", events={@EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={RestoreVersionActionListener.class}), @EventConfig(listeners={ViewVersionActionListener.class}), @EventConfig(listeners={AddLabelActionListener.class}), @EventConfig(listeners={CompareVersionActionListener.class}), @EventConfig(listeners={DeleteVersionActionListener.class}, confirm="UIVersionInfo.msg.confirm-delete"), @EventConfig(listeners={RemoveLabelActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={CloseViewActionListener.class})})
public class UIVersionInfo
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIVersionInfo.class.getName());
    protected VersionNode rootVersion_;
    protected VersionNode curentVersion_;
    protected NodeLocation node_;

    public UIVersionInfo() throws Exception {
        ((UILabelForm)this.addChild(UILabelForm.class, null, null)).setRendered(false);
        ((UIRemoveLabelForm)this.addChild(UIRemoveLabelForm.class, null, null)).setRendered(false);
        ((UIViewVersion)this.addChild(UIViewVersion.class, null, null)).setRendered(false);
        ((UIDiff)this.addChild(UIDiff.class, null, null)).setRendered(false);
    }

    public String[] getVersionLabels(VersionNode version) throws Exception {
        VersionHistory vH = NodeLocation.getNodeByLocation((NodeLocation)this.node_).getVersionHistory();
        Version versionNode = vH.getVersion(version.getName());
        return vH.getVersionLabels(versionNode);
    }

    public boolean isBaseVersion(VersionNode versionNode) throws Exception {
        return NodeLocation.getNodeByLocation((NodeLocation)this.node_).getBaseVersion().getName().equals(versionNode.getName());
    }

    public VersionNode getRootVersionNode() throws Exception {
        return this.rootVersion_;
    }

    public void activate() {
        block3: {
            try {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
                if (this.node_ == null) {
                    this.node_ = NodeLocation.getNodeLocationByNode((Node)uiExplorer.getCurrentNode());
                }
                this.curentVersion_ = this.rootVersion_ = new VersionNode(NodeLocation.getNodeByLocation((NodeLocation)this.node_).getVersionHistory().getRootVersion(), uiExplorer.getSession());
                ((UIViewVersion)this.getChild(UIViewVersion.class)).update();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Unexpected error!", new Object[]{e.getMessage()});
            }
        }
    }

    public void deActivate() {
    }

    public VersionNode getCurrentVersionNode() {
        return this.curentVersion_;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.node_);
    }

    public void setCurrentNode(Node node) {
        this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public boolean isViewVersion() {
        UIViewVersion uiViewVersion = (UIViewVersion)this.getChild(UIViewVersion.class);
        return uiViewVersion.isRendered();
    }

    public static class CloseViewActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIViewVersion uiViewVersion = (UIViewVersion)uiVersionInfo.getChild(UIViewVersion.class);
            if (uiViewVersion.isRendered()) {
                uiViewVersion.setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
                return;
            }
        }
    }

    public static class CloseActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                if (!uiChild.isRendered()) continue;
                uiChild.setRendered(false);
                return;
            }
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class SelectActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            VersionNode selectedVersion;
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            VersionNode root = uiVersionInfo.getRootVersionNode();
            selectedVersion.setExpanded(!(selectedVersion = root.findVersionNode(path)).isExpanded());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    public static class CompareVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            VersionNode node = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            UIDiff uiDiff = (UIDiff)uiVersionInfo.getChild(UIDiff.class);
            uiDiff.setVersions(uiVersionInfo.getCurrentNode().getBaseVersion(), node.getName(), node.getCreatedTime(), node.getWs(), node.getPath());
            uiDiff.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    public static class DeleteVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            Node node = uiVersionInfo.getCurrentNode();
            VersionHistory versionHistory = node.getVersionHistory();
            UIApplication app = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
            try {
                versionHistory.removeVersion(uiVersionInfo.curentVersion_.getName());
                uiVersionInfo.rootVersion_.removeVersionInChild(uiVersionInfo.rootVersion_, uiVersionInfo.curentVersion_);
                uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_ = new VersionNode(node.getVersionHistory().getRootVersion(), uiExplorer.getSession());
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                uiExplorer.getSession().save();
                event.getRequestContext().addUIComponentToUpdateByAjax(uiVersionInfo.getAncestorOfType(UIPopupContainer.class));
            }
            catch (ReferentialIntegrityException rie) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)rie);
                }
                app.addMessage(new ApplicationMessage("UIVersionInfo.msg.cannot-remove-version", null));
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                }
                app.addMessage(new ApplicationMessage("UIVersionInfo.msg.cannot-remove-version", null));
                return;
            }
        }
    }

    public static class RestoreVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            Node node;
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            UIApplication uiApp = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
            uiExplorer.addLockToken(NodeLocation.getNodeByLocation((NodeLocation)uiVersionInfo.node_));
            try {
                Node restoredNode = NodeLocation.getNodeByLocation((NodeLocation)uiVersionInfo.node_);
                String versionName = uiVersionInfo.curentVersion_.getName();
                restoredNode.restore(versionName, true);
                ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
                try {
                    if (listenerService != null && activityService != null && activityService.isAcceptedNode(restoredNode)) {
                        listenerService.broadcast(ActivityCommonService.NODE_REVISION_CHANGED, (Object)restoredNode, (Object)versionName);
                    }
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Can not notify NodeMovedActivity: " + e.getMessage()));
                    }
                }
            }
            catch (JCRInvalidItemStateException invalid) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                return;
            }
            catch (NullPointerException nuException) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                return;
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                return;
            }
            if (!(node = uiVersionInfo.getCurrentNode()).isCheckedOut()) {
                node.checkout();
            }
            uiExplorer.getSession().save();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
            uiExplorer.setIsHidePopup(true);
            uiExplorer.updateAjax(event);
        }
    }

    public static class RemoveLabelActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            ((UIRemoveLabelForm)uiVersionInfo.getChild(UIRemoveLabelForm.class)).update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    public static class AddLabelActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            ((UILabelForm)uiVersionInfo.getChild(UILabelForm.class)).setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    public static class ViewVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            UIViewVersion uiViewVersion = (UIViewVersion)uiVersionInfo.getChild(UIViewVersion.class);
            Node frozenNode = uiVersionInfo.curentVersion_.getNode("jcr:frozenNode");
            uiViewVersion.setNode(frozenNode);
            if (uiViewVersion.getTemplate() == null || uiViewVersion.getTemplate().trim().length() == 0) {
                UIApplication uiApp = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.have-no-view-template", null));
                return;
            }
            uiViewVersion.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }
}

