/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.organization.GroupHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserProfileHandlerImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MigrationTool {
    private JCROrganizationServiceImpl service;
    private String storagePathOld;
    private String usersStorageOld;
    private String groupsStorageOld;
    private String membershipTypesStorageOld;
    public static final String JOS_USER_MEMBERSHIP = "jos:userMembership";
    public static final String JOS_GROUP = "jos:group";
    public static final String JOS_ATTRIBUTES = "jos:attributes";
    public static final String JOS_ORGANIZATION_NODETYPE_OLD = "jos:organizationStorage";
    public static final String JOS_PARENT_ID = "jos:parentId";
    public static final String JOS_GROUP_ID = "jos:groupId";
    private static final Log LOG = ExoLogger.getLogger((String)"exo-jcr-services.MigrationTool");

    MigrationTool(JCROrganizationServiceImpl service) throws RepositoryException {
        this.service = service;
        this.storagePathOld = service.getStoragePath() + "-old";
        this.usersStorageOld = this.storagePathOld + "/" + "jos:users";
        this.groupsStorageOld = this.storagePathOld + "/" + "jos:groups";
        this.membershipTypesStorageOld = this.storagePathOld + "/" + "jos:membershipTypes";
    }

    void migrate() throws RepositoryException {
        try {
            LOG.info((Object)"Migration started.");
            this.moveOldStructure();
            this.service.createStructure();
            this.migrateGroups();
            this.migrateMembershipTypes();
            this.migrateUsers();
            this.migrateProfiles();
            this.migrateMemberships();
            this.removeOldStructure();
            LOG.info((Object)"Migration completed.");
        }
        catch (Exception e) {
            throw new RepositoryException("Migration failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean migrationRequired() throws RepositoryException {
        Session session = this.service.getStorageSession();
        try {
            if (session.itemExists(this.storagePathOld)) {
                boolean bl = true;
                return bl;
            }
            Node node = (Node)session.getItem(this.service.getStoragePath());
            boolean bl = node.isNodeType(JOS_ORGANIZATION_NODETYPE_OLD);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveOldStructure() throws Exception {
        ExtendedSession session = (ExtendedSession)this.service.getStorageSession();
        try {
            if (session.itemExists(this.storagePathOld)) {
                return;
            }
            session.move(this.service.getStoragePath(), this.storagePathOld, false);
            session.save();
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldStructure() throws RepositoryException {
        ExtendedSession session = (ExtendedSession)this.service.getStorageSession();
        try {
            if (session.itemExists(this.storagePathOld)) {
                NodeIterator usersIter = ((ExtendedNode)session.getItem(this.usersStorageOld)).getNodesLazily();
                while (usersIter.hasNext()) {
                    Node currentUser = usersIter.nextNode();
                    currentUser.remove();
                    session.save();
                }
                NodeIterator groupsIter = ((ExtendedNode)session.getItem(this.groupsStorageOld)).getNodesLazily();
                while (groupsIter.hasNext()) {
                    Node currentGroup = groupsIter.nextNode();
                    currentGroup.remove();
                    session.save();
                }
                NodeIterator membershipTypesIter = ((ExtendedNode)session.getItem(this.membershipTypesStorageOld)).getNodesLazily();
                while (membershipTypesIter.hasNext()) {
                    Node currentMembershipType = membershipTypesIter.nextNode();
                    currentMembershipType.remove();
                    session.save();
                }
                session.getItem(this.storagePathOld).remove();
                session.save();
            }
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateUsers() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            if (session.itemExists(this.usersStorageOld)) {
                NodeIterator iterator = ((ExtendedNode)session.getItem(this.usersStorageOld)).getNodesLazily();
                UserHandlerImpl uh = (UserHandlerImpl)this.service.getUserHandler();
                while (iterator.hasNext()) {
                    uh.migrateUser(iterator.nextNode());
                }
            }
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateGroups() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            if (session.itemExists(this.groupsStorageOld)) {
                NodeIterator iterator = ((ExtendedNode)session.getItem(this.groupsStorageOld)).getNodesLazily();
                GroupHandlerImpl gh = (GroupHandlerImpl)this.service.getGroupHandler();
                while (iterator.hasNext()) {
                    Node oldGroupNode = iterator.nextNode();
                    gh.migrateGroup(oldGroupNode);
                    this.migrateGroups(oldGroupNode);
                }
            }
        }
        finally {
            session.logout();
        }
    }

    private void migrateGroups(Node startNode) throws Exception {
        NodeIterator iterator = ((ExtendedNode)startNode).getNodesLazily();
        GroupHandlerImpl gh = (GroupHandlerImpl)this.service.getGroupHandler();
        while (iterator.hasNext()) {
            Node oldGroupNode = iterator.nextNode();
            gh.migrateGroup(oldGroupNode);
            this.migrateGroups(oldGroupNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateMembershipTypes() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            if (session.itemExists(this.membershipTypesStorageOld)) {
                NodeIterator iterator = ((ExtendedNode)session.getItem(this.membershipTypesStorageOld)).getNodesLazily();
                MembershipTypeHandlerImpl mth = (MembershipTypeHandlerImpl)this.service.getMembershipTypeHandler();
                while (iterator.hasNext()) {
                    Node oldTypeNode = iterator.nextNode();
                    mth.migrateMembershipType(oldTypeNode);
                }
            }
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateProfiles() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            if (session.itemExists(this.usersStorageOld)) {
                NodeIterator iterator = ((ExtendedNode)session.getItem(this.usersStorageOld)).getNodesLazily();
                UserProfileHandlerImpl uph = (UserProfileHandlerImpl)this.service.getUserProfileHandler();
                while (iterator.hasNext()) {
                    Node oldUserNode = iterator.nextNode();
                    uph.migrateProfile(oldUserNode);
                }
            }
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateMemberships() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            if (session.itemExists(this.usersStorageOld)) {
                NodeIterator iterator = ((ExtendedNode)session.getItem(this.usersStorageOld)).getNodesLazily();
                MembershipHandlerImpl mh = (MembershipHandlerImpl)this.service.getMembershipHandler();
                while (iterator.hasNext()) {
                    Node oldUserNode = iterator.nextNode();
                    mh.migrateMemberships(oldUserNode);
                    oldUserNode.remove();
                    session.save();
                }
            }
        }
        finally {
            session.logout();
        }
    }
}

