/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.match.AnyBlockMatcher;
import org.xwiki.rendering.block.match.BlockMatcher;

public class BlockNavigator {
    private BlockMatcher matcher;

    public BlockNavigator() {
        this.matcher = AnyBlockMatcher.ANYBLOCKMATCHER;
    }

    public BlockNavigator(BlockMatcher matcher) {
        this.matcher = matcher;
    }

    public <T extends Block> List<T> getBlocks(Block currentBlock, Block.Axes currentAxes) {
        List blocks = new ArrayList();
        Block block = currentBlock;
        Block.Axes axes = currentAxes;
        while (block != null) {
            Block nextBlock = null;
            switch (axes) {
                case SELF: {
                    this.addBlock(block, blocks);
                    break;
                }
                case ANCESTOR_OR_SELF: {
                    this.addBlock(block, blocks);
                    nextBlock = block.getParent();
                    break;
                }
                case ANCESTOR: {
                    nextBlock = block.getParent();
                    axes = Block.Axes.ANCESTOR_OR_SELF;
                    break;
                }
                case PARENT: {
                    nextBlock = block.getParent();
                    axes = Block.Axes.SELF;
                    break;
                }
                case CHILD: {
                    if (block.getChildren().isEmpty()) break;
                    nextBlock = block.getChildren().get(0);
                    axes = Block.Axes.FOLLOWING_SIBLING;
                    this.addBlock(nextBlock, blocks);
                    break;
                }
                case DESCENDANT_OR_SELF: {
                    this.addBlock(block, blocks);
                    blocks = this.getBlocks(block.getChildren(), Block.Axes.DESCENDANT_OR_SELF, blocks);
                    break;
                }
                case DESCENDANT: {
                    blocks = this.getBlocks(block.getChildren(), Block.Axes.DESCENDANT_OR_SELF, blocks);
                    break;
                }
                case FOLLOWING_SIBLING: {
                    nextBlock = block.getNextSibling();
                    this.addBlock(nextBlock, blocks);
                    break;
                }
                case FOLLOWING: {
                    for (Block nextSibling = block.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                        blocks = this.getBlocks(nextSibling, Block.Axes.DESCENDANT_OR_SELF, blocks);
                    }
                    break;
                }
                case PRECEDING_SIBLING: {
                    nextBlock = block.getPreviousSibling();
                    this.addBlock(nextBlock, blocks);
                    break;
                }
                case PRECEDING: {
                    for (Block previousSibling = block.getPreviousSibling(); previousSibling != null; previousSibling = previousSibling.getPreviousSibling()) {
                        blocks = this.getBlocks(previousSibling, Block.Axes.DESCENDANT_OR_SELF, blocks);
                    }
                    break;
                }
            }
            block = nextBlock;
        }
        return blocks != null ? blocks : Collections.emptyList();
    }

    private <T extends Block> void addBlock(Block currentBlock, List<T> blocks) {
        if (currentBlock != null && this.matcher.match(currentBlock)) {
            blocks.add(currentBlock);
        }
    }

    private <T extends Block> List<T> getBlocks(List<Block> blocks, Block.Axes axes, List<T> blocksOut) {
        List<T> newBlocks = blocksOut;
        for (Block block : blocks) {
            newBlocks = this.getBlocks(block, axes, newBlocks);
        }
        return newBlocks;
    }

    private <T extends Block> List<T> getBlocks(Block currentBlock, Block.Axes axes, List<T> blocksOut) {
        List<T> newBlocks = blocksOut;
        List<T> nextBlocks = this.getBlocks(currentBlock, axes);
        if (!nextBlocks.isEmpty()) {
            if (newBlocks == null) {
                newBlocks = nextBlocks;
            } else {
                newBlocks.addAll(nextBlocks);
            }
        }
        return newBlocks;
    }

    public <T extends Block> T getFirstBlock(Block currentBlock, Block.Axes currentAxes) {
        Block block = currentBlock;
        Block.Axes axes = currentAxes;
        while (block != null) {
            Block nextBlock = null;
            switch (axes) {
                case SELF: {
                    if (!this.matcher.match(block)) break;
                    return (T)block;
                }
                case ANCESTOR_OR_SELF: {
                    if (this.matcher.match(block)) {
                        return (T)block;
                    }
                }
                case ANCESTOR: 
                case PARENT: {
                    axes = axes == Block.Axes.PARENT ? Block.Axes.SELF : Block.Axes.ANCESTOR_OR_SELF;
                    nextBlock = block.getParent();
                    break;
                }
                case CHILD: {
                    List<Block> children = block.getChildren();
                    if (children.isEmpty()) break;
                    nextBlock = children.get(0);
                    axes = Block.Axes.FOLLOWING_SIBLING;
                    if (!this.matcher.match(nextBlock)) break;
                    return (T)nextBlock;
                }
                case DESCENDANT_OR_SELF: {
                    if (this.matcher.match(block)) {
                        return (T)block;
                    }
                }
                case DESCENDANT: {
                    for (Block child : block.getChildren()) {
                        T matchedBlock = this.getFirstBlock(child, Block.Axes.DESCENDANT_OR_SELF);
                        if (matchedBlock == null) continue;
                        return matchedBlock;
                    }
                    break;
                }
                case FOLLOWING_SIBLING: {
                    nextBlock = block.getNextSibling();
                    if (nextBlock == null || !this.matcher.match(nextBlock)) break;
                    return (T)nextBlock;
                }
                case FOLLOWING: {
                    T matchedBlock;
                    for (Block nextSibling = block.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                        matchedBlock = this.getFirstBlock(nextSibling, Block.Axes.DESCENDANT_OR_SELF);
                        if (matchedBlock == null) continue;
                        return matchedBlock;
                    }
                    break;
                }
                case PRECEDING_SIBLING: {
                    nextBlock = block.getPreviousSibling();
                    if (nextBlock == null || !this.matcher.match(nextBlock)) break;
                    return (T)nextBlock;
                }
                case PRECEDING: {
                    T matchedBlock;
                    for (Block previousSibling = block.getPreviousSibling(); previousSibling != null; previousSibling = previousSibling.getPreviousSibling()) {
                        matchedBlock = this.getFirstBlock(previousSibling, Block.Axes.DESCENDANT_OR_SELF);
                        if (matchedBlock == null) continue;
                        return matchedBlock;
                    }
                    break;
                }
            }
            block = nextBlock;
        }
        return (T)block;
    }
}

