/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.syntax;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.syntax.SyntaxType;

public class Syntax {
    public static final Syntax XHTML_1_0 = new Syntax(SyntaxType.XHTML, "1.0");
    public static final Syntax HTML_4_01 = new Syntax(SyntaxType.HTML, "4.01");
    public static final Syntax XWIKI_1_0 = new Syntax(SyntaxType.XWIKI, "1.0");
    public static final Syntax XWIKI_2_0 = new Syntax(SyntaxType.XWIKI, "2.0");
    public static final Syntax XWIKI_2_1 = new Syntax(SyntaxType.XWIKI, "2.1");
    public static final Syntax PLAIN_1_0 = new Syntax(SyntaxType.PLAIN, "1.0");
    public static final Syntax EVENT_1_0 = new Syntax(SyntaxType.EVENT, "1.0");
    public static final Syntax TEX_1_0 = new Syntax(SyntaxType.TEX, "1.0");
    public static final Syntax CREOLE_1_0 = new Syntax(SyntaxType.CREOLE, "1.0");
    public static final Syntax JSPWIKI_1_0 = new Syntax(SyntaxType.JSPWIKI, "1.0");
    public static final Syntax MEDIAWIKI_1_0 = new Syntax(SyntaxType.MEDIAWIKI, "1.0");
    public static final Syntax TWIKI_1_0 = new Syntax(SyntaxType.TWIKI, "1.0");
    public static final Syntax DOCBOOK_4_4 = new Syntax(SyntaxType.DOCBOOK, "4.4");
    public static final Syntax CONFLUENCE_1_0 = new Syntax(SyntaxType.CONFLUENCE, "1.0");
    public static final Syntax CONFLUENCEXHTML_1_0 = new Syntax(SyntaxType.CONFLUENCEXHTML, "1.0");
    public static final Syntax XDOMXML_CURRENT = new Syntax(SyntaxType.XDOMXML, "current");
    public static final Syntax XDOMXML_1_0 = new Syntax(SyntaxType.XDOMXML, "1.0");
    public static final Syntax MARKDOWN_1_0 = new Syntax(SyntaxType.MARKDOWN, "1.0");
    public static final Syntax MARKDOWN_1_1 = new Syntax(SyntaxType.MARKDOWN, "1.1");
    public static final Syntax APT_1_0 = new Syntax(SyntaxType.APT, "1.0");
    public static final Syntax ANNOTATED_XHTML_1_0 = new Syntax(SyntaxType.ANNOTATED_XHTML, "1.0");
    private SyntaxType type;
    private String version;
    private String qualifier;

    public Syntax(SyntaxType type, String version) {
        this.type = type;
        this.version = version;
    }

    public Syntax(SyntaxType type, String version, String qualifier) {
        this(type, version);
        this.qualifier = qualifier;
    }

    public SyntaxType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toIdString() {
        return this.getType().getId() + "/" + this.getVersion().toLowerCase();
    }

    public String toString() {
        return this.getType().toString() + " " + this.getVersion() + (this.getQualifier() != null ? " (" + this.getQualifier() + ")" : "");
    }

    public int hashCode() {
        return new HashCodeBuilder(5, 7).append((Object)this.getType()).append((Object)this.getVersion()).append((Object)this.getQualifier()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Syntax rhs = (Syntax)object;
        return new EqualsBuilder().append((Object)this.getType(), (Object)rhs.getType()).append((Object)this.getVersion(), (Object)rhs.getVersion()).append((Object)this.getQualifier(), (Object)rhs.getQualifier()).isEquals();
    }
}

