/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel;

import org.xwiki.rendering.wikimodel.WikiPageUtil;

public class WikiParameter {
    private String fKey;
    private String fStr;
    private Boolean fValid;
    private String fValue;

    public WikiParameter(String key, String value) {
        this.fKey = key;
        this.fValue = value;
    }

    public WikiParameter(WikiParameter pair) {
        this.fKey = pair.getKey();
        this.fValue = pair.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WikiParameter)) {
            return false;
        }
        WikiParameter pair = (WikiParameter)obj;
        return this.fKey.equals(pair.fKey) && (this.fValue == pair.fValue || this.fValue != null && this.fValue.equals(pair.fValue));
    }

    public String getKey() {
        return this.fKey;
    }

    public String getValue() {
        return this.fValue;
    }

    public int hashCode() {
        return this.fKey.hashCode() ^ (this.fValue != null ? this.fValue.hashCode() : 0);
    }

    public boolean isValid() {
        if (this.fValid == null) {
            int len = this.fKey != null ? this.fKey.length() : 0;
            boolean result = len > 0;
            boolean delimiter = false;
            for (int i = 0; result && i < len; ++i) {
                char ch = this.fKey.charAt(i);
                if (ch == ':') {
                    result = !delimiter && i > 0 && i < len - 1;
                    delimiter = true;
                    continue;
                }
                if (ch == '.' || ch == '-') {
                    result = i > 0 && i < len - 1;
                    continue;
                }
                result &= i == 0 && Character.isLetter(ch) || Character.isLetterOrDigit(ch);
            }
            this.fValid = result ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.fValid == Boolean.TRUE;
    }

    public String toString() {
        if (this.fStr == null) {
            this.fStr = this.fKey + "='" + WikiPageUtil.escapeXmlAttribute(this.fValue) + "'";
        }
        return this.fStr;
    }
}

