/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.integration;

import javax.jcr.Session;
import org.exoplatform.platform.organization.integration.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;

public class NewMembershipListener
extends MembershipEventListener {
    private static final Log LOG = ExoLogger.getLogger(NewMembershipListener.class);
    private RepositoryService repositoryService;

    public NewMembershipListener(RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Membership m, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (Util.hasUserFolder(session, m.getUserName())) {
                if (!Util.hasMembershipFolder(session, m)) {
                    Util.createMembershipFolder(session, m);
                }
            } else {
                LOG.warn((Object)("Membership listeners can't be invoked on membership '" + m + "' because the user isn't synchronized yet."));
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(Membership m) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (Util.hasMembershipFolder(session, m)) {
                Util.deleteMembershipFolder(session, m);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

