/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.sso;

import org.exoplatform.container.xml.InitParams;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class SSOHelper {
    private final boolean ssoEnabled;
    private final boolean skipJSPRedirection;
    private final String ssoRedirectURLSuffix;
    private static final Logger log = LoggerFactory.getLogger(SSOHelper.class);

    public SSOHelper(InitParams params) {
        String ssoEnabledParam = params.getValueParam("isSSOEnabled").getValue();
        this.ssoEnabled = Boolean.parseBoolean(ssoEnabledParam);
        String ssoJSPRedirectionEnabledParam = params.getValueParam("skipJSPRedirection").getValue();
        this.skipJSPRedirection = "false".equals(ssoJSPRedirectionEnabledParam) ? false : this.ssoEnabled;
        this.ssoRedirectURLSuffix = params.getValueParam("SSORedirectURLSuffix").getValue();
        log.debug((Object)("SSOHelper initialized. ssoEnabled: " + this.ssoEnabled + ", skipJSPRedirection: " + this.skipJSPRedirection + ", ssoRedirectURLSuffix: " + this.ssoRedirectURLSuffix));
    }

    public boolean isSSOEnabled() {
        return this.ssoEnabled;
    }

    public boolean skipJSPRedirection() {
        return this.skipJSPRedirection;
    }

    public String getSSORedirectURLSuffix() {
        return this.ssoRedirectURLSuffix;
    }
}

