/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeNodeTypeSpaceAccessPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeNodeTypeSpaceAccessPlugin.class);
    private RepositoryService repositoryService;

    public UpgradeNodeTypeSpaceAccessPlugin(InitParams initParams, RepositoryService repositoryService) throws Exception {
        super(initParams);
        this.repositoryService = repositoryService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start UpgradeNodeTypeSpaceAccessPlugin ...");
        try {
            ExtendedNodeTypeManager nodeTypeManager = this.repositoryService.getCurrentRepository().getNodeTypeManager();
            try {
                nodeTypeManager.unregisterNodeType("plf:spaceaccess");
            }
            catch (Exception e) {
                LOG.info((Object)"plf:spaceaccess does not exist...");
            }
            LOG.info((Object)"Finish UpgradeNodeTypeSpaceAccessPlugin ...");
        }
        catch (Exception e) {
            LOG.error((Object)"UpgradeNodeTypeSpaceAccessPlugin: Upgrade Space nodeTypes failure", (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

