/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetomany.hierarchical;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.chromattic.core.EntityContext;
import org.chromattic.core.ThrowableFactory;
import org.chromattic.core.mapper.onetomany.hierarchical.AnyChildEntrySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyChildMap<E>
extends AbstractMap<String, E> {
    final EntityContext parentCtx;
    final String prefix;
    final Class<E> relatedClass;
    private final AnyChildEntrySet<E> entries;

    public AnyChildMap(EntityContext parentCtx, String prefix, Class<E> relatedClass) {
        this.relatedClass = relatedClass;
        this.prefix = prefix;
        this.entries = new AnyChildEntrySet(this);
        this.parentCtx = parentCtx;
    }

    @Override
    public E get(Object key) {
        Object child;
        String name;
        EntityContext childCtx;
        if (key instanceof String && (childCtx = this.parentCtx.getChild(this.prefix, name = (String)key)) != null && this.relatedClass.isInstance(child = childCtx.getObject())) {
            return this.relatedClass.cast(child);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String name = (String)key;
            return this.parentCtx.hasChild(this.prefix, name);
        }
        return false;
    }

    @Override
    public E remove(Object key) {
        if (key instanceof String) {
            return this.put((String)key, (E)null);
        }
        return null;
    }

    @Override
    public E put(String key, E value) {
        Object child;
        EntityContext childCtx = this.parentCtx.getChild(this.prefix, key);
        if (value == null) {
            if (childCtx != null) {
                this.parentCtx.getSession().remove(childCtx);
            }
        } else if (this.relatedClass.isInstance(value)) {
            EntityContext valueCtx = this.parentCtx.getSession().unwrapEntity(value);
            this.parentCtx.addChild(ThrowableFactory.ISE, ThrowableFactory.IAE, this.prefix, key, valueCtx);
        } else {
            throw new ClassCastException("Cannot put " + value + " with in map containing values of type " + this.relatedClass);
        }
        if (childCtx != null && this.relatedClass.isInstance(child = childCtx.getObject())) {
            return this.relatedClass.cast(child);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, E>> entrySet() {
        return this.entries;
    }
}

