/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.api.workspace.WorkspaceCustomizationContext;
import org.gatein.mop.core.api.workspace.WorkspaceObjectImpl;
import org.gatein.mop.core.api.workspace.content.CustomizationContainer;

@PrimaryType(name="mop:customizationcontext")
public abstract class WorkspaceCustomizationContextImpl
implements WorkspaceCustomizationContext {
    @Owner
    @OneToOne(type=RelationshipType.EMBEDDED)
    public abstract WorkspaceObjectImpl getOwner();

    @OneToOne
    @MappedBy(value="mop:customizations")
    @Owner
    public abstract CustomizationContainer getCustomizations();

    public String getContextType() {
        return "workspace";
    }

    public String getContextId() {
        return this.getOwner().getObjectId();
    }

    public boolean contains(CustomizationContext that) {
        return WorkspaceObjectImpl.contains((CustomizationContext)this, that);
    }

    public Customization<?> getCustomization(String name) {
        return this.getCustomizations().getCustomization(name);
    }

    public <S> Customization<S> customize(String name, ContentType<S> contentType, String contentId, S state) {
        return this.getCustomizations().customize(name, contentType, contentId, state);
    }

    public <S> Customization<S> customize(String name, Customization<S> customization) {
        return this.getCustomizations().customize(name, customization);
    }

    public String nameOf(Customization customization) {
        return this.getCustomizations().nameOf(customization);
    }
}

