/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class StaxNavException
extends RuntimeException {
    private Location location;

    public Location getLocation() {
        return this.location;
    }

    public StaxNavException(String message) {
        super(message);
    }

    public StaxNavException(String message, Throwable t) {
        super(message, t);
    }

    public StaxNavException(Location location) {
        this.location = location;
    }

    public StaxNavException(Location location, String message) {
        super(message);
        this.location = location;
    }

    public StaxNavException(Location location, String message, Throwable cause) {
        super(message, cause);
        this.location = location;
    }

    public StaxNavException(Location location, Throwable cause) {
        super(cause);
        this.location = location;
    }

    public StaxNavException(XMLStreamException cause) {
        super(cause);
        this.location = cause.getLocation();
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.location != null && !(this.getCause() instanceof XMLStreamException)) {
            StringBuilder sb = new StringBuilder().append(message);
            sb.append(" at [row,col]:[").append(this.location.getLineNumber()).append(",").append(this.location.getColumnNumber()).append("]");
            String systemId = this.location.getSystemId();
            if (systemId != null) {
                sb.append(" found at ").append(systemId);
            }
            return sb.toString();
        }
        return message;
    }
}

