/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.juzu.ajax;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.Response;
import juzu.impl.plugin.ServiceContext;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.application.ApplicationService;
import juzu.impl.plugin.controller.ControllerService;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.Stage;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.request.Phase;
import org.exoplatform.commons.juzu.ajax.Ajax;

public class AjaxService
extends ApplicationService
implements RequestFilter<Stage.Unmarshalling> {
    Map<String, ControllerHandler> table;
    @Inject
    ControllerService controllerService;

    public AjaxService() {
        super("plf4-ajax");
    }

    public ServiceDescriptor init(ServiceContext context) throws Exception {
        return context.getConfig() != null ? new ServiceDescriptor() : null;
    }

    @PostConstruct
    public void start() throws Exception {
        HashMap<String, ControllerHandler> table = new HashMap<String, ControllerHandler>();
        for (ControllerHandler cm : this.controllerService.getDescriptor().getHandlers()) {
            Ajax ajax = cm.getMethod().getAnnotation(Ajax.class);
            if (ajax == null) continue;
            table.put(cm.getName(), cm);
        }
        this.table = table;
    }

    public Class<Stage.Unmarshalling> getStageType() {
        return Stage.Unmarshalling.class;
    }

    public Response handle(Stage.Unmarshalling argument) {
        final Request request = argument.getRequest();
        Response result = argument.invoke();
        if (request.getPhase() == Phase.VIEW && result instanceof Response.Content) {
            Response.Status status = (Response.Status)result;
            final Streamable wrapped = status.streamable();
            Streamable wrapper = new Streamable(){

                public void send(final Stream stream) throws IllegalStateException {
                    Stream our = new Stream(){
                        boolean done = false;

                        public void provide(Chunk chunk) {
                            if (chunk instanceof Chunk.Data && !this.done) {
                                this.done = true;
                                StringBuilder sb = new StringBuilder();
                                sb.append("<div class=\"jz\">\n");
                                for (Map.Entry<String, ControllerHandler> entry : AjaxService.this.table.entrySet()) {
                                    String baseURL = request.createDispatch(entry.getValue()).toString();
                                    sb.append("<div data-method-id=\"");
                                    sb.append(entry.getValue().getId());
                                    sb.append("\" data-url=\"");
                                    sb.append(baseURL);
                                    sb.append("\"/>");
                                    sb.append("</div>");
                                }
                                stream.provide((Chunk)Chunk.create((CharSequence)sb));
                            }
                            stream.provide(chunk);
                        }

                        public void close(Thread.UncaughtExceptionHandler errorHandler) {
                            stream.provide((Chunk)Chunk.create((CharSequence)"</div>"));
                            stream.close(errorHandler);
                        }
                    };
                    wrapped.send(our);
                }
            };
            result = new Response.Content(status.getCode(), wrapper);
        }
        return result;
    }
}

