/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.tree;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;
import org.picketlink.idm.impl.tree.FqnComparator;

public class Fqn
implements Comparable<Fqn>,
Serializable {
    public static final String SEPARATOR = "/";
    private final Object[] elements;
    private transient int hash_code = 0;
    public static final Fqn ROOT = new Fqn(new Object[0]);
    protected String stringRepresentation;
    private static final Object[] EMPTY_ARRAY = ReflectionUtil.EMPTY_CLASS_ARRAY;

    private Fqn(Object ... elements) {
        this.elements = elements;
    }

    private Fqn(List<?> names) {
        this.elements = names != null ? names.toArray() : EMPTY_ARRAY;
    }

    private Fqn(Fqn base, Object ... relative) {
        this.elements = new Object[base.elements.length + relative.length];
        System.arraycopy(base.elements, 0, this.elements, 0, base.elements.length);
        System.arraycopy(relative, 0, this.elements, base.elements.length, relative.length);
    }

    public static Fqn fromList(List<?> names) {
        return new Fqn(names);
    }

    public static Fqn fromElements(Object ... elements) {
        Object[] copy = new Object[elements.length];
        System.arraycopy(elements, 0, copy, 0, elements.length);
        return new Fqn(copy);
    }

    public static Fqn fromRelativeFqn(Fqn base, Fqn relative) {
        return new Fqn(base, relative.elements);
    }

    public static Fqn fromRelativeList(Fqn base, List<?> relativeElements) {
        return new Fqn(base, relativeElements.toArray());
    }

    public static Fqn fromRelativeElements(Fqn base, Object ... relativeElements) {
        return new Fqn(base, relativeElements);
    }

    public static Fqn fromString(String stringRepresentation) {
        if (stringRepresentation == null || stringRepresentation.equals(SEPARATOR) || stringRepresentation.length() == 0) {
            return Fqn.root();
        }
        String toMatch = stringRepresentation.startsWith(SEPARATOR) ? stringRepresentation.substring(1) : stringRepresentation;
        Object[] el = toMatch.split(SEPARATOR);
        return new Fqn(el);
    }

    public Fqn getAncestor(int generation) {
        if (generation == 0) {
            return Fqn.root();
        }
        return this.getSubFqn(0, generation);
    }

    public Fqn getSubFqn(int startIndex, int endIndex) {
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("End index cannot be less than the start index!");
        }
        int len = endIndex - startIndex;
        Object[] el = new Object[len];
        System.arraycopy(this.elements, startIndex, el, 0, len);
        return new Fqn(el);
    }

    public int size() {
        return this.elements.length;
    }

    public Object get(int n) {
        return this.elements[n];
    }

    public Object getLastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this.elements[this.elements.length - 1];
    }

    public boolean hasElement(Object element) {
        return this.indexOf(element) != -1;
    }

    private int indexOf(Object element) {
        if (element == null) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!element.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        if (this.elements.length != other.elements.length) {
            return false;
        }
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (Util.safeEquals((Object)this.elements[i], (Object)other.elements[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this.calculateHashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.getStringRepresentation(this.elements);
        }
        return this.stringRepresentation;
    }

    public boolean isChildOf(Fqn parentFqn) {
        return parentFqn.elements.length != this.elements.length && this.isChildOrEquals(parentFqn);
    }

    public boolean isDirectChildOf(Fqn parentFqn) {
        return this.elements.length == parentFqn.elements.length + 1 && this.isChildOf(parentFqn);
    }

    public boolean isChildOrEquals(Fqn parentFqn) {
        Object[] parentEl = parentFqn.elements;
        if (parentEl.length > this.elements.length) {
            return false;
        }
        for (int i = parentEl.length - 1; i >= 0; --i) {
            if (Util.safeEquals((Object)parentEl[i], (Object)this.elements[i])) continue;
            return false;
        }
        return true;
    }

    protected int calculateHashCode() {
        int hashCode = 19;
        for (Object o : this.elements) {
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        if (hashCode == 0) {
            hashCode = -559038737;
        }
        return hashCode;
    }

    protected String getStringRepresentation(Object[] elements) {
        StringBuilder builder = new StringBuilder();
        for (Object e : elements) {
            if (SEPARATOR.equals(e) || "".equals(e)) continue;
            builder.append(SEPARATOR);
            builder.append(e);
        }
        return builder.length() == 0 ? SEPARATOR : builder.toString();
    }

    public Fqn getParent() {
        switch (this.elements.length) {
            case 0: 
            case 1: {
                return Fqn.root();
            }
        }
        return this.getSubFqn(0, this.elements.length - 1);
    }

    public static Fqn root() {
        return ROOT;
    }

    public boolean isRoot() {
        return this.elements.length == 0;
    }

    public String getLastElementAsString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        Object last = this.getLastElement();
        if (last instanceof String) {
            return (String)last;
        }
        return String.valueOf(this.getLastElement());
    }

    public List<Object> peekElements() {
        return Arrays.asList(this.elements);
    }

    @Override
    public int compareTo(Fqn fqn) {
        return FqnComparator.INSTANCE.compare(this, fqn);
    }

    public Fqn replaceAncestor(Fqn oldAncestor, Fqn newAncestor) {
        if (!this.isChildOf(oldAncestor)) {
            throw new IllegalArgumentException("Old ancestor must be an ancestor of the current Fqn!");
        }
        Fqn subFqn = this.getSubFqn(oldAncestor.size(), this.size());
        return Fqn.fromRelativeFqn(newAncestor, subFqn);
    }

    public static class Externalizer
    extends AbstractExternalizer<Fqn> {
        public void writeObject(ObjectOutput output, Fqn fqn) throws IOException {
            output.writeInt(fqn.elements.length);
            for (Object element : fqn.elements) {
                output.writeObject(element);
            }
        }

        public Fqn readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            Object[] elements = new Object[size];
            for (int i = 0; i < size; ++i) {
                elements[i] = input.readObject();
            }
            return new Fqn(elements);
        }

        public Set<Class<? extends Fqn>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Fqn.class});
        }
    }
}

