/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.GroupWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;

@PrimaryType(name="wiki:groupwikis")
public abstract class GroupWikiContainer
extends WikiContainer<GroupWiki> {
    @OneToOne
    @MappedBy(value="groupwikis")
    public abstract WikiStoreImpl getMultiWiki();

    @Override
    public GroupWiki addWiki(String wikiOwner) {
        return this.getWikiObject(wikiOwner, true);
    }

    @Override
    protected GroupWiki getWikiObject(String wikiOwner, boolean createIfNonExist) {
        Node wikiNode;
        ChromatticSession session;
        boolean isCreatedWikiObject;
        block10: {
            isCreatedWikiObject = false;
            if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
                return null;
            }
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            try {
                if (organizationService.getGroupHandler().findGroupById(wikiOwner) == null) {
                    return null;
                }
            }
            catch (Exception ex) {
                return null;
            }
            session = this.getMultiWiki().getSession();
            wikiNode = null;
            try {
                Node rootNode = session.getJCRSession().getRootNode();
                Node groupDataNode = rootNode.getNode("Groups" + wikiOwner + "/" + "ApplicationData");
                try {
                    wikiNode = groupDataNode.getNode("eXoWiki");
                }
                catch (PathNotFoundException e) {
                    if (createIfNonExist) {
                        wikiNode = groupDataNode.addNode("eXoWiki", "wiki:groupwiki");
                        groupDataNode.save();
                        isCreatedWikiObject = true;
                        break block10;
                    }
                    return null;
                }
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }
        GroupWiki gwiki = (GroupWiki)session.findByNode(GroupWiki.class, wikiNode);
        gwiki.setWikiService(this.getwService());
        gwiki.setGroupWikis(this);
        if (isCreatedWikiObject) {
            gwiki.setOwner(wikiOwner);
            gwiki.getPreferences();
            this.initDefaultPermisisonForWiki(gwiki);
            session.save();
        }
        return gwiki;
    }

    @Override
    protected String validateWikiOwner(String wikiOwner) {
        if (wikiOwner == null || wikiOwner.length() == 0) {
            return null;
        }
        if (!wikiOwner.startsWith("/")) {
            wikiOwner = "/" + wikiOwner;
        }
        if (wikiOwner.endsWith("/")) {
            wikiOwner = wikiOwner.substring(0, wikiOwner.length() - 1);
        }
        return wikiOwner;
    }
}

