/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class PerformerBox
extends AbstractFullBox {
    public static final String TYPE = "perf";
    private String language;
    private String performer;

    public PerformerBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    protected long getContentSize() {
        return 2 + PerformerBox.utf8StringLengthInBytes(this.performer) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.performer = in.readString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.performer);
    }

    public String toString() {
        return "PerformerBox[language=" + this.getLanguage() + ";performer=" + this.getPerformer() + "]";
    }
}

