/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackRunBox
extends AbstractFullBox {
    public static final String TYPE = "trun";
    private int dataOffset;
    private SampleFlags firstSampleFlags;
    private List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setDataOffset(int dataOffset) {
        this.setFlags(this.getFlags() | 1);
        this.dataOffset = dataOffset;
    }

    public long[] getSampleOffsets() {
        long[] result = new long[this.entries.size()];
        long offset = 0L;
        for (int i = 0; i < result.length; ++i) {
            result[i] = offset;
            if (this.isSampleSizePresent()) {
                offset += this.entries.get(i).getSampleSize();
                continue;
            }
            offset += ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox().getDefaultSampleSize();
        }
        return result;
    }

    public long[] getSampleSizes() {
        long[] result = new long[this.entries.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.isSampleSizePresent() ? this.entries.get(i).getSampleSize() : ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox().getDefaultSampleSize();
        }
        return result;
    }

    public long[] getSampleCompositionTimeOffsets() {
        if (this.isSampleCompositionTimeOffsetPresent()) {
            long[] result = new long[this.entries.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.entries.get(i).getSampleCompositionTimeOffset();
            }
            return result;
        }
        return null;
    }

    public long[] getSampleDurations() {
        long[] result = new long[this.entries.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.isSampleDurationPresent() ? this.entries.get(i).getSampleDuration() : ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox().getDefaultSampleDuration();
        }
        return result;
    }

    public TrackRunBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        long size = 4L;
        if ((this.getFlags() & 1) == 1) {
            size += 4L;
        }
        if ((this.getFlags() & 4) == 4) {
            size += 4L;
        }
        long entrySize = 0L;
        if ((this.getFlags() & 0x100) == 256) {
            entrySize += 4L;
        }
        if ((this.getFlags() & 0x200) == 512) {
            entrySize += 4L;
        }
        if ((this.getFlags() & 0x400) == 1024) {
            entrySize += 4L;
        }
        if ((this.getFlags() & 0x800) == 2048) {
            entrySize += 4L;
        }
        return size += entrySize * (long)this.entries.size();
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.entries.size());
        if ((this.getFlags() & 1) == 1) {
            os.writeUInt32(this.dataOffset);
        }
        if ((this.getFlags() & 4) == 4) {
            this.firstSampleFlags.getContent(os);
        }
        for (Entry entry : this.entries) {
            if ((this.getFlags() & 0x100) == 256) {
                os.writeUInt32(entry.sampleDuration);
            }
            if ((this.getFlags() & 0x200) == 512) {
                os.writeUInt32(entry.sampleSize);
            }
            if ((this.getFlags() & 0x400) == 1024) {
                entry.sampleFlags.getContent(os);
            }
            if ((this.getFlags() & 0x800) != 2048) continue;
            os.writeUInt32(entry.sampleCompositionTimeOffset);
        }
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long sampleCount = in.readUInt32();
        if ((this.getFlags() & 1) == 1) {
            this.dataOffset = (int)in.readUInt32();
        }
        if ((this.getFlags() & 4) == 4) {
            this.firstSampleFlags = new SampleFlags(in.readUInt32());
        }
        int i = 0;
        while ((long)i < sampleCount) {
            Entry entry = new Entry();
            if ((this.getFlags() & 0x100) == 256) {
                entry.sampleDuration = in.readUInt32();
            }
            if ((this.getFlags() & 0x200) == 512) {
                entry.sampleSize = in.readUInt32();
            }
            if ((this.getFlags() & 0x400) == 1024) {
                entry.sampleFlags = new SampleFlags(in.readUInt32());
            }
            if ((this.getFlags() & 0x800) == 2048) {
                entry.sampleCompositionTimeOffset = in.readUInt32();
            }
            this.entries.add(entry);
            ++i;
        }
    }

    public long getSampleCount() {
        return this.entries.size();
    }

    public boolean isDataOffsetPresent() {
        return (this.getFlags() & 1) == 1;
    }

    public boolean isSampleSizePresent() {
        return (this.getFlags() & 0x200) == 512;
    }

    public boolean isSampleDurationPresent() {
        return (this.getFlags() & 0x100) == 256;
    }

    public boolean isSampleFlagsPresentPresent() {
        return (this.getFlags() & 0x400) == 1024;
    }

    public boolean isSampleCompositionTimeOffsetPresent() {
        return (this.getFlags() & 0x800) == 2048;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public String getFirstSampleFlags() {
        return this.firstSampleFlags != null ? this.firstSampleFlags.toString() : "";
    }

    public void setFirstSampleFlags(SampleFlags firstSampleFlags) {
        this.firstSampleFlags = firstSampleFlags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TrackRunBox");
        sb.append("{sampleCount=").append(this.entries.size());
        sb.append(", dataOffset=").append(this.dataOffset);
        sb.append(", dataOffsetPresent=").append(this.isDataOffsetPresent());
        sb.append(", sampleSizePresent=").append(this.isSampleSizePresent());
        sb.append(", sampleDurationPresent=").append(this.isSampleDurationPresent());
        sb.append(", sampleFlagsPresentPresent=").append(this.isSampleFlagsPresentPresent());
        sb.append(", sampleCompositionTimeOffsetPresent=").append(this.isSampleCompositionTimeOffsetPresent());
        sb.append(", firstSampleFlags=").append(this.firstSampleFlags);
        sb.append('}');
        return sb.toString();
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public static class Entry {
        private long sampleDuration;
        private long sampleSize;
        private SampleFlags sampleFlags;
        private long sampleCompositionTimeOffset;

        public long getSampleDuration() {
            return this.sampleDuration;
        }

        public long getSampleSize() {
            return this.sampleSize;
        }

        public String getSampleFlags() {
            return this.sampleFlags.toString();
        }

        public long getSampleCompositionTimeOffset() {
            return this.sampleCompositionTimeOffset;
        }

        public void setSampleDuration(long sampleDuration) {
            this.sampleDuration = sampleDuration;
        }

        public void setSampleSize(long sampleSize) {
            this.sampleSize = sampleSize;
        }

        public void setSampleFlags(SampleFlags sampleFlags) {
            this.sampleFlags = sampleFlags;
        }

        public void setSampleCompositionTimeOffset(long sampleCompositionTimeOffset) {
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public String toString() {
            return "Entry{sampleDuration=" + this.sampleDuration + ", sampleSize=" + this.sampleSize + ", sampleFlags=" + this.sampleFlags + ", sampleCompositionTimeOffset=" + this.sampleCompositionTimeOffset + '}';
        }
    }
}

