/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class AnalyzePrototypeProperties
implements CompilerPass {
    private final SymbolType PROPERTY = SymbolType.PROPERTY;
    private final SymbolType VAR = SymbolType.VAR;
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private final JSModuleGraph moduleGraph;
    private final JSModule firstModule;
    private static final Set<String> IMPLICITLY_USED_PROPERTIES = ImmutableSet.of((Object)"length", (Object)"toString", (Object)"valueOf");
    private final LinkedDirectedGraph<NameInfo, JSModule> symbolGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final NameInfo globalNode = new NameInfo("[global]");
    private final NameInfo externNode = new NameInfo("[extern]");
    private final NameInfo anonymousNode = new NameInfo("[anonymous]");
    private final Map<String, NameInfo> propertyNameInfo = Maps.newHashMap();
    private final Map<String, NameInfo> varNameInfo = Maps.newHashMap();

    AnalyzePrototypeProperties(AbstractCompiler compiler, JSModuleGraph moduleGraph, boolean canModifyExterns, boolean anchorUnusedVars) {
        this.compiler = compiler;
        this.moduleGraph = moduleGraph;
        this.canModifyExterns = canModifyExterns;
        this.anchorUnusedVars = anchorUnusedVars;
        this.firstModule = moduleGraph != null ? moduleGraph.getRootModule() : null;
        this.globalNode.markReference(null);
        this.externNode.markReference(null);
        this.symbolGraph.createNode(this.globalNode);
        this.symbolGraph.createNode(this.externNode);
        for (String property : IMPLICITLY_USED_PROPERTIES) {
            NameInfo nameInfo = this.getNameInfoForName(property, this.PROPERTY);
            if (moduleGraph == null) {
                this.symbolGraph.connect(this.externNode, null, nameInfo);
                continue;
            }
            for (JSModule module : moduleGraph.getAllModules()) {
                this.symbolGraph.connect(this.externNode, module, nameInfo);
            }
        }
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (!this.canModifyExterns) {
            NodeTraversal.traverse(this.compiler, externRoot, new ProcessExternProperties());
        }
        NodeTraversal.traverse(this.compiler, root, new ProcessProperties());
        FixedPointGraphTraversal<NameInfo, JSModule> t = FixedPointGraphTraversal.newTraversal(new PropagateReferences());
        t.computeFixedPoint(this.symbolGraph, Sets.newHashSet((Object[])new NameInfo[]{this.externNode, this.globalNode}));
    }

    public Collection<NameInfo> getAllNameInfo() {
        ArrayList result = Lists.newArrayList(this.propertyNameInfo.values());
        result.addAll(this.varNameInfo.values());
        return result;
    }

    private NameInfo getNameInfoForName(String name, SymbolType type) {
        Map<String, NameInfo> map;
        Map<String, NameInfo> map2 = map = type == this.PROPERTY ? this.propertyNameInfo : this.varNameInfo;
        if (map.containsKey(name)) {
            return map.get(name);
        }
        NameInfo nameInfo = new NameInfo(name);
        map.put(name, nameInfo);
        this.symbolGraph.createNode(nameInfo);
        return nameInfo;
    }

    class NameInfo {
        final String name;
        private boolean referenced = false;
        private final Deque<Symbol> declarations = new ArrayDeque<Symbol>();
        private JSModule deepestCommonModuleRef = null;
        private boolean readClosureVariables = false;

        NameInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        boolean isReferenced() {
            return this.referenced;
        }

        boolean readsClosureVariables() {
            return this.readClosureVariables;
        }

        boolean markReference(JSModule module) {
            boolean hasChanged = false;
            if (!this.referenced) {
                this.referenced = true;
                hasChanged = true;
            }
            if (AnalyzePrototypeProperties.this.moduleGraph != null) {
                JSModule originalDeepestCommon = this.deepestCommonModuleRef;
                this.deepestCommonModuleRef = this.deepestCommonModuleRef == null ? module : AnalyzePrototypeProperties.this.moduleGraph.getDeepestCommonDependencyInclusive(this.deepestCommonModuleRef, module);
                if (originalDeepestCommon != this.deepestCommonModuleRef) {
                    hasChanged = true;
                }
            }
            return hasChanged;
        }

        JSModule getDeepestCommonModuleRef() {
            return this.deepestCommonModuleRef;
        }

        Deque<Symbol> getDeclarations() {
            return this.declarations;
        }
    }

    private class NameContext {
        final NameInfo name;
        Scope scope;

        NameContext(NameInfo name) {
            this.name = name;
        }
    }

    static class LiteralProperty
    implements Property {
        private final Node key;
        private final Node value;
        private final Node map;
        private final Node assign;
        private final JSModule module;

        LiteralProperty(Node key, Node value, Node map, Node assign, JSModule module) {
            this.key = key;
            this.value = value;
            this.map = map;
            this.assign = assign;
            this.module = module;
        }

        @Override
        public void remove() {
            this.map.removeChild(this.key);
        }

        @Override
        public Node getPrototype() {
            return this.assign.getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.value;
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static class AssignmentProperty
    implements Property {
        private final Node exprNode;
        private final JSModule module;

        AssignmentProperty(Node node, JSModule module) {
            this.exprNode = node;
            this.module = module;
        }

        @Override
        public void remove() {
            NodeUtil.removeChild(this.exprNode.getParent(), this.exprNode);
        }

        @Override
        public Node getPrototype() {
            return this.getAssignNode().getFirstChild().getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.getAssignNode().getLastChild();
        }

        private Node getAssignNode() {
            return this.exprNode.getFirstChild();
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }
    }

    static interface Property
    extends Symbol {
        public Node getPrototype();

        public Node getValue();
    }

    class GlobalFunction
    implements Symbol {
        private final Node nameNode;
        private final JSModule module;

        GlobalFunction(Node nameNode, Node parent, Node gramps, JSModule module) {
            Preconditions.checkState((parent.isVar() || NodeUtil.isFunctionDeclaration(parent) ? 1 : 0) != 0);
            this.nameNode = nameNode;
            this.module = module;
        }

        @Override
        public void remove() {
            Node parent = this.nameNode.getParent();
            if (parent.isFunction() || parent.hasOneChild()) {
                NodeUtil.removeChild(parent.getParent(), parent);
            } else {
                Preconditions.checkState((boolean)parent.isVar());
                parent.removeChild(this.nameNode);
            }
        }

        @Override
        public JSModule getModule() {
            return this.module;
        }

        public Node getFunctionNode() {
            Node parent = this.nameNode.getParent();
            if (parent.isFunction()) {
                return parent;
            }
            return this.nameNode.getChildAtIndex(1);
        }
    }

    private static enum SymbolType {
        PROPERTY,
        VAR;

    }

    static interface Symbol {
        public void remove();

        public JSModule getModule();
    }

    private class PropagateReferences
    implements FixedPointGraphTraversal.EdgeCallback<NameInfo, JSModule> {
        private PropagateReferences() {
        }

        @Override
        public boolean traverseEdge(NameInfo start, JSModule edge, NameInfo dest) {
            if (start.isReferenced()) {
                JSModule startModule = start.getDeepestCommonModuleRef();
                if (startModule != null && AnalyzePrototypeProperties.this.moduleGraph.dependsOn(startModule, edge)) {
                    return dest.markReference(startModule);
                }
                return dest.markReference(edge);
            }
            return false;
        }
    }

    private class ProcessExternProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.externNode, AnalyzePrototypeProperties.this.firstModule, AnalyzePrototypeProperties.this.getNameInfoForName(n.getLastChild().getString(), AnalyzePrototypeProperties.this.PROPERTY));
            }
        }
    }

    private class ProcessProperties
    implements NodeTraversal.ScopedCallback {
        private Stack<NameContext> symbolStack = new Stack();

        private ProcessProperties() {
            this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.globalNode));
        }

        @Override
        public void enterScope(NodeTraversal t) {
            this.symbolStack.peek().scope = t.getScope();
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (this.isPrototypePropertyAssign(n)) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(n.getFirstChild().getLastChild().getString(), AnalyzePrototypeProperties.this.PROPERTY)));
            } else if (this.isGlobalFunctionDeclaration(t, n)) {
                String name = parent.isName() ? parent.getString() : n.getFirstChild().getString();
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.VAR)));
            } else if (n.isFunction()) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.anonymousNode));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                String propName = n.getFirstChild().getNext().getString();
                if (propName.equals("prototype")) {
                    this.processPrototypeParent(t, parent);
                } else if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(propName)) {
                    this.addGlobalUseOfSymbol(propName, t.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                } else {
                    this.addSymbolUse(propName, t.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                }
            } else if (!(!n.isObjectLit() || parent.isAssign() && parent.getFirstChild().isGetProp() && parent.getFirstChild().getLastChild().getString().equals("prototype"))) {
                for (Node propNameNode = n.getFirstChild(); propNameNode != null; propNameNode = propNameNode.getNext()) {
                    if (propNameNode.isQuotedString()) continue;
                    this.addSymbolUse(propNameNode.getString(), t.getModule(), AnalyzePrototypeProperties.this.PROPERTY);
                }
            } else if (n.isName()) {
                String name = n.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (var != null) {
                    if (var.isGlobal()) {
                        if (var.getInitialValue() != null && var.getInitialValue().isFunction()) {
                            if (t.inGlobalScope()) {
                                if (!this.processGlobalFunctionDeclaration(t, n, parent, parent.getParent())) {
                                    this.addGlobalUseOfSymbol(name, t.getModule(), AnalyzePrototypeProperties.this.VAR);
                                }
                            } else {
                                this.addSymbolUse(name, t.getModule(), AnalyzePrototypeProperties.this.VAR);
                            }
                        }
                    } else if (var.getScope() != t.getScope()) {
                        for (int i = this.symbolStack.size() - 1; i >= 0; --i) {
                            NameContext context = (NameContext)this.symbolStack.get(i);
                            context.name.readClosureVariables = true;
                            if (context.scope != var.getScope()) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (this.isPrototypePropertyAssign(n) || this.isGlobalFunctionDeclaration(t, n) || n.isFunction()) {
                this.symbolStack.pop();
            }
        }

        private void addSymbolUse(String name, JSModule module, SymbolType type) {
            NameInfo info = AnalyzePrototypeProperties.this.getNameInfoForName(name, type);
            Object def = null;
            for (int i = this.symbolStack.size() - 1; i >= 0 && (def = ((NameContext)this.symbolStack.get((int)i)).name) == AnalyzePrototypeProperties.this.anonymousNode; --i) {
            }
            if (!def.equals(info)) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(def, module, info);
            }
        }

        private boolean isGlobalFunctionDeclaration(NodeTraversal t, Node n) {
            return t.inGlobalScope() && (NodeUtil.isFunctionDeclaration(n) || n.isFunction() && n.getParent().isName());
        }

        private boolean isPrototypePropertyAssign(Node assign) {
            Node child;
            boolean isChainedProperty;
            Node n = assign.getFirstChild();
            return n != null && NodeUtil.isVarOrSimpleAssignLhs(n, assign) && n.isGetProp() && assign.getParent().isExprResult() && (isChainedProperty = n.getFirstChild().isGetProp()) && (child = n.getFirstChild().getFirstChild().getNext()).isString() && child.getString().equals("prototype");
        }

        private boolean processGlobalFunctionDeclaration(NodeTraversal t, Node nameNode, Node parent, Node gramps) {
            Node firstChild = nameNode.getFirstChild();
            if (this.isGlobalFunctionDeclaration(t, parent) || firstChild != null && this.isGlobalFunctionDeclaration(t, firstChild)) {
                String name = nameNode.getString();
                AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.VAR).getDeclarations().add(new GlobalFunction(nameNode, parent, gramps, t.getModule()));
                if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(name) || AnalyzePrototypeProperties.this.anchorUnusedVars) {
                    this.addGlobalUseOfSymbol(name, t.getModule(), AnalyzePrototypeProperties.this.VAR);
                }
                return true;
            }
            return false;
        }

        private void processPrototypeParent(NodeTraversal t, Node n) {
            switch (n.getType()) {
                case 33: {
                    Node dest = n.getFirstChild().getNext();
                    Node parent = n.getParent();
                    Node grandParent = parent.getParent();
                    if (!dest.isString() || !NodeUtil.isExprAssign(grandParent) || !NodeUtil.isVarOrSimpleAssignLhs(n, parent)) break;
                    String name = dest.getString();
                    AssignmentProperty prop = new AssignmentProperty(grandParent, t.getModule());
                    AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.PROPERTY).getDeclarations().add(prop);
                    break;
                }
                case 86: {
                    Node map = n.getFirstChild().getNext();
                    if (!map.isObjectLit()) break;
                    for (Node key = map.getFirstChild(); key != null; key = key.getNext()) {
                        String name = key.getString();
                        LiteralProperty prop = new LiteralProperty(key, key.getFirstChild(), map, n, t.getModule());
                        AnalyzePrototypeProperties.this.getNameInfoForName(name, AnalyzePrototypeProperties.this.PROPERTY).getDeclarations().add(prop);
                    }
                    break;
                }
            }
        }

        private void addGlobalUseOfSymbol(String name, JSModule module, SymbolType type) {
            AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.globalNode, module, AnalyzePrototypeProperties.this.getNameInfoForName(name, type));
        }
    }
}

