/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.updater;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.service.AsyncCallback;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.SocialServiceContext;
import org.exoplatform.social.common.service.impl.SocialServiceContextImpl;
import org.exoplatform.social.common.service.utils.ConsoleUtils;
import org.exoplatform.social.common.service.utils.ObjectHelper;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.chromattic.entity.ProviderEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.streams.SocialChromatticAsyncProcessor;
import org.exoplatform.social.core.storage.streams.StreamProcessContext;
import org.exoplatform.social.core.updater.StreamUpgradeProcessor;
import org.exoplatform.social.core.updater.UserActivityStreamUpdaterPlugin;

public class SpaceActivityStreamMigration
extends AbstractStorage {
    private static final Log LOG = ExoLogger.getLogger(UserActivityStreamUpdaterPlugin.class);
    private IdentityStorage identityStorage = null;
    private static AtomicInteger currentNumber = new AtomicInteger(0);
    private static final int BATCH_FLUSH_LIMIT = 40;

    private IdentityStorage getIdentityStorage() {
        if (this.identityStorage == null) {
            this.identityStorage = (IdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(IdentityStorage.class);
        }
        return this.identityStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(int limit) {
        StringBuffer sb = new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ");
        ProviderEntity provider = this.getProviderRoot().getProviders().get("space");
        if (provider == null) {
            return;
        }
        sb.append(JCRProperties.path.getName()).append(" LIKE '").append(provider.getPath() + "/" + "%");
        sb.append("' AND NOT ").append(ProfileEntity.deleted.getName()).append(" = ").append("true");
        LOG.warn((Object)("SQL : " + sb.toString()));
        NodeIterator it = this.nodes(sb.toString());
        long totalOfIdentity = it.getSize();
        Identity owner = null;
        Node node = null;
        int batchIndex = 0;
        int offset = 0;
        try {
            while (it.hasNext()) {
                node = (Node)it.next();
                owner = this.getIdentityStorage().findIdentityById(node.getUUID());
                this.doUpgrade(owner, totalOfIdentity, limit);
                ++offset;
                if (++batchIndex != 40) continue;
                LOG.warn((Object)("UPGRAGE SESSION FLUSH: " + offset));
                StorageUtils.persistJCR(true);
                it = this.nodes(sb.toString());
                this._skip((Iterator<?>)it, offset);
                batchIndex = 0;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to migration for Space Activity Stream.");
        }
        finally {
            StorageUtils.persistJCR(false);
            StorageUtils.endRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessContext doUpgrade(Identity owner, long total, int limit) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(String.format("%s-[%s limit=%s]", StreamProcessContext.UPGRADE_STREAM_PROCESS, owner.getRemoteId(), limit), ctx);
        processCtx.identity(owner).limit(limit).totalProcesses((int)total);
        try {
            processCtx.getTraceElement().start();
            this.upgradeProcessor().start((ProcessContext)processCtx);
            this.upgradeProcessor().process((ProcessContext)processCtx);
            this.upgradeProcessor().end((ProcessContext)processCtx);
            processCtx.getTraceElement().end();
            this.createAsyncCallback().done((ProcessContext)processCtx);
        }
        catch (Exception e) {
            processCtx.setException(e);
        }
        finally {
            if (processCtx.isFailed()) {
                LOG.warn((Object)"Failed to migration for Space Activity Stream.", (Throwable)processCtx.getException());
            } else {
                LOG.info((Object)processCtx.getTraceLog());
            }
        }
        return processCtx;
    }

    private SocialChromatticAsyncProcessor upgradeProcessor() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                int limit = streamCtx.getLimit();
                StreamUpgradeProcessor.space(streamCtx.getIdentity()).upgrade(0, limit);
                return processContext;
            }
        };
    }

    private AsyncCallback createAsyncCallback() {
        return new AsyncCallback(){

            public void done(ProcessContext processContext) {
                int value = currentNumber.incrementAndGet();
                int percent = value * 100 / processContext.getTotalProcesses();
                ConsoleUtils.logProgBar((int)percent);
            }
        };
    }
}

