/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow.persistent;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPath;

public abstract class PersistedItemData
implements ItemData,
Externalizable {
    private static final long serialVersionUID = -3845740801904303663L;
    protected String id;
    protected QPath qpath;
    protected String parentId;
    protected int version;
    private static final int NOT_NULL_VALUE = 1;
    private static final int NULL_VALUE = -1;

    public PersistedItemData() {
    }

    public PersistedItemData(String id, QPath qpath, String parentId, int version) {
        if (id.equals(parentId)) {
            throw new IllegalArgumentException("Item can't have itself as parent.");
        }
        this.id = id;
        this.qpath = qpath;
        this.parentId = parentId;
        this.version = version;
    }

    public QPath getQPath() {
        return this.qpath;
    }

    public String getIdentifier() {
        return this.id;
    }

    public int getPersistedVersion() {
        return this.version;
    }

    public String getParentIdentifier() {
        return this.parentId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ItemData) {
            return this.getIdentifier().hashCode() == ((ItemData)obj).getIdentifier().hashCode();
        }
        return false;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        try {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            String sQPath = new String(buf, "UTF-8");
            this.qpath = QPath.parse(sQPath);
        }
        catch (IllegalPathException e) {
            throw new IOException("Deserialization error. " + (Object)((Object)e)){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.id = new String(buf);
        int isNull = in.readInt();
        if (isNull == 1) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.parentId = new String(buf);
        }
        this.version = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buf = this.qpath.getAsString().getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        out.writeInt(this.id.getBytes().length);
        out.write(this.id.getBytes());
        if (this.parentId != null) {
            out.writeInt(1);
            out.writeInt(this.parentId.getBytes().length);
            out.write(this.parentId.getBytes());
        } else {
            out.writeInt(-1);
        }
        out.writeInt(this.version);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", qpath=" + this.qpath + ", parentId=" + this.parentId + ", version=" + this.version + "]";
    }
}

