/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.ext.organization.JCROrgServiceHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.SimpleJCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.UserByGroupJCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.UserByQueryJCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.UserImpl;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.ExtendedUserHandler;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserEventListenerHandler;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.PasswordEncrypter;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserHandlerImpl
extends JCROrgServiceHandler
implements UserHandler,
UserEventListenerHandler,
ExtendedUserHandler {
    protected final List<UserEventListener> listeners = new ArrayList<UserEventListener>();

    UserHandlerImpl(JCROrganizationServiceImpl service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            boolean bl = this.authenticate(session, username, password, null);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userName, String password, PasswordEncrypter pe) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            boolean bl = this.authenticate(session, userName, password, pe);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    private boolean authenticate(Session session, String userName, String password, PasswordEncrypter pe) throws Exception {
        boolean authenticated;
        Node userNode;
        try {
            userNode = this.utils.getUserNode(session, userName);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        if (pe == null) {
            authenticated = this.utils.readString(userNode, "jos:password").equals(password);
        } else {
            String encryptedPassword = new String(pe.encrypt(this.utils.readString(userNode, "jos:password").getBytes()));
            authenticated = encryptedPassword.equals(password);
        }
        if (authenticated) {
            Calendar lastLoginTime = Calendar.getInstance();
            userNode.setProperty("jos:lastLoginTime", lastLoginTime);
            session.save();
        }
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(User user, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.createUser(session, (UserImpl)user, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void createUser(Session session, UserImpl user, boolean broadcast) throws Exception {
        Node userStorageNode = this.utils.getUsersStorageNode(session);
        Node userNode = userStorageNode.addNode(user.getUserName());
        if (user.getCreatedDate() == null) {
            Calendar calendar = Calendar.getInstance();
            user.setCreatedDate(calendar.getTime());
        }
        user.setInternalId(userNode.getUUID());
        if (broadcast) {
            this.preSave(user, true);
        }
        this.writeUser(user, userNode);
        session.save();
        this.putInCache(user);
        if (broadcast) {
            this.postSave(user, true);
        }
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserByName(String userName) throws Exception {
        User user = this.getFromCache(userName);
        if (user != null) {
            return user;
        }
        Session session = this.service.getStorageSession();
        try {
            Node userNode;
            try {
                userNode = this.utils.getUserNode(session, userName);
            }
            catch (PathNotFoundException e) {
                User user2 = null;
                session.logout();
                return user2;
            }
            user = this.readUser(userNode);
            this.putInCache(user);
            User user3 = user;
            return user3;
        }
        finally {
            session.logout();
        }
    }

    public LazyPageList findUsers(Query query) throws Exception {
        return query.isEmpty() ? new LazyPageList((ListAccess)new SimpleJCRUserListAccess(this.service), 10) : new LazyPageList((ListAccess)new UserByQueryJCRUserListAccess(this.service, query), 10);
    }

    public LazyPageList findUsersByGroup(String groupId) throws Exception {
        return new LazyPageList((ListAccess)new UserByGroupJCRUserListAccess(this.service, groupId), 10);
    }

    public LazyPageList getUserPageList(int pageSize) throws Exception {
        return new LazyPageList((ListAccess)new SimpleJCRUserListAccess(this.service), pageSize);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        return new SimpleJCRUserListAccess(this.service);
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        return new UserByGroupJCRUserListAccess(this.service, groupId);
    }

    public ListAccess<User> findUsersByQuery(Query query) throws Exception {
        return query.isEmpty() ? new SimpleJCRUserListAccess(this.service) : new UserByQueryJCRUserListAccess(this.service, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User removeUser(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            User user = this.removeUser(session, userName, broadcast);
            return user;
        }
        finally {
            session.logout();
        }
    }

    private User removeUser(Session session, String userName, boolean broadcast) throws Exception {
        Node userNode = this.utils.getUserNode(session, userName);
        UserImpl user = this.readUser(userNode);
        if (broadcast) {
            this.preDelete(user);
        }
        this.removeMemberships(userNode, broadcast);
        userNode.remove();
        session.save();
        this.removeFromCache(userName);
        this.removeAllRelatedFromCache(userName);
        if (broadcast) {
            this.postDelete(user);
        }
        return user;
    }

    private void removeMemberships(Node userNode, boolean broadcast) throws RepositoryException {
        PropertyIterator refUserProps = userNode.getReferences();
        while (refUserProps.hasNext()) {
            Node refUserNode = refUserProps.nextProperty().getParent();
            refUserNode.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUser(User user, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.saveUser(session, (UserImpl)user, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void saveUser(Session session, UserImpl user, boolean broadcast) throws Exception {
        String newName;
        String oldName;
        Node userNode = this.getUserNode(session, user);
        if (broadcast) {
            this.preSave(user, false);
        }
        if (!(oldName = userNode.getName()).equals(newName = user.getUserName())) {
            String oldPath = userNode.getPath();
            String newPath = this.utils.getUserNodePath(newName);
            session.move(oldPath, newPath);
            this.removeFromCache(oldName);
            this.moveMembershipsInCache(oldName, newName);
        }
        this.writeUser(user, userNode);
        session.save();
        this.putInCache(user);
        if (broadcast) {
            this.postSave(user, false);
        }
    }

    private Node getUserNode(Session session, UserImpl user) throws RepositoryException {
        if (user.getInternalId() != null) {
            return session.getNodeByUUID(user.getInternalId());
        }
        return this.utils.getUserNode(session, user.getUserName());
    }

    public UserImpl readUser(Node userNode) throws Exception {
        UserImpl user = new UserImpl(userNode.getName());
        Date creationDate = this.utils.readDate(userNode, "jos:createdDate");
        Date lastLoginTime = this.utils.readDate(userNode, "jos:lastLoginTime");
        String email = this.utils.readString(userNode, "jos:email");
        String password = this.utils.readString(userNode, "jos:password");
        String firstName = this.utils.readString(userNode, "jos:firstName");
        String lastName = this.utils.readString(userNode, "jos:lastName");
        String displayName = this.utils.readString(userNode, "jos:displayName");
        user.setInternalId(userNode.getUUID());
        user.setCreatedDate(creationDate);
        user.setLastLoginTime(lastLoginTime);
        user.setEmail(email);
        user.setPassword(password);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setDisplayName(displayName);
        return user;
    }

    private void writeUser(User user, Node node) throws Exception {
        node.setProperty("jos:email", user.getEmail());
        node.setProperty("jos:firstName", user.getFirstName());
        node.setProperty("jos:lastName", user.getLastName());
        node.setProperty("jos:password", user.getPassword());
        node.setProperty("jos:displayName", user.getDisplayName());
        node.setProperty("jos:userName", node.getName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(user.getCreatedDate());
        node.setProperty("jos:createdDate", calendar);
    }

    void migrateUser(Node oldUserNode) throws Exception {
        String userName = oldUserNode.getName();
        if (this.findUserByName(userName) != null) {
            this.removeUser(userName, false);
        }
        UserImpl user = this.readUser(oldUserNode);
        this.createUser(user, false);
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postDelete(user);
        }
    }

    private void removeFromCache(String userName) {
        this.cache.remove((Serializable)((Object)userName), CacheHandler.CacheType.USER);
    }

    private void removeAllRelatedFromCache(String userName) {
        this.cache.remove((Serializable)((Object)userName), CacheHandler.CacheType.USER_PROFILE);
        this.cache.remove((Serializable)((Object)("u=" + userName)), CacheHandler.CacheType.MEMBERSHIP);
    }

    private User getFromCache(String userName) {
        return (User)this.cache.get((Serializable)((Object)userName), CacheHandler.CacheType.USER);
    }

    private void moveMembershipsInCache(String oldName, String newName) {
        this.cache.move((Serializable)((Object)("u=" + oldName)), (Serializable)((Object)("u=" + newName)), CacheHandler.CacheType.MEMBERSHIP);
    }

    private void putInCache(User user) {
        this.cache.put((Serializable)((Object)user.getUserName()), user, CacheHandler.CacheType.USER);
    }

    public void addUserEventListener(UserEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public void removeUserEventListener(UserEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public List<UserEventListener> getUserListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public static class UserProperties {
        public static final String JOS_CREATED_DATE = "jos:createdDate";
        public static final String JOS_EMAIL = "jos:email";
        public static final String JOS_FIRST_NAME = "jos:firstName";
        public static final String JOS_USER_NAME = "jos:userName";
        public static final String JOS_LAST_LOGIN_TIME = "jos:lastLoginTime";
        public static final String JOS_LAST_NAME = "jos:lastName";
        public static final String JOS_DISPLAY_NAME = "jos:displayName";
        public static final String JOS_PASSWORD = "jos:password";
    }
}

