/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.io.IOUtils;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.documents.impl.DocumentType;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.json.JSONObject;
import org.picocontainer.Startable;

@Path(value="/office/")
@RolesAllowed(value={"users"})
public class OpenInOfficeConnector
implements ResourceContainer,
Startable {
    private final String OPEN_DOCUMENT_ON_DESKTOP_ICO = "uiIconOpenOnDesktop";
    private final String CONNECTOR_BUNDLE_LOCATION = "locale.wcm.resources.WCMResourceBundleConnector";
    private final String OPEN_DOCUMENT_ON_DESKTOP_RESOURCE_KEY = "OpenInOfficeConnector.label.exo.remote-edit.desktop";
    private final String OPEN_DOCUMENT_IN_DESKTOP_APP_RESOURCE_KEY = "OpenInOfficeConnector.label.exo.remote-edit.desktop-app";
    private final String OPEN_DOCUMENT_DEFAULT_TITLE = "Open on Desktop";
    private static final String MSOFFICE_MIMETYPE = "ms-office-mimetype";
    private final int CACHED_TIME = 518400;
    private static final String VERSION_MIXIN = "mix:versionable";
    private static String msofficeMimeType = ",doc,dot,docx,dotx,docm,dotm,xll,xls,xlt,xla,xlsx,xltx,xlsm,xltm,xlam,xlsb,ppt,pot,pps,ppa,pptx,potx,ppsx,ppam,pptm,potm,ppsm,";
    private NodeFinder nodeFinder;
    private LinkManager linkManager;
    private ResourceBundleService resourceBundleService;
    private DocumentTypeService documentTypeService;

    private void init() {
        String _msofficeMimeType = System.getProperty(MSOFFICE_MIMETYPE);
        if (StringUtils.isNotEmpty((String)_msofficeMimeType)) {
            msofficeMimeType = _msofficeMimeType;
        }
    }

    public OpenInOfficeConnector(NodeFinder nodeFinder, LinkManager linkManager, ResourceBundleService resourceBundleService, DocumentTypeService documentTypeService) {
        this.nodeFinder = nodeFinder;
        this.linkManager = linkManager;
        this.resourceBundleService = resourceBundleService;
        this.documentTypeService = documentTypeService;
    }

    @GET
    @Path(value="/updateDocumentTitle")
    public Response updateDocumentTitle(@Context Request request, @QueryParam(value="objId") String objId, @QueryParam(value="lang") String language) throws Exception {
        Node node;
        EntityTag etag;
        Response.ResponseBuilder builder;
        String[] nodeInfo = objId.split(":");
        String workspace = nodeInfo[0];
        String filePath = nodeInfo[1];
        String extension = filePath.substring(filePath.lastIndexOf(".") + 1, filePath.length());
        if (extension.contains("[")) {
            extension = extension.substring(0, extension.indexOf("["));
        }
        if ((builder = request.evaluatePreconditions(etag = new EntityTag(Integer.toString((extension + "_" + language).hashCode())))) != null) {
            return builder.build();
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(518400);
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.wcm.resources.WCMResourceBundleConnector", new Locale(language));
        String title = resourceBundle != null ? resourceBundle.getString("OpenInOfficeConnector.label.exo.remote-edit.desktop") : "Open on Desktop";
        String ico = "uiIconOpenOnDesktop";
        DocumentType documentType = this.documentTypeService.getDocumentType(extension);
        if (documentType != null && resourceBundle != null) {
            try {
                if (!StringUtils.isEmpty((String)resourceBundle.getString(documentType.getResourceBundleKey()))) {
                    title = resourceBundle.getString(documentType.getResourceBundleKey());
                }
            }
            catch (Exception ex) {
                String _openonDesktop = resourceBundle.getString("OpenInOfficeConnector.label.exo.remote-edit.desktop-app");
                title = _openonDesktop != null && _openonDesktop.contains("{0}") ? _openonDesktop.replace("{0}", documentType.getResourceBundleKey()) : "Open on Desktop";
            }
            if (!StringUtils.isEmpty((String)documentType.getIconClass())) {
                ico = documentType.getIconClass();
            }
        }
        if (this.linkManager.isLink((Item)(node = (Node)this.nodeFinder.getItem(workspace, filePath)))) {
            node = this.linkManager.getTarget(node);
        }
        JSONObject rs = new JSONObject();
        rs.put("ico", (Object)ico);
        rs.put("title", (Object)title);
        rs.put("repository", (Object)WCMCoreUtils.getRepository().getConfiguration().getName());
        rs.put("workspace", (Object)workspace);
        rs.put("filePath", (Object)node.getPath());
        rs.put("isFile", node.isNodeType("nt:file"));
        rs.put("isMsoffice", msofficeMimeType.contains("," + extension + ","));
        builder = Response.ok((Object)rs.toString(), (String)"application/json");
        builder.tag(etag);
        builder.cacheControl(cc);
        return builder.build();
    }

    public String[] getDocumentInfos(String fileName) {
        String title = "OpenInOfficeConnector.label.exo.remote-edit.desktop";
        String icon = "uiIconOpenOnDesktop";
        String _extension = "";
        if (fileName.lastIndexOf(".") > 0) {
            _extension = StringUtils.substring((String)fileName, (int)(fileName.lastIndexOf(".") + 1), (int)fileName.length());
        }
        if (StringUtils.isBlank((String)_extension)) {
            return new String[]{title, icon};
        }
        DocumentType documentType = this.documentTypeService.getDocumentType(_extension);
        if (documentType != null) {
            if (!StringUtils.isEmpty((String)documentType.getResourceBundleKey())) {
                title = documentType.getResourceBundleKey();
            }
            if (!StringUtils.isEmpty((String)documentType.getIconClass())) {
                icon = documentType.getIconClass();
            }
        }
        return new String[]{title, icon};
    }

    @GET
    @Path(value="/checkout")
    public Response checkout(@Context Request request, @QueryParam(value="filePath") String filePath, @QueryParam(value="workspace") String workspace) throws Exception {
        Session session = WCMCoreUtils.getSystemSessionProvider().getSession(workspace, WCMCoreUtils.getRepository());
        Node node = (Node)session.getItem(filePath);
        if (node.canAddMixin(VERSION_MIXIN)) {
            node.addMixin(VERSION_MIXIN);
            node.save();
            node.checkin();
            node.checkout();
        }
        if (!node.isCheckedOut()) {
            node.checkout();
        }
        return Response.ok((Object)String.valueOf(node.isCheckedOut()), (String)"text/plain").build();
    }

    @GET
    @Path(value="/{linkFilePath}/")
    @Produces(value={"application/internet-shortcut"})
    public Response createShortcut(@Context HttpServletRequest httpServletRequest, @PathParam(value="linkFilePath") String linkFilePath, @QueryParam(value="filePath") String filePath, @QueryParam(value="workspace") String workspace) throws Exception {
        Session session = WCMCoreUtils.getSystemSessionProvider().getSession(workspace, WCMCoreUtils.getRepository());
        Node node = (Node)session.getItem(filePath);
        String repo = WCMCoreUtils.getRepository().getConfiguration().getName();
        String obsPath = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + "/" + WCMCoreUtils.getRestContextName() + "/private/jcr/" + repo + "/" + workspace + node.getPath();
        String shortCutContent = "[InternetShortcut]\n";
        shortCutContent = shortCutContent + "URL=" + obsPath + "\n";
        return Response.ok((Object)IOUtils.toInputStream((String)shortCutContent), (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=" + node.getName() + ".url")).header("Content-type", (Object)"application/internet-shortcut").build();
    }

    public void start() {
        this.init();
    }

    public void stop() {
    }
}

