/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;

public class ProtocolStack
extends Protocol
implements Transport {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    private Protocol top_prot = null;
    private Protocol bottom_prot = null;
    private String setup_string;
    private JChannel channel = null;
    private volatile boolean stopped = true;
    private static final ConcurrentMap<String, Tuple<TP, Short>> singleton_transports = new ConcurrentHashMap<String, Tuple<TP, Short>>();

    public ProtocolStack(JChannel channel, String setup_string) throws ChannelException {
        this.setup_string = setup_string;
        this.channel = channel;
        ClassConfigurator.getInstance(true);
    }

    public ProtocolStack() throws ChannelException {
        this(null, null);
    }

    @Override
    public ThreadFactory getThreadFactory() {
        this.getTransport().getThreadFactory();
        TP transport = this.getTransport();
        return transport != null ? transport.getThreadFactory() : null;
    }

    @Deprecated
    public static ThreadFactory getTimerThreadFactory() {
        throw new UnsupportedOperationException("get the timer thread factory directly from the transport");
    }

    public void setThreadFactory(ThreadFactory f) {
    }

    public static void setTimerThreadFactory(ThreadFactory f) {
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getTimerThreads() {
        TimeScheduler timer;
        TP transport = this.getTransport();
        if (transport != null && (timer = transport.getTimer()) != null) {
            return timer.getCorePoolSize();
        }
        return -1;
    }

    public Vector<Protocol> getProtocols() {
        Vector<Protocol> v = new Vector<Protocol>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            v.addElement(p);
        }
        return v;
    }

    @Override
    public TP getTransport() {
        Vector<Protocol> prots = this.getProtocols();
        return (TP)(!prots.isEmpty() ? prots.lastElement() : null);
    }

    public static ConcurrentMap<String, Tuple<TP, Short>> getSingletonTransports() {
        return singleton_transports;
    }

    @Override
    public Map<String, Object> dumpStats() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            String prot_name = p.getName();
            Map<String, Object> tmp = p.dumpStats();
            if (prot_name == null || tmp == null) continue;
            retval.put(prot_name, tmp);
        }
        return retval;
    }

    public Map<String, Object> dumpStats(String protocol_name) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            Map<String, Object> tmp;
            String prot_name = p.getName();
            if (!prot_name.equals(protocol_name) || (tmp = p.dumpStats()) == null) continue;
            retval.put(prot_name, tmp);
        }
        return retval;
    }

    public String dumpTimerQueue() {
        TimeScheduler timer;
        TP transport = this.getTransport();
        if (transport != null && (timer = transport.getTimer()) != null) {
            return timer.dumpTaskQueue();
        }
        return "";
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.top_prot;
        while (prot != null) {
            Properties tmpProps;
            String name = prot.getName();
            if (name == null) continue;
            if ("ProtocolStack".equals(name)) break;
            sb.append(name);
            if (include_properties && (tmpProps = prot.getProperties()) != null) {
                sb.append('\n');
                for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                    sb.append(entry).append("\n");
                }
            }
            sb.append('\n');
            prot = prot.getDownProtocol();
        }
        return sb.toString();
    }

    public String printProtocolSpecAsXML() {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.bottom_prot;
        int max_len = 30;
        sb.append("<config>\n");
        while (prot != null) {
            String name = prot.getName();
            if (name == null) continue;
            if ("ProtocolStack".equals(name)) break;
            sb.append("  <").append(name).append(" ");
            Properties tmpProps = prot.getProperties();
            if (tmpProps != null) {
                int len = name.length();
                for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                    String s = entry.getKey() + "=\"" + entry.getValue() + "\" ";
                    if (len + s.length() > max_len) {
                        sb.append("\n       ");
                        len = 8;
                    }
                    sb.append(s);
                    len += s.length();
                }
            }
            sb.append("/>\n");
            prot = prot.getUpProtocol();
        }
        sb.append("</config>");
        return sb.toString();
    }

    public String printProtocolSpecAsPlainString() {
        Class<?> clazz;
        StringBuilder sb = new StringBuilder();
        boolean initialized = false;
        for (Protocol prot = this.bottom_prot; prot != null && !(clazz = prot.getClass()).equals(ProtocolStack.class); prot = prot.getUpProtocol()) {
            if (initialized) {
                sb.append(":");
            } else {
                initialized = true;
            }
            sb.append(clazz.getName());
            Properties tmpProps = prot.getProperties();
            if (tmpProps != null && !tmpProps.isEmpty()) {
                sb.append("(");
                boolean first = true;
                for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(";");
                    }
                    sb.append(entry.getKey() + "=" + entry.getValue());
                }
                sb.append(")");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setup() throws Exception {
        if (this.top_prot == null) {
            this.top_prot = Configurator.setupProtocolStack(this.setup_string, this);
            this.top_prot.setUpProtocol(this);
            this.bottom_prot = Configurator.getBottommostProtocol(this.top_prot);
            Vector<Protocol> protocols = this.getProtocols();
            Configurator.initProtocolStack(protocols);
        }
    }

    public Protocol createProtocol(String prot_spec) throws Exception {
        return Configurator.createProtocol(prot_spec, this);
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot) throws Exception {
        Configurator.insertProtocol(prot, position, neighbor_prot, this);
    }

    public void insertProtocol(Protocol prot, int position, Class<? extends Protocol> neighbor_prot) throws Exception {
        Configurator.insertProtocol(prot, position, neighbor_prot, this);
    }

    public Protocol removeProtocol(String prot_name) throws Exception {
        return Configurator.removeProtocol(this.top_prot, prot_name);
    }

    public Protocol findProtocol(String name) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            String prot_name = tmp.getName();
            if (prot_name == null || !prot_name.equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public Protocol findProtocol(Class<?> clazz) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            Class<?> protClass = tmp.getClass();
            if (!clazz.isAssignableFrom(protClass)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.top_prot != null) {
            Configurator.destroyProtocolStack(this.getProtocols());
            this.top_prot = null;
        }
    }

    public void startStack(String cluster_name) throws Exception {
        if (!this.stopped) {
            return;
        }
        Configurator.startProtocolStack(this.getProtocols(), cluster_name, singleton_transports);
        this.stopped = false;
    }

    public void stopStack(String cluster_name) {
        if (this.stopped) {
            return;
        }
        Configurator.stopProtocolStack(this.getProtocols(), cluster_name, singleton_transports);
        this.stopped = true;
    }

    public void flushEvents() {
    }

    @Override
    public void send(Message msg) throws Exception {
        this.down(new Event(1, msg));
    }

    @Override
    public Object receive(long timeout) throws Exception {
        throw new Exception("ProtocolStack.receive(): not implemented !");
    }

    @Override
    public String getName() {
        return "ProtocolStack";
    }

    @Override
    public Object up(Event evt) {
        return this.channel.up(evt);
    }

    @Override
    public Object down(Event evt) {
        if (this.top_prot != null) {
            return this.top_prot.down(evt);
        }
        return null;
    }
}

