/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.sanitization;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SanitizationUpgradePlugin
extends UpgradeProductPlugin {
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;
    private ManageViewService viewService_;
    private static final Log LOG = ExoLogger.getLogger((String)SanitizationUpgradePlugin.class.getName());

    public SanitizationUpgradePlugin(RepositoryService repoService, DMSConfiguration dmsConfiguration, ManageViewService viewService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.viewService_ = viewService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        this.migrateViews();
        this.migrateViewTemplates();
        this.migrateDrives();
        this.migratePortletPreferences();
        this.migrateLinkInContents();
        this.migrateSocialActivities();
        this.migrateTaxonomyAction();
        this.migrateDriveNameOfPortletPreferences();
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateViews() {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            String[] oldViewTemplates = new String[]{"ListView", "ContentView", "ThumbnailsView", "IconView", "TimelineView", "CoverFlow", "SystemView", "SlideShowView"};
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start migrate data for all user views=====");
            }
            Node views = (Node)session.getItem("/exo:ecm/views/userviews");
            NodeIterator nodeIter = views.getNodes();
            while (nodeIter.hasNext()) {
                Node viewNode = nodeIter.nextNode();
                String template = viewNode.getProperty("exo:template").getString();
                String templateName = StringUtils.substringAfterLast((String)template, (String)"/");
                for (String oldTemp : oldViewTemplates) {
                    if (!templateName.equals(oldTemp)) continue;
                    if (this.isContainOldView(viewNode.getName())) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("=====Removing view '" + viewNode.getName() + "'====="));
                        }
                        viewNode.remove();
                        continue;
                    }
                    String newTemplate = "List";
                    if (templateName.equals("ListView")) {
                        newTemplate = template.replace(templateName, "List");
                    } else if (templateName.equals("ContentView")) {
                        newTemplate = template.replace(templateName, "Content");
                    } else if (templateName.equals("ThumbnailsView")) {
                        newTemplate = template.replace(templateName, "Thumbnails");
                    } else if (templateName.equals("IconView")) {
                        newTemplate = template.replace(templateName, "Thumbnails");
                    } else if (templateName.equals("TimelineView")) {
                        newTemplate = template.replace(templateName, "List");
                    } else if (templateName.equals("CoverFlow")) {
                        newTemplate = template.replace(templateName, "Thumbnails");
                    } else if (templateName.equals("SystemView")) {
                        newTemplate = template.replace(templateName, "List");
                    } else if (templateName.equals("SlideShowView")) {
                        newTemplate = template.replace(templateName, "Thumbnails");
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("=====Modifying view '" + viewNode.getName() + "'====="));
                    }
                    viewNode.setProperty("exo:template", newTemplate);
                }
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Completed the migration data for user views=====");
            }
        }
    }

    private boolean isContainOldView(String viewName) {
        String[] oldViewNames;
        for (String vName : oldViewNames = new String[]{"timeline-view", "list-view", "icon-view", "admin-view", "simple-view", "slide-show", "cover-flow", "anonymous-view", "taxonomy-list", "taxonomy-icons", "system-view", "wcm-view", "authoring-view", "wcm-category-view"}) {
            if (!viewName.contains(vName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateViewTemplates() {
        try (SessionProvider sessionProvider = null;){
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start migrate data for all user views template=====");
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            String[] oldViewTemplates = new String[]{"ListView", "ContentView", "ThumbnailsView", "IconView", "TimelineView", "CoverFlow", "SystemView", "SlideShowView"};
            List templates = this.viewService_.getAllTemplates("ecmExplorerTemplates", sessionProvider);
            block5: for (Node template : templates) {
                for (String oldViewTemp : oldViewTemplates) {
                    if (!template.getName().equals(oldViewTemp)) continue;
                    LOG.info((Object)(" * Removing the old view template " + template.getName() + ""));
                    template.remove();
                    continue block5;
                }
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Completed the migration data for user views template=====");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateDrives() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"=====Start migrate data for drives=====");
        }
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            Node drives = (Node)session.getItem("/exo:ecm/exo:drives");
            NodeIterator nodeIter = drives.getNodes();
            while (nodeIter.hasNext()) {
                String path;
                Node drive = nodeIter.nextNode();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(" * Migrating the drive " + drive.getName() + ""));
                }
                if ((path = drive.getProperty("exo:path").getString()).startsWith("/sites content/live")) {
                    drive.setProperty("exo:path", path.replace("/sites content/live", "/sites"));
                    drive.setProperty("exo:views", "Web");
                    continue;
                }
                if (path.equals("/Groups${groupId}")) {
                    path = path.replace("/Groups${groupId}", "/Groups${groupId}/Documents");
                    drive.setProperty("exo:path", path);
                    drive.setProperty("exo:views", "List, Icons");
                    continue;
                }
                if (drive.getName().equals("collaboration") && path.equals("/")) {
                    drive.remove();
                    continue;
                }
                if (drive.getName().equals("Trash") && path.equals("/Trash")) {
                    drive.setProperty("exo:views", "Admin");
                    continue;
                }
                if (drive.getName().equals("acme-category")) {
                    drive.remove();
                    continue;
                }
                if (drive.getName().equals("Private") || drive.getName().equals("Public")) {
                    drive.remove();
                    continue;
                }
                if ("Personal Documents".equals(drive.getName())) {
                    drive.setProperty("exo:viewNonDocument", false);
                    continue;
                }
                if (drive.getProperty("exo:workspace").getString().equals("dms-system") && path.equals("/")) {
                    drive.remove();
                    continue;
                }
                String views = drive.getProperty("exo:views").getString();
                String[] arrView = views.contains(",") ? views.split(",") : new String[]{views};
                StringBuilder strViews = new StringBuilder();
                for (String view : arrView) {
                    if (strViews.length() > 0) {
                        strViews.append(", ");
                    }
                    if ((view = view.trim()).contains("timeline-view")) {
                        strViews.append("List");
                        continue;
                    }
                    if (view.contains("list-view")) {
                        strViews.append("List");
                        continue;
                    }
                    if (view.contains("icon-view")) {
                        strViews.append("Icons");
                        continue;
                    }
                    if (view.contains("cover-flow")) {
                        strViews.append("Icons");
                        continue;
                    }
                    if (view.contains("admin-view")) {
                        strViews.append("Admin");
                        continue;
                    }
                    if (view.contains("simple-view")) {
                        strViews.append("Icons");
                        continue;
                    }
                    if (view.contains("slide-show")) {
                        strViews.append("Icons");
                        continue;
                    }
                    if (view.contains("anonymous-view")) {
                        strViews.append("Icons");
                        continue;
                    }
                    if (view.contains("taxonomy-list")) {
                        strViews.append("Categories");
                        continue;
                    }
                    if (view.contains("taxonomy-icons")) {
                        strViews.append("Categories");
                        continue;
                    }
                    if (view.contains("system-view")) {
                        strViews.append("List");
                        continue;
                    }
                    if (view.contains("wcm-view")) {
                        strViews.append("Web");
                        continue;
                    }
                    if (view.contains("authoring-view")) {
                        strViews.append("Web");
                        continue;
                    }
                    if (view.contains("wcm-category-view")) {
                        strViews.append("Categories");
                        continue;
                    }
                    strViews.append(view);
                }
                drive.setProperty("exo:views", strViews.toString());
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Completed the migration data for drives=====");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migratePortletPreferences() {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession("portal-system", this.repoService_.getCurrentRepository());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start migrate old preferences=====");
            }
            String statement = "select * from mop:portletpreference where mop:value like '%/sites content/live/%'";
            QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
            NodeIterator nodeIter = result.getNodes();
            while (nodeIter.hasNext()) {
                Node preferenceNode = nodeIter.nextNode();
                String oldPath = preferenceNode.getProperty("mop:value").getValues()[0].getString();
                String newPath = StringUtils.replace((String)oldPath, (String)"/sites content/live/", (String)"/sites/");
                preferenceNode.setProperty("mop:value", new String[]{newPath});
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"===== Portlet preference upgrade completed =====");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateLinkInContents() {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession("collaboration", this.repoService_.getCurrentRepository());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start migrate old link in contents=====");
            }
            String statement = "select * from exo:linkable where exo:links like '%/sites content/live/%'";
            QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
            NodeIterator nodeIter = result.getNodes();
            while (nodeIter.hasNext()) {
                Node contentNode = nodeIter.nextNode();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("=====Migrating content '" + contentNode.getPath() + "' ====="));
                }
                Value[] oldLinks = contentNode.getProperty("exo:links").getValues();
                ArrayList<String> newLinks = new ArrayList<String>();
                for (Value linkValue : oldLinks) {
                    newLinks.add(StringUtils.replace((String)linkValue.getString(), (String)"/sites content/live/", (String)"/sites/"));
                }
                contentNode.setProperty("exo:links", newLinks.toArray(new String[newLinks.size()]));
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"===== Migrate content links completed =====");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateSocialActivities() {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession("social", this.repoService_.getCurrentRepository());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start migrate soc:url for all activities=====");
            }
            String statement = "SELECT * FROM soc:activity WHERE soc:url like '%/sites content/live/%'";
            QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
            NodeIterator nodeIter = result.getNodes();
            while (nodeIter.hasNext()) {
                Node activity = nodeIter.nextNode();
                String nodeUrl = activity.getProperty("soc:url").getString();
                activity.setProperty("soc:url", StringUtils.replace((String)nodeUrl, (String)"/sites content/live/", (String)"/sites/"));
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Completed the migration for soc:url=====");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateTaxonomyAction() {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            String wsName = this.repoService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Session session = sessionProvider.getSession(wsName, this.repoService_.getCurrentRepository());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start to migrate taxonomy actions=====");
            }
            String statement = "select * from exo:taxonomyAction where (exo:targetPath like '%/sites content/live/%' or exo:storeHomePath like '%/sites content/live/%')";
            QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
            NodeIterator nodeIter = result.getNodes();
            while (nodeIter.hasNext()) {
                Node taxoAction = nodeIter.nextNode();
                String targetPath = taxoAction.getProperty("exo:targetPath").getString();
                String homePath = taxoAction.getProperty("exo:storeHomePath").getString();
                taxoAction.setProperty("exo:targetPath", StringUtils.replace((String)targetPath, (String)"/sites content/live/", (String)"/sites/"));
                taxoAction.setProperty("exo:storeHomePath", StringUtils.replace((String)homePath, (String)"/sites content/live/", (String)"/sites/"));
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Completed the migration for taxonomy action=====");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateDriveNameOfPortletPreferences() {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession("portal-system", this.repoService_.getCurrentRepository());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start migrate portlet preferences drive name=====");
            }
            String statement = "select * from mop:portletpreference where exo:name='mop:driveName' and mop:value='collaboration'";
            QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
            NodeIterator nodeIter = result.getNodes();
            while (nodeIter.hasNext()) {
                Node preferenceNode = nodeIter.nextNode();
                preferenceNode.setProperty("mop:value", new String[]{"Collaboration"});
            }
            session.save();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"===== Preference drive name have been upgrade completed =====");
            }
        }
    }
}

