/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.List;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.space.UISpaceAddForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/space/UISpaceSearch.gtmpl", events={@EventConfig(listeners={AddSpaceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class})})
public class UISpaceSearch
extends UIForm {
    public static final String SPACE_SEARCH = "SpaceSearch";
    public static final String SEARCH = "Search";
    private static final String ASTERIK_STR = "*";
    private static final String PERCENTAGE_STR = "%";
    private static final String POPUP_ADD_SPACE = "UIPopupAddSpace";
    private static final String HTML_ATTRIBUTE_TITLE = "title";
    private static final String HTML_ATTRIBUTE_PLACEHOLDER = "placeholder";
    SpaceService spaceService = null;
    private List<Space> spaceList = null;
    String spaceNameSearch = null;
    int spaceNum;
    List<String> spaceNameForAutoSuggest = null;
    private boolean isNewSearch;
    String typeOfRelation = null;
    String spaceURL = null;

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public int getSpaceNum() {
        return this.spaceNum;
    }

    public void setSpaceNum(int spaceNum) {
        this.spaceNum = spaceNum;
    }

    public String getTypeOfRelation() {
        return this.typeOfRelation != null ? this.typeOfRelation : "";
    }

    public void setTypeOfRelation(String typeOfRelation) {
        this.typeOfRelation = typeOfRelation;
    }

    public String getSpaceURL() {
        return this.spaceURL != null ? this.spaceURL : "";
    }

    public void setSpaceURL(String spaceURL) {
        this.spaceURL = spaceURL;
    }

    public void setSpaceList(List<Space> spaceList) {
        this.spaceList = spaceList;
    }

    public List<Space> getSpaceList() throws Exception {
        return this.spaceList;
    }

    public UISpaceSearch() throws Exception {
        if (this.getId() == null) {
            this.setId("UISpaceSearch");
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SPACE_SEARCH, SPACE_SEARCH, ""));
        this.addChild(PopupContainer.class, null, "PopupContainer_SpaceSearch");
        this.setSubmitAction("return false;");
    }

    protected void initPlaceholder() throws Exception {
        UIFormStringInput findSpace = this.getUIStringInput(SPACE_SEARCH);
        findSpace.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, this.getLabel("FindSpace"));
        findSpace.setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, this.getLabel("DefaultSpaceNameAndDesc"));
    }

    public boolean isNewSearch() {
        return this.isNewSearch;
    }

    public void setNewSearch(boolean isNewSearch) {
        this.isNewSearch = isNewSearch;
    }

    public static class AddSpaceActionListener
    extends EventListener<UISpaceSearch> {
        public void execute(Event<UISpaceSearch> event) throws Exception {
            UISpaceSearch uiSpaceSearch = (UISpaceSearch)((Object)event.getSource());
            PopupContainer uiPopup = (PopupContainer)uiSpaceSearch.getChild(PopupContainer.class);
            uiPopup.activate(UISpaceAddForm.class, 625, UISpaceSearch.POPUP_ADD_SPACE);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class SearchActionListener
    extends EventListener<UISpaceSearch> {
        public void execute(Event<UISpaceSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UISpaceSearch uiSpaceSearch = (UISpaceSearch)((Object)event.getSource());
            String searchCondition = (String)uiSpaceSearch.getUIStringInput(UISpaceSearch.SPACE_SEARCH).getValue();
            if (searchCondition == null || UISpaceSearch.ASTERIK_STR.equals(searchCondition) || UISpaceSearch.PERCENTAGE_STR.equals(searchCondition)) {
                uiSpaceSearch.setSpaceNameSearch(null);
                uiSpaceSearch.setNewSearch(true);
            } else {
                if (searchCondition != null) {
                    searchCondition = Utils.normalizeString(searchCondition);
                }
                uiSpaceSearch.setSpaceNameSearch(searchCondition);
                uiSpaceSearch.setNewSearch(true);
            }
            Event searchEvent = uiSpaceSearch.getParent().createEvent(UISpaceSearch.SEARCH, Event.Phase.PROCESS, ctx);
            if (searchEvent != null) {
                searchEvent.broadcast();
            }
        }
    }
}

