/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFWordExtractorDecorator
extends AbstractOOXMLExtractor {
    private XWPFDocument document;
    private XWPFStyles styles;

    public XWPFWordExtractorDecorator(ParseContext context, XWPFWordExtractor extractor) {
        super(context, (POIXMLTextExtractor)extractor);
        this.document = (XWPFDocument)extractor.getDocument();
        this.styles = this.document.getStyles();
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XWPFHeaderFooterPolicy hfPolicy = this.document.getHeaderFooterPolicy();
        if (hfPolicy != null) {
            this.extractHeaders(xhtml, hfPolicy);
        }
        this.extractIBodyText((IBody)this.document, xhtml);
        if (hfPolicy != null) {
            this.extractFooters(xhtml, hfPolicy);
        }
    }

    private void extractIBodyText(IBody bodyElement, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        for (IBodyElement element : bodyElement.getBodyElements()) {
            if (element instanceof XWPFParagraph) {
                XWPFParagraph paragraph = (XWPFParagraph)element;
                this.extractParagraph(paragraph, xhtml);
            }
            if (!(element instanceof XWPFTable)) continue;
            XWPFTable table = (XWPFTable)element;
            this.extractTable(table, xhtml);
        }
    }

    private void extractParagraph(XWPFParagraph paragraph, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        String footnameText;
        XWPFCommentsDecorator comments;
        String commentText;
        CTSectPr ctSectPr;
        XWPFHeaderFooterPolicy headerFooterPolicy = null;
        if (paragraph.getCTP().getPPr() != null && (ctSectPr = paragraph.getCTP().getPPr().getSectPr()) != null) {
            headerFooterPolicy = new XWPFHeaderFooterPolicy(this.document, ctSectPr);
            this.extractHeaders(xhtml, headerFooterPolicy);
        }
        String tag = "p";
        String styleClass = null;
        if (paragraph.getStyleID() != null) {
            XWPFStyle style = this.styles.getStyle(paragraph.getStyleID());
            WordExtractor.TagAndStyle tas = WordExtractor.buildParagraphTagAndStyle(style.getName(), paragraph.getPartType() == BodyType.TABLECELL);
            tag = tas.getTag();
            styleClass = tas.getStyleClass();
        }
        if (styleClass == null) {
            xhtml.startElement(tag);
        } else {
            xhtml.startElement(tag, "class", styleClass);
        }
        for (CTBookmark bookmark : paragraph.getCTP().getBookmarkStartList()) {
            xhtml.startElement("a", "name", bookmark.getName());
            xhtml.endElement("a");
        }
        boolean curBold = false;
        boolean curItalic = false;
        for (XWPFRun run : paragraph.getRuns()) {
            if (run.isBold() != curBold) {
                if (curItalic) {
                    xhtml.endElement("i");
                    curItalic = false;
                }
                if (run.isBold()) {
                    xhtml.startElement("b");
                } else {
                    xhtml.endElement("b");
                }
                curBold = run.isBold();
            }
            if (run.isItalic() != curItalic) {
                if (run.isItalic()) {
                    xhtml.startElement("i");
                } else {
                    xhtml.endElement("i");
                }
                curItalic = run.isItalic();
            }
            boolean addedHREF = false;
            if (run instanceof XWPFHyperlinkRun) {
                XWPFHyperlinkRun linkRun = (XWPFHyperlinkRun)run;
                XWPFHyperlink link = linkRun.getHyperlink(this.document);
                if (link != null && link.getURL() != null) {
                    xhtml.startElement("a", "href", link.getURL());
                    addedHREF = true;
                } else if (linkRun.getAnchor() != null && linkRun.getAnchor().length() > 0) {
                    xhtml.startElement("a", "href", "#" + linkRun.getAnchor());
                    addedHREF = true;
                }
            }
            xhtml.characters(run.toString());
            for (XWPFPicture picture : run.getEmbeddedPictures()) {
                XWPFPictureData data;
                if (paragraph.getDocument() == null || (data = picture.getPictureData()) == null) continue;
                AttributesImpl attr = new AttributesImpl();
                attr.addAttribute("", "src", "src", "CDATA", "embedded:" + data.getFileName());
                attr.addAttribute("", "alt", "alt", "CDATA", picture.getDescription());
                xhtml.startElement("img", attr);
                xhtml.endElement("img");
            }
            if (!addedHREF) continue;
            xhtml.endElement("a");
        }
        if (curItalic) {
            xhtml.endElement("i");
            curItalic = false;
        }
        if (curBold) {
            xhtml.endElement("b");
            curBold = false;
        }
        if ((commentText = (comments = new XWPFCommentsDecorator(paragraph, null)).getCommentText()) != null && commentText.length() > 0) {
            xhtml.characters(commentText);
        }
        if ((footnameText = paragraph.getFootnoteText()) != null && footnameText.length() > 0) {
            xhtml.characters(footnameText + "\n");
        }
        xhtml.endElement(tag);
        if (headerFooterPolicy != null) {
            this.extractFooters(xhtml, headerFooterPolicy);
        }
    }

    private void extractTable(XWPFTable table, XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        xhtml.startElement("table");
        xhtml.startElement("tbody");
        for (XWPFTableRow row : table.getRows()) {
            xhtml.startElement("tr");
            for (XWPFTableCell cell : row.getTableCells()) {
                xhtml.startElement("td");
                this.extractIBodyText((IBody)cell, xhtml);
                xhtml.endElement("td");
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("tbody");
        xhtml.endElement("table");
    }

    private void extractFooters(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy) throws SAXException, XmlException, IOException {
        if (hfPolicy.getFirstPageFooter() != null) {
            this.extractHeaderText(xhtml, (XWPFHeaderFooter)hfPolicy.getFirstPageFooter());
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            this.extractHeaderText(xhtml, (XWPFHeaderFooter)hfPolicy.getEvenPageFooter());
        }
        if (hfPolicy.getDefaultFooter() != null) {
            this.extractHeaderText(xhtml, (XWPFHeaderFooter)hfPolicy.getDefaultFooter());
        }
    }

    private void extractHeaders(XHTMLContentHandler xhtml, XWPFHeaderFooterPolicy hfPolicy) throws SAXException, XmlException, IOException {
        if (hfPolicy == null) {
            return;
        }
        if (hfPolicy.getFirstPageHeader() != null) {
            this.extractHeaderText(xhtml, (XWPFHeaderFooter)hfPolicy.getFirstPageHeader());
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            this.extractHeaderText(xhtml, (XWPFHeaderFooter)hfPolicy.getEvenPageHeader());
        }
        if (hfPolicy.getDefaultHeader() != null) {
            this.extractHeaderText(xhtml, (XWPFHeaderFooter)hfPolicy.getDefaultHeader());
        }
    }

    private void extractHeaderText(XHTMLContentHandler xhtml, XWPFHeaderFooter header) throws SAXException, XmlException, IOException {
        for (XWPFParagraph p : header.getParagraphs()) {
            this.extractParagraph(p, xhtml);
        }
        for (XWPFTable table : header.getTables()) {
            this.extractTable(table, xhtml);
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        parts.add(this.document.getPackagePart());
        return parts;
    }
}

