/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiLocationContainer;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.control.action.core.AbstractEventActionComponent;
import org.exoplatform.wiki.webui.control.filter.DeniedOnWikiHomePageFilter;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.listener.MoreContainerActionListener;
import org.exoplatform.wiki.webui.popup.UIWikiMovePageForm;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/AbstractActionComponent.gtmpl", events={@EventConfig(listeners={MovePageActionListener.class})})
public class MovePageActionComponent
extends AbstractEventActionComponent {
    public static final String ACTION = "MovePage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsViewModeFilter(), new DeniedOnWikiHomePageFilter(), new EditPagesPermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Override
    public String getActionName() {
        return ACTION;
    }

    @Override
    public boolean isAnchor() {
        return false;
    }

    public static class MovePageActionListener
    extends MoreContainerActionListener<MovePageActionComponent> {
        @Override
        protected void processEvent(Event<MovePageActionComponent> event) throws Exception {
            ResourceBundle res = event.getRequestContext().getApplicationResourceBundle();
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((MovePageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            if (Utils.getCurrentWikiPage().getName().equals("WikiHome")) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiMovePageForm.msg.can-not-move-wikihome", null, 1));
                return;
            }
            UIPopupContainer uiPopupContainer = uiWikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            UIWikiMovePageForm movePageForm = (UIWikiMovePageForm)uiPopupContainer.activate(UIWikiMovePageForm.class, 600);
            movePageForm.setDupplicatedPages(null);
            UIWikiLocationContainer locationContainer = (UIWikiLocationContainer)movePageForm.findFirstComponentOfType(UIWikiLocationContainer.class);
            UIWikiBreadCrumb currentLocation = (UIWikiBreadCrumb)locationContainer.getChildById("currentLocation");
            currentLocation.setBreadCumbs(wikiService.getBreadcumb(params.getType(), params.getOwner(), params.getPageId()));
            UIFormInputInfo pageNameInfo = movePageForm.getUIFormInputInfo("pageNameInfo");
            pageNameInfo.setValue((Object)(res.getString("UIWikiMovePageForm.msg.you-are-about-move-page") + " " + Utils.getCurrentWikiPage().getTitle()));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            super.processEvent(event);
        }
    }
}

