/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.importer;

import java.util.Arrays;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;

public class PageImporter {
    private final Page src;
    private final DataStorage service;
    private final PageService pageService;
    private final ImportMode mode;

    public PageImporter(ImportMode importMode, Page page, DataStorage dataStorage_, PageService pageService) {
        this.mode = importMode;
        this.src = page;
        this.service = dataStorage_;
        this.pageService = pageService;
    }

    public void perform() throws Exception {
        Page dst;
        PageContext existingPage = this.pageService.loadPage(this.src.getPageKey());
        switch (this.mode) {
            case CONSERVE: {
                dst = null;
                break;
            }
            case INSERT: {
                if (existingPage == null) {
                    dst = this.src;
                    break;
                }
                dst = null;
                break;
            }
            case MERGE: 
            case OVERWRITE: {
                dst = this.src;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (dst != null) {
            PageState dstState = new PageState(dst.getTitle(), dst.getDescription(), dst.isShowMaxWindow(), dst.getFactoryId(), dst.getAccessPermissions() != null ? Arrays.asList(dst.getAccessPermissions()) : null, dst.getEditPermission());
            this.pageService.savePage(new PageContext(this.src.getPageKey(), dstState));
            this.service.save(dst);
        }
    }
}

