/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.io.Serializable;
import java.util.Collection;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.scope.ScopedKey;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.DataCache;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class ExoDataCache
extends DataCache {
    protected ExoCache<ScopedKey<?>, Serializable> cache;
    protected FutureExoCache<ScopedKey<?>, Serializable, POMSession> objects;
    private Loader<ScopedKey<?>, Serializable, POMSession> navigationLoader = new Loader<ScopedKey<?>, Serializable, POMSession>(){

        public Serializable retrieve(POMSession session, ScopedKey<?> scopedKey) throws Exception {
            Serializable key = scopedKey.getKey();
            if (key instanceof SiteKey) {
                NavigationData data = ExoDataCache.this.loadNavigation(session, (SiteKey)key);
                return data == NavigationData.EMPTY ? null : data;
            }
            return ExoDataCache.this.loadNode(session, (String)((Object)key));
        }
    };

    public ExoDataCache(CacheService cacheService) {
        this.cache = cacheService.getCacheInstance(NavigationService.class.getSimpleName());
        this.objects = new FutureExoCache(this.navigationLoader, this.cache);
    }

    @Override
    protected void removeNodes(Collection<String> keys) {
        for (String key : keys) {
            this.cache.remove((Serializable)ScopedKey.create((Serializable)((Object)key)));
        }
    }

    @Override
    protected NodeData getNode(POMSession session, String key) {
        return (NodeData)this.objects.get((Object)session, (Object)ScopedKey.create((Serializable)((Object)key)));
    }

    @Override
    protected void removeNavigation(SiteKey key) {
        this.cache.remove((Serializable)ScopedKey.create((Serializable)key));
    }

    @Override
    protected NavigationData getNavigation(POMSession session, SiteKey key) {
        return (NavigationData)this.objects.get((Object)session, (Object)ScopedKey.create((Serializable)key));
    }

    @Override
    protected void clear() {
        this.cache.clearCache();
    }
}

