/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.Visible;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.gatein.mop.api.Attributes;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.link.Link;
import org.gatein.mop.api.workspace.link.PageLink;

class NodeData
implements Serializable {
    final String parentId;
    final String id;
    final String name;
    final NodeState state;
    final String[] children;

    NodeData(Navigation navigation) {
        PageLink pageLink;
        Page target;
        String[] children;
        List _children = navigation.getChildren();
        if (_children == null) {
            children = Utils.EMPTY_STRING_ARRAY;
        } else {
            children = new String[_children.size()];
            int index = 0;
            for (Navigation child : _children) {
                children[index++] = child.getObjectId();
            }
        }
        String label = null;
        if (navigation.isAdapted(Described.class)) {
            Described described = (Described)navigation.adapt(Described.class);
            label = described.getName();
        }
        Visibility visibility = Visibility.DISPLAYED;
        Date startPublicationDate = null;
        Date endPublicationDate = null;
        if (navigation.isAdapted(Visible.class)) {
            Visible visible = (Visible)navigation.adapt(Visible.class);
            visibility = visible.getVisibility();
            startPublicationDate = visible.getStartPublicationDate();
            endPublicationDate = visible.getEndPublicationDate();
        }
        PageKey pageRef = null;
        Link link = navigation.getLink();
        if (link instanceof PageLink && (target = (pageLink = (PageLink)link).getPage()) != null) {
            Site site = target.getSite();
            pageRef = Utils.siteType(site.getObjectType()).key(site.getName()).page(target.getName());
        }
        Attributes attrs = navigation.getAttributes();
        NodeState state = new NodeState(label, (String)attrs.getValue(MappedAttributes.ICON), startPublicationDate != null ? startPublicationDate.getTime() : -1L, endPublicationDate != null ? endPublicationDate.getTime() : -1L, visibility, pageRef);
        Navigation parent = navigation.getParent();
        String parentId = parent != null ? parent.getObjectId() : null;
        this.parentId = parentId;
        this.id = navigation.getObjectId();
        this.name = navigation.getName();
        this.state = state;
        this.children = children;
    }

    NodeData(NodeContext<?> context) {
        int size = 0;
        for (NodeContext current = (NodeContext)context.getFirst(); current != null; current = (NodeContext)current.getNext()) {
            ++size;
        }
        String[] children = new String[size];
        for (NodeContext current = (NodeContext)context.getFirst(); current != null; current = (NodeContext)current.getNext()) {
            children[children.length - size--] = current.handle;
        }
        String parentId = context.getParent() != null ? ((NodeContext)context.getParent()).handle : null;
        String id = context.handle;
        String name = context.getName();
        NodeState state = context.getState();
        this.parentId = parentId;
        this.id = id;
        this.name = name;
        this.state = state;
        this.children = children;
    }

    NodeData(String parentId, String id, String name, NodeState state, String[] children) {
        this.parentId = parentId;
        this.id = id;
        this.name = name;
        this.state = state;
        this.children = children;
    }

    public Iterator<String> iterator(boolean reverse) {
        if (reverse) {
            return new Iterator<String>(){
                int index;
                {
                    this.index = NodeData.this.children.length;
                }

                @Override
                public boolean hasNext() {
                    return this.index > 0;
                }

                @Override
                public String next() {
                    if (this.index > 0) {
                        return NodeData.this.children[--this.index];
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<String>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < NodeData.this.children.length;
            }

            @Override
            public String next() {
                if (this.index < NodeData.this.children.length) {
                    return NodeData.this.children[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public NodeState getState() {
        return this.state;
    }

    public String toString() {
        return "NodeData[id=" + this.id + ",name=" + this.name + ",state=" + this.state + ",children=" + Arrays.asList(this.children) + "]";
    }
}

