/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.tasks;

import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.cache.CacheableDataTask;
import org.exoplatform.portal.pom.config.cache.DataAccessMode;
import org.gatein.mop.api.content.Customization;

public abstract class PreferencesTask<S> {

    public static class Save<S>
    extends PreferencesTask<S>
    implements CacheableDataTask<String, Void> {
        private final String storageId;
        private final S prefs;

        public Save(String storageId, S prefs) {
            this.storageId = storageId;
            this.prefs = prefs;
        }

        @Override
        public DataAccessMode getAccessMode() {
            return DataAccessMode.WRITE;
        }

        @Override
        public Class<Void> getValueType() {
            return Void.class;
        }

        @Override
        public String getKey() {
            return this.storageId;
        }

        @Override
        public Void run(POMSession session) {
            Customization<?> customization = session.findCustomizationById(this.storageId);
            if (customization == null) {
                throw new NoSuchDataException("Can not find " + this.storageId);
            }
            if (this.prefs != null) {
                customization.setState(this.prefs);
            } else {
                customization.setState(null);
            }
            return null;
        }

        public String toString() {
            return "PreferencesTask.Save[id=" + this.storageId + "]";
        }
    }

    public static class Load<S>
    extends PreferencesTask<S>
    implements CacheableDataTask<String, S> {
        private final String storageId;
        private final Class<S> valueType;

        public Load(String storageId, Class<S> valueType) {
            this.storageId = storageId;
            this.valueType = valueType;
        }

        @Override
        public DataAccessMode getAccessMode() {
            return DataAccessMode.READ;
        }

        @Override
        public Class<S> getValueType() {
            return this.valueType;
        }

        @Override
        public String getKey() {
            return this.storageId;
        }

        @Override
        public S run(POMSession session) {
            Customization<?> customization = session.findCustomizationById(this.storageId);
            if (customization == null) {
                return null;
            }
            return (S)customization.getVirtualState();
        }

        public String toString() {
            return "PreferencesTask.Load[id=" + this.storageId + "]";
        }
    }

    public static class GetContentId<S>
    extends PreferencesTask<S>
    implements POMTask<String> {
        private final String storageId;

        public GetContentId(String storageId) {
            this.storageId = storageId;
        }

        @Override
        public String run(POMSession session) {
            Customization<?> customization = session.findCustomizationById(this.storageId);
            if (customization == null) {
                throw new NoSuchDataException("Can not find " + this.storageId);
            }
            return customization.getContentId();
        }
    }
}

