/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UIContainerActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/container/UITabContainer.gtmpl", events={@EventConfig(listeners={UIContainerActionListener.EditContainerActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIContainer.deleteContainer"), @EventConfig(listeners={SelectTabActionListener.class}), @EventConfig(listeners={MoveLeftActionListener.class}), @EventConfig(listeners={MoveRightActionListener.class}), @EventConfig(listeners={AddTabActionListener.class})})
public class UITabContainer
extends UIContainer {
    public static final String TAB_CONTAINER = "TabContainer";
    public static final String FIRST_TAB = "FirstTab";
    public static final String LAST_TAB = "LastTab";

    private void moveTab(UITabContainer container, String childId, boolean isToLeft) {
        UIComponent selectedChild = container.getChildById(childId);
        List children = container.getChildren();
        int selectedIndex = children.indexOf(selectedChild);
        if (isToLeft) {
            if (selectedIndex > 0) {
                Collections.swap(children, selectedIndex, selectedIndex - 1);
            }
        } else if (selectedIndex < children.size() - 1) {
            Collections.swap(children, selectedIndex, selectedIndex + 1);
        }
    }

    public String getTabState(UIComponent uiChild, UITabContainer uiContainer) {
        String tabState = "";
        List children = uiContainer.getChildren();
        int tabIndex = children.indexOf(uiChild);
        if (tabIndex == 0) {
            tabState = FIRST_TAB;
        } else if (tabIndex == children.size() - 1) {
            tabState = LAST_TAB;
        }
        return tabState;
    }

    public static class AddTabActionListener
    extends EventListener<UITabContainer> {
        public void execute(Event<UITabContainer> event) throws Exception {
            UITabContainer container = (UITabContainer)((Object)event.getSource());
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (container == null) {
                return;
            }
            List children = container.getChildren();
            for (UIComponent child : children) {
                if (!child.isRendered() || !(child instanceof UIContainer)) continue;
                UIContainer newTabContainer = (UIContainer)container.addChild(UIContainer.class, null, null);
                newTabContainer.setTemplate(child.getTemplate());
                child.setRendered(false);
                newTabContainer.setRendered(true);
                newTabContainer.setId(String.valueOf(((Object)((Object)newTabContainer)).hashCode()));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)container);
                pcontext.ignoreAJAXUpdateOnPortlets(true);
                pcontext.getJavascriptManager().require("SHARED/portalComposer", "portalComposer").addScripts("portalComposer.toggleSaveButton();");
                return;
            }
        }
    }

    public static class MoveRightActionListener
    extends MoveActionListener {
        public void execute(Event<UITabContainer> event) throws Exception {
            this.doMove(event, false);
        }
    }

    public static class MoveLeftActionListener
    extends MoveActionListener {
        public void execute(Event<UITabContainer> event) throws Exception {
            this.doMove(event, true);
        }
    }

    public static abstract class MoveActionListener
    extends EventListener<UITabContainer> {
        public void doMove(Event<UITabContainer> event, boolean isToLeft) {
            PortalRequestContext context = (PortalRequestContext)event.getRequestContext();
            UITabContainer container = (UITabContainer)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (container == null || objectId == null) {
                return;
            }
            container.moveTab(container, objectId, isToLeft);
            context.addUIComponentToUpdateByAjax((UIComponent)container);
            context.ignoreAJAXUpdateOnPortlets(true);
            context.getJavascriptManager().require("SHARED/portalComposer", "portalComposer").addScripts("portalComposer.toggleSaveButton();");
        }
    }

    public static class SelectTabActionListener
    extends EventListener<UITabContainer> {
        public void execute(Event<UITabContainer> event) throws Exception {
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            UITabContainer container = (UITabContainer)((Object)event.getSource());
            UIComponent goal = container.findComponentById(objectId);
            if (goal == null) {
                return;
            }
            UITabContainer parent = (UITabContainer)goal.getParent();
            List children = parent.getChildren();
            for (UIComponent child : children) {
                if (child.getId().equals(objectId)) {
                    child.setRendered(true);
                    continue;
                }
                child.setRendered(false);
            }
        }
    }
}

