/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.navigation.component.help;

import org.exoplatform.platform.navigation.component.utils.DashboardUtils;
import org.exoplatform.platform.navigation.component.utils.NavigationUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;

public class Helper {
    private static final Log LOG = ExoLogger.getExoLogger(Helper.class);
    public static final String DEFAULT_HELP_ID = "default";

    public static boolean present(String theString) {
        boolean present = false;
        if (theString != null && theString.length() != 0) {
            present = true;
        }
        return present;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCurrentNavigation(SpaceService spaceService) {
        try {
            String dashboardUrl;
            String nav = Util.getUIPortal().getNavPath().getName();
            String url = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
            if (url.contains("/:spaces:") || url.contains("/spaces/")) {
                if (url.contains("documents")) {
                    return "space:document";
                }
                if (url.contains("wiki")) {
                    return "space:wiki";
                }
                if (url.contains("answer") || url.contains("faq") || url.contains("poll")) {
                    return "space:faq_annswer";
                }
                if (url.contains("calendar")) {
                    return "space:calendar";
                }
                if (url.contains("forum")) {
                    return "space:forum";
                }
                if (nav.equals("settings")) {
                    return "space:manager";
                }
                String spaceUrl = Helper.getSelectedPageNode().getURI();
                Space space = spaceService.getSpaceByUrl(spaceUrl);
                if (space == null) return DEFAULT_HELP_ID;
                if (space.getPrettyName().equals(nav)) {
                    return "space:activity_stream";
                }
            } else {
                if (url.contains("wiki") && Helper.isProfileOwner()) {
                    return "personnal:wiki";
                }
                if (url.contains("profile") && Helper.isProfileOwner()) {
                    return "personnal:profile";
                }
                if (url.contains("connections") && Helper.isProfileOwner()) {
                    return "personnal:connections";
                }
                if (url.contains("activities") && Helper.isProfileOwner()) {
                    return "personnal:activities";
                }
                if (url.contains("notifications") && Helper.isProfileOwner()) {
                    return "personnal:notifications";
                }
                if (url.contains("all-spaces")) {
                    return "personnal:all-spaces";
                }
                if (nav != null && nav.equals("home")) {
                    if (SiteKey.portal((String)Helper.getCurrentPortal()) != null && SiteKey.portal((String)Helper.getCurrentPortal()).getName().equals("intranet")) {
                        return "Company Context Home";
                    }
                } else {
                    if (nav != null && nav.equals("calendar")) {
                        return "Company Context Calendar";
                    }
                    if (nav != null && nav.equals("forum")) {
                        return "Company Context Forum";
                    }
                    if (nav != null && nav.equals("wiki")) {
                        return "Company Context Wiki";
                    }
                    if (nav != null && nav.equals("documents")) {
                        return "Company Context Documents";
                    }
                    if (nav != null && (nav.equals("FAQ") || nav.equals("answers"))) {
                        return "Company Context FAQ:Answers";
                    }
                    if (nav != null && nav.equals("connexions")) {
                        return "Company Context Connections";
                    }
                }
            }
            if (!url.contains((dashboardUrl = DashboardUtils.getDashboardURL()).substring(0, dashboardUrl.lastIndexOf("/")))) return DEFAULT_HELP_ID;
            return "dashboard";
        }
        catch (Exception E) {
            LOG.warn((Object)"Can not load the currentNavigation ", (Throwable)E);
            return null;
        }
    }

    public static boolean isProfileOwner() {
        return Utils.getViewerRemoteId().equals(NavigationUtils.getCurrentUser());
    }

    public static String getCurrentPortal() {
        return Util.getPortalRequestContext().getPortalOwner();
    }

    public static UserNode getSelectedPageNode() throws Exception {
        return Util.getUIPortal().getSelectedUserNode();
    }
}

