/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws.bean;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.ws.bean.AttachmentResource;
import org.exoplatform.calendar.ws.bean.RepeatResource;
import org.exoplatform.calendar.ws.common.Resource;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.webservice.cs.bean.End;

public class EventResource
extends Resource {
    private static final long serialVersionUID = 9085055105843346382L;
    private String subject;
    private String description;
    private String from;
    private String to;
    private Serializable calendar;
    private Serializable[] categories;
    private String location;
    private String priority;
    private RepeatResource repeat;
    private String recurrenceId;
    private Serializable originalEvent;
    private Reminder[] reminder;
    private Serializable[] attachments;
    private String[] participants;
    private String privacy;
    private String availability;
    private String categoryId;

    public EventResource() {
        super(null);
    }

    public EventResource(CalendarEvent data, String basePath) throws Exception {
        super(data.getId());
        End end;
        StringBuilder href = new StringBuilder(basePath).append("/events/").append(data.getId());
        this.setHref(href.toString());
        this.subject = data.getSummary();
        this.description = data.getDescription();
        GregorianCalendar fromCal = Utils.getInstanceTempCalendar();
        fromCal.setTime(data.getFromDateTime());
        this.from = ISO8601.format((Calendar)fromCal);
        GregorianCalendar toCal = Utils.getInstanceTempCalendar();
        toCal.setTime(data.getToDateTime());
        this.to = ISO8601.format((Calendar)toCal);
        this.calendar = basePath + "/calendars/" + data.getCalendarId();
        if (data.getEventCategoryId() != null) {
            this.categories = new String[]{basePath + "/categories/" + data.getEventCategoryId()};
            this.categoryId = data.getEventCategoryId();
        }
        this.location = data.getLocation();
        this.priority = data.getPriority();
        if (data.getRepeatUntilDate() != null) {
            Calendar tmp = Calendar.getInstance();
            tmp.setTime(data.getRepeatUntilDate());
            end = new End(data.getRepeatType(), ISO8601.format((Calendar)tmp));
        } else {
            end = new End(data.getRepeatType(), String.valueOf(data.getRepeatCount()));
        }
        StringBuilder repeatByMonthDay = new StringBuilder();
        if (data.getRepeatByMonthDay() != null) {
            for (long d : data.getRepeatByMonthDay()) {
                repeatByMonthDay.append(d).append(",");
            }
            if (repeatByMonthDay.length() > 0) {
                repeatByMonthDay.deleteCharAt(repeatByMonthDay.length() - 1);
            }
        }
        boolean isRepeat = data.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(data.getRepeatType());
        this.repeat = new RepeatResource(isRepeat, data.getRepeatType(), (int)data.getRepeatInterval(), StringUtils.join((Object[])data.getRepeatByDay(), (String)","), repeatByMonthDay.toString(), data.getExceptionIds(), end);
        this.recurrenceId = data.getOriginalReference();
        if (data.getOriginalReference() != null) {
            this.originalEvent = basePath + "/events/" + data.getOriginalReference();
        }
        if (data.getReminders() != null) {
            this.reminder = data.getReminders().toArray(new Reminder[0]);
        }
        if (data.getAttachment() != null) {
            LinkedList<String> atts = new LinkedList<String>();
            for (Attachment att : data.getAttachment()) {
                AttachmentResource attRs = new AttachmentResource(att, basePath);
                atts.add(attRs.getHref());
            }
            this.attachments = (Serializable[])atts.toArray(new String[atts.size()]);
        }
        this.participants = data.getParticipant();
        this.privacy = data.isPrivate() ? CalendarEvent.IS_PRIVATE : CalendarEvent.IS_PUBLIC;
        this.availability = data.getEventState();
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Serializable getCalendar() {
        return this.calendar;
    }

    public EventResource setCal(Serializable calendar) {
        this.calendar = calendar;
        return this;
    }

    public Serializable[] getCategories() {
        return this.categories;
    }

    public void setCats(Serializable[] categories) {
        this.categories = categories;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public RepeatResource getRepeat() {
        return this.repeat;
    }

    public void setRepeat(RepeatResource repeat) {
        this.repeat = repeat;
    }

    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public Serializable getOriginalEvent() {
        return this.originalEvent;
    }

    public void setOEvent(Serializable originalEvent) {
        this.originalEvent = originalEvent;
    }

    public Reminder[] getReminder() {
        return this.reminder;
    }

    public void setReminder(Reminder[] reminder) {
        this.reminder = reminder;
    }

    public Serializable[] getAttachments() {
        return this.attachments;
    }

    public void setAtts(Serializable[] attachments) {
        this.attachments = attachments;
    }

    public String[] getParticipants() {
        return this.participants;
    }

    public void setParticipants(String[] participants) {
        this.participants = participants;
    }

    public String getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(String privacy) {
        this.privacy = privacy;
    }

    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }
}

