/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.InputStream;
import java.util.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.RemoteCalendar;
import org.exoplatform.calendar.service.impl.ICalendarImportExport;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.JobDetailImpl;

public class ImportCalendarJob
implements Job,
InterruptableJob {
    public static final String IMPORT_CALENDAR_JOB_NAME = "import_calendar_job";
    public static final String IMPORT_CALENDAR_JOB_GROUP_NAME = "import_calendar_job_group";
    public static final String IMPORT_OR_SUBSCRIBE = "import_or_subscribe";
    public static final String IMPORT_UPLOADED_FILE = "import_uploaded_file";
    public static final String IMPORT_REMOTE_CALENDAR = "import_remote_calendar";
    public static final String REMOTE_CALENDAR = "remote_calendar";
    public static final String INPUT_STREAM = "input_stream";
    public static final String CALENDAR_NAME = "calendar_name";
    public static final String IMPORT_FROM_TIME = "import_from_time";
    public static final String IMPORT_TO_TIME = "import_to_time";
    public static final String IS_IMPORT_NEW = "is_import_new";
    public static final String CALENDAR_ID = "calendarId";
    public static final String USER_NAME = "username";
    public static final String IMPORT_CALENDAR_CHANNEL = "/eXo/Application/Calendar/notifyImportCalendar";
    public static final String START_MESSAGE_KEY = "startImport:%s";
    public static final String FINISH_MESSAGE_KEY = "finishImport:%s";
    public static final String ERROR_MESSAGE_KEY = "errorImport:%s";
    private static Log log = ExoLogger.getLogger(ImportCalendarJob.class);

    public void interrupt() throws UnableToInterruptJobException {
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info((Object)"Start importing calendar....");
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        CalendarService calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String type = jobDataMap.getString(IMPORT_OR_SUBSCRIBE);
        String username = jobDataMap.getString(USER_NAME);
        String calendarName = jobDataMap.getString(CALENDAR_NAME);
        continuation.sendMessage(username, IMPORT_CALENDAR_CHANNEL, (Object)String.format(START_MESSAGE_KEY, calendarName));
        try {
            if (IMPORT_UPLOADED_FILE.equals(type)) {
                String calendarId = jobDataMap.getString(CALENDAR_ID);
                Calendar from = (Calendar)jobDataMap.get((Object)IMPORT_FROM_TIME);
                Calendar to = (Calendar)jobDataMap.get((Object)IMPORT_TO_TIME);
                Boolean isNew = (Boolean)jobDataMap.get((Object)IS_IMPORT_NEW);
                InputStream icalInputStream = (InputStream)jobDataMap.get((Object)INPUT_STREAM);
                ICalendarImportExport iCalImEx = (ICalendarImportExport)calendarService.getCalendarImportExports("ICalendar(.ics)");
                iCalImEx.importCalendar(username, icalInputStream, calendarId, calendarName, from, to, isNew);
            } else {
                RemoteCalendar remoteCalendar = (RemoteCalendar)jobDataMap.get((Object)REMOTE_CALENDAR);
                calendarService.importRemoteCalendar(remoteCalendar);
            }
            continuation.sendMessage(username, IMPORT_CALENDAR_CHANNEL, (Object)String.format(FINISH_MESSAGE_KEY, calendarName));
            log.info((Object)"finished importing icalendar");
        }
        catch (Exception e) {
            continuation.sendMessage(username, IMPORT_CALENDAR_CHANNEL, (Object)String.format(ERROR_MESSAGE_KEY, calendarName));
            log.error((Object)"Exception occurs when importing calendar", (Throwable)e);
        }
    }

    public static JobDetail getImportICSFileJobDetail(String username, String calendarId, String calendarName, InputStream icalInputStream, Calendar from, Calendar to, boolean isNew) {
        JobDetailImpl job = new JobDetailImpl();
        job.setName(calendarId);
        job.setGroup(IMPORT_CALENDAR_JOB_GROUP_NAME);
        job.setJobClass(ImportCalendarJob.class);
        job.setDescription("Import calendar by job");
        job.getJobDataMap().put(IMPORT_OR_SUBSCRIBE, IMPORT_UPLOADED_FILE);
        job.getJobDataMap().put(USER_NAME, username);
        job.getJobDataMap().put(INPUT_STREAM, (Object)icalInputStream);
        job.getJobDataMap().put(CALENDAR_ID, calendarId);
        job.getJobDataMap().put(CALENDAR_NAME, calendarName);
        job.getJobDataMap().put(IMPORT_FROM_TIME, (Object)from);
        job.getJobDataMap().put(IMPORT_TO_TIME, (Object)to);
        job.getJobDataMap().put(IS_IMPORT_NEW, isNew);
        return job;
    }

    public static JobDetail getImportRemoteCalendarJobDetail(RemoteCalendar remoteCalendar) {
        JobDetailImpl job = new JobDetailImpl();
        job.setName(remoteCalendar.getCalendarName());
        job.setGroup(IMPORT_CALENDAR_JOB_GROUP_NAME);
        job.setJobClass(ImportCalendarJob.class);
        job.setDescription("Import remote calendar by job");
        job.getJobDataMap().put(USER_NAME, remoteCalendar.getUsername());
        job.getJobDataMap().put(CALENDAR_NAME, remoteCalendar.getCalendarName());
        job.getJobDataMap().put(IMPORT_OR_SUBSCRIBE, IMPORT_REMOTE_CALENDAR);
        job.getJobDataMap().put(REMOTE_CALENDAR, (Object)remoteCalendar);
        return job;
    }
}

