/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.ContextualTask;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.AbstractCodecBuilder;
import org.exoplatform.web.security.hash.JCASaltedHashService;
import org.exoplatform.web.security.hash.SaltedHashException;
import org.exoplatform.web.security.hash.SaltedHashService;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieToken;
import org.exoplatform.web.security.security.HashedToken;
import org.exoplatform.web.security.security.TokenContainer;
import org.exoplatform.web.security.security.TokenEntry;
import org.exoplatform.web.security.security.TokenExistsException;
import org.exoplatform.web.security.security.TokenParseException;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.security.Credentials;

public class CookieTokenService
extends AbstractTokenService<GateInToken, String> {
    public static final String LIFECYCLE_NAME = "lifecycle-name";
    public static final String HASH_SERVICE_INIT_PARAM = "hash.service";
    private ChromatticLifeCycle chromatticLifeCycle;
    private String lifecycleName = "autologin";
    private AbstractCodec codec;
    private SaltedHashService saltedHashService;
    private final Logger log = LoggerFactory.getLogger(CookieTokenService.class);

    public CookieTokenService(InitParams initParams, ChromatticManager chromatticManager) throws TokenServiceInitializationException {
        super(initParams);
        ArrayList serviceConfig = initParams.getValuesParam("service.configuration").getValues();
        if (serviceConfig.size() > 3) {
            this.lifecycleName = (String)serviceConfig.get(3);
        }
        this.chromatticLifeCycle = chromatticManager.getLifeCycle(this.lifecycleName);
        ObjectParameter hashServiceParam = initParams.getObjectParam(HASH_SERVICE_INIT_PARAM);
        this.saltedHashService = hashServiceParam == null || hashServiceParam.getObject() == null ? new JCASaltedHashService() : (SaltedHashService)hashServiceParam.getObject();
        this.initCodec();
    }

    private void initCodec() throws TokenServiceInitializationException {
        HashMap<String, String> config;
        String builderType;
        block16: {
            block15: {
                builderType = PropertyManager.getProperty((String)"gatein.codec.builderclass");
                config = new HashMap<String, String>();
                if (builderType == null) break block15;
                String configFile = PropertyManager.getProperty((String)"gatein.codec.config");
                FileInputStream in = null;
                try {
                    File f = new File(configFile);
                    in = new FileInputStream(f);
                    Properties properties = new Properties();
                    properties.load(in);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        config.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
                }
                catch (IOException e) {
                    try {
                        throw new TokenServiceInitializationException("Failed to read the config parameters from file '" + configFile + "'.", e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(in);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)in);
                break block16;
            }
            builderType = "org.exoplatform.web.security.codec.JCASymmetricCodecBuilder";
            String gtnConfDir = PropertyManager.getProperty((String)"gatein.conf.dir");
            if (gtnConfDir == null || gtnConfDir.length() == 0) {
                throw new TokenServiceInitializationException("'gatein.conf.dir' property must be set.");
            }
            File f = new File(gtnConfDir + "/codec/codeckey.txt");
            if (!f.exists()) {
                File codecDir = f.getParentFile();
                if (!codecDir.exists()) {
                    codecDir.mkdir();
                }
                FileOutputStream out = null;
                try {
                    KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                    keyGen.init(128);
                    SecretKey key = keyGen.generateKey();
                    KeyStore store = KeyStore.getInstance("JCEKS");
                    store.load(null, "gtnStorePass".toCharArray());
                    store.setEntry("gtnKey", new KeyStore.SecretKeyEntry(key), new KeyStore.PasswordProtection("gtnKeyPass".toCharArray()));
                    out = new FileOutputStream(f);
                    store.store(out, "gtnStorePass".toCharArray());
                }
                catch (Exception e) {
                    try {
                        throw new TokenServiceInitializationException(e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(out);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)out);
            }
            config.put("gatein.codec.jca.symmetric.keyalg", "AES");
            config.put("gatein.codec.jca.symmetric.keystore", "codeckey.txt");
            config.put("gatein.codec.jca.symmetric.storetype", "JCEKS");
            config.put("gatein.codec.jca.symmetric.alias", "gtnKey");
            config.put("gatein.codec.jca.symmetric.keypass", "gtnKeyPass");
            config.put("gatein.codec.jca.symmetric.storepass", "gtnStorePass");
            config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
        }
        try {
            this.codec = Class.forName(builderType).asSubclass(AbstractCodecBuilder.class).newInstance().build(config);
            this.log.info((Object)("Initialized CookieTokenService.codec using builder " + builderType));
        }
        catch (Exception e) {
            throw new TokenServiceInitializationException("Could not initialize CookieTokenService.codec.", e);
        }
    }

    @Override
    public void start() {
        new TokenTask<Void>(){

            protected Void execute(SessionContext context) {
                ChromatticSession session = context.getSession();
                TokenContainer container = (TokenContainer)session.findByPath(TokenContainer.class, CookieTokenService.this.lifecycleName);
                if (container != null) {
                    container.cleanLegacyTokens();
                } else {
                    session.insert(TokenContainer.class, CookieTokenService.this.lifecycleName);
                }
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
        super.start();
    }

    @Override
    public String createToken(final Credentials credentials) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (credentials == null) {
            throw new NullPointerException();
        }
        return (String)new TokenTask<String>(){

            protected String execute(SessionContext context) {
                String cookieTokenString = null;
                TokenContainer tokenContainer = this.getTokenContainer();
                while (cookieTokenString == null) {
                    String randomString = CookieTokenService.this.nextTokenId();
                    String id = CookieTokenService.this.nextRandom();
                    cookieTokenString = new CookieToken(id, randomString).toString();
                    String hashedRandomString = CookieTokenService.this.hashToken(randomString);
                    long expirationTimeMillis = System.currentTimeMillis() + CookieTokenService.this.validityMillis;
                    String encryptedPassword = CookieTokenService.this.codec.encode(credentials.getPassword());
                    Credentials encodedCredentials = new Credentials(credentials.getUsername(), encryptedPassword);
                    try {
                        tokenContainer.saveToken(context.getSession(), id, hashedRandomString, encodedCredentials, new Date(expirationTimeMillis));
                    }
                    catch (TokenExistsException e) {
                        cookieTokenString = null;
                    }
                }
                return cookieTokenString;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    protected String nextTokenId() {
        return this.nextRandom();
    }

    @Override
    public GateInToken getToken(String cookieTokenString) {
        CookieToken token = null;
        try {
            token = new CookieToken(cookieTokenString);
            return (GateInToken)new RemovableGetTokenTask(token, false).executeWith(this.chromatticLifeCycle);
        }
        catch (TokenParseException e) {
            this.log.warn((Object)("Could not parse cookie token:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public GateInToken deleteToken(String cookieTokenString) {
        CookieToken token = null;
        try {
            token = new CookieToken(cookieTokenString);
            return (GateInToken)new RemovableGetTokenTask(token, true).executeWith(this.chromatticLifeCycle);
        }
        catch (TokenParseException e) {
            this.log.warn((Object)("Could not parse cookie token:" + e.getMessage()));
            return null;
        }
    }

    public void deleteTokensOfUser(final String user) {
        new TokenTask<Void>(){

            protected Void execute(SessionContext context) {
                QueryResult<TokenEntry> result = this.findTokensOfUser(user);
                while (result.hasNext()) {
                    TokenEntry en = (TokenEntry)result.next();
                    en.remove();
                }
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public void deleteAll() {
        new TokenTask<Void>(){

            protected Void execute(SessionContext context) {
                this.getTokenContainer().removeAll();
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    public void cleanExpiredTokens() {
        new TokenTask<Void>(){

            protected Void execute(SessionContext context) {
                this.getTokenContainer().cleanExpiredTokens();
                return null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    public long size() {
        return (Long)new TokenTask<Long>(){

            protected Long execute(SessionContext context) {
                return this.getTokenContainer().size();
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    protected String decodeKey(String stringKey) {
        return stringKey;
    }

    private String hashToken(String tokenId) {
        if (this.saltedHashService != null) {
            try {
                return this.saltedHashService.getSaltedHash(tokenId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return tokenId;
    }

    private class RemovableGetTokenTask
    extends TokenTask<GateInToken> {
        private final CookieToken token;
        private final boolean remove;

        public RemovableGetTokenTask(CookieToken token, boolean remove) {
            this.token = token;
            this.remove = remove;
        }

        protected GateInToken execute(SessionContext context) {
            HashedToken hashedToken;
            TokenEntry en = this.getTokenContainer().getTokens().get(this.token.getId());
            if (en != null && (hashedToken = this.getMixin(en, HashedToken.class)) != null && hashedToken.getHashedToken() != null) {
                try {
                    if (CookieTokenService.this.saltedHashService.validate(this.token.getRandomString(), hashedToken.getHashedToken())) {
                        GateInToken encryptedToken = en.getToken();
                        Credentials encryptedCredentials = encryptedToken.getPayload();
                        Credentials decryptedCredentials = new Credentials(encryptedCredentials.getUsername(), CookieTokenService.this.codec.decode(encryptedCredentials.getPassword()));
                        if (this.remove) {
                            en.remove();
                        }
                        return new GateInToken(encryptedToken.getExpirationTimeMillis(), decryptedCredentials);
                    }
                }
                catch (SaltedHashException e) {
                    CookieTokenService.this.log.warn((Object)"Could not validate cookie token against its salted hash.", (Throwable)e);
                }
            }
            return null;
        }
    }

    private abstract class TokenTask<V>
    extends ContextualTask<V> {
        private TokenTask() {
        }

        protected final TokenContainer getTokenContainer() {
            SessionContext ctx = CookieTokenService.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            return (TokenContainer)session.findByPath(TokenContainer.class, CookieTokenService.this.lifecycleName);
        }

        protected final <A> A getMixin(Object o, Class<A> type) {
            SessionContext ctx = CookieTokenService.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            return (A)session.getEmbedded(o, type);
        }

        protected final QueryResult<TokenEntry> findTokensOfUser(String user) {
            SessionContext ctx = CookieTokenService.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            TokenContainer tokenContainer = this.getTokenContainer();
            String statement = new StringBuilder(128).append("jcr:path LIKE '").append(session.getPath((Object)tokenContainer)).append("/%'").append(" AND username='").append(Utils.queryEscape((String)user)).append("'").toString();
            return session.createQueryBuilder(TokenEntry.class).where(statement).get().objects();
        }
    }
}

