/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.plugin.doc.UIDocActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class UIDocActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        UIDocActivity docActivity = (UIDocActivity)uiActivity;
        if (activity.getTemplateParams() == null) {
            this.saveToNewDataFormat(activity);
        }
        Map activityParams = activity.getTemplateParams();
        docActivity.docLink = (String)activityParams.get("DOCLINK");
        docActivity.docName = (String)activityParams.get("DOCNAME");
        docActivity.message = (String)activityParams.get("MESSAGE");
        docActivity.docPath = (String)activityParams.get("DOCPATH");
        docActivity.repository = (String)activityParams.get("REPOSITORY");
        docActivity.workspace = (String)activityParams.get("WORKSPACE");
        docActivity.docPath = this.escapeIllegalJcrCharsOnNodeName(docActivity.docPath);
    }

    private String escapeIllegalJcrCharsOnNodeName(String path) {
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex != -1) {
            String nodeName = path.substring(lastIndex + 1);
            path = new StringBuffer(path).delete(path.length() - nodeName.length(), path.length()).append(Text.escapeIllegalJcrChars((String)nodeName)).toString();
        }
        return path;
    }

    private void saveToNewDataFormat(ExoSocialActivity activity) {
        try {
            JSONObject jsonObject = new JSONObject(activity.getTitle());
            String docActivityTitle = "<a href=\"${DOCLINK}\">${DOCNAME}</a>";
            activity.setTitle("<a href=\"${DOCLINK}\">${DOCNAME}</a>");
            HashMap<String, String> activityParams = new HashMap<String, String>();
            activityParams.put("DOCNAME", jsonObject.getString("DOCNAME"));
            activityParams.put("DOCLINK", jsonObject.getString("DOCLINK"));
            activityParams.put("DOCPATH", jsonObject.getString("DOCPATH"));
            activityParams.put("REPOSITORY", jsonObject.getString("REPOSITORY"));
            activityParams.put("WORKSPACE", jsonObject.getString("WORKSPACE"));
            activityParams.put("MESSAGE", jsonObject.getString("MESSAGE"));
            activity.setTemplateParams(activityParams);
            ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
            activityManager.saveActivityNoReturn(activity);
            activity = activityManager.getActivity(activity.getId());
        }
        catch (JSONException je) {
            LOG.error((Object)"Error with activity's title data");
        }
        catch (ActivityStorageException ase) {
            LOG.error((Object)"Could not save new data format for document activity.", (Throwable)ase);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error  to save document activity.", (Throwable)e);
        }
    }
}

