/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCollection;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventDAO;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Invitation;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.ws.RestEventQuery;
import org.exoplatform.calendar.ws.SubResourceHrefBuilder;
import org.exoplatform.calendar.ws.bean.AttachmentResource;
import org.exoplatform.calendar.ws.bean.CalendarResource;
import org.exoplatform.calendar.ws.bean.CategoryResource;
import org.exoplatform.calendar.ws.bean.CollectionResource;
import org.exoplatform.calendar.ws.bean.ErrorResource;
import org.exoplatform.calendar.ws.bean.EventResource;
import org.exoplatform.calendar.ws.bean.FeedResource;
import org.exoplatform.calendar.ws.bean.InvitationResource;
import org.exoplatform.calendar.ws.bean.RepeatResource;
import org.exoplatform.calendar.ws.bean.TaskResource;
import org.exoplatform.calendar.ws.common.Resource;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webservice.cs.bean.End;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/v1/calendar")
public class CalendarRestApi
implements ResourceContainer {
    public static final String CAL_BASE_URI = "/v1/calendar";
    public static final String TEXT_ICS = "text/calendar";
    public static final MediaType TEXT_ICS_TYPE = new MediaType("text", "calendar");
    public static final String BASE_URL = "/cs/calendar";
    public static final String BASE_EVENT_URL = "/cs/calendar/event";
    public static final String CALENDAR_URI = "/calendars/";
    public static final String EVENT_URI = "/events/";
    public static final String TASK_URI = "/tasks/";
    public static final String ICS_URI = "/ics";
    public static final String ATTACHMENT_URI = "/attachments/";
    public static final String OCCURRENCE_URI = "/occurrences";
    public static final String CATEGORY_URI = "/categories/";
    public static final String FEED_URI = "/feeds/";
    public static final String RSS_URI = "/rss";
    public static final String INVITATION_URI = "/invitations/";
    public static final String HEADER_LINK = "Link";
    public static final String HEADER_LOCATION = "Location";
    private OrganizationService orgService;
    private int query_limit = 10;
    private SubResourceHrefBuilder subResourcesBuilder = new SubResourceHrefBuilder(this);
    private static final CacheControl nc = new CacheControl();
    public static final String DEFAULT_CAL_NAME = "calendar";
    public static final String DEFAULT_EVENT_NAME = "default";
    public static final String[] RP_WEEKLY_BYDAY = (String[])CalendarEvent.RP_WEEKLY_BYDAY.clone();
    public static final String[] EVENT_AVAILABILITY = new String[]{CalendarEvent.ST_AVAILABLE, CalendarEvent.ST_BUSY, CalendarEvent.ST_OUTSIDE};
    public static final String[] REPEATTYPES = (String[])CalendarEvent.REPEATTYPES.clone();
    public static final String[] PRIORITY = (String[])CalendarEvent.PRIORITY.clone();
    public static final String[] TASK_STATUS = (String[])CalendarEvent.TASK_STATUS.clone();
    private static final String[] INVITATION_STATUS = new String[]{"", "maybe", "yes", "no"};
    private final CacheControl cc = new CacheControl();
    private Log log = ExoLogger.getExoLogger(CalendarRestApi.class);

    public CalendarRestApi(OrganizationService orgService, InitParams params) {
        this.orgService = orgService;
        int maxAge = 604800;
        if (params != null) {
            ValueParam cacheConfig;
            if (params.getValueParam("query_limit") != null) {
                this.query_limit = Integer.parseInt(params.getValueParam("query_limit").getValue());
            }
            if ((cacheConfig = params.getValueParam("cache_maxage")) != null) {
                try {
                    maxAge = Integer.parseInt(cacheConfig.getValue());
                }
                catch (Exception ex) {
                    this.log.warn("Can't parse {} to maxAge, use the default value {}", new Object[]{cacheConfig, maxAge});
                }
            }
        }
        this.cc.setPrivate(true);
        this.cc.setMaxAge(maxAge);
        this.cc.setSMaxAge(maxAge);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response getSubResources(@Context UriInfo uri) {
        HashMap<String, String[]> subResources = new HashMap<String, String[]>();
        subResources.put("subResourcesHref", this.subResourcesBuilder.buildResourceMap(uri));
        return Response.ok(subResources, (String)"application/json").cacheControl(nc).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/")
    @Produces(value={"application/json"})
    public Response getCalendars(@QueryParam(value="type") String type, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="returnSize") boolean returnSize, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uri) {
        try {
            Response.ResponseBuilder okResult;
            CalendarCollection cals;
            limit = this.parseLimit(limit);
            Calendar.Type calType = Calendar.Type.UNDEFINED;
            if (type != null) {
                try {
                    calType = Calendar.Type.valueOf((String)type.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
            }
            if ((cals = CalendarRestApi.calendarServiceInstance().getAllCalendars(this.currentUserId(), calType.type(), offset, limit)) == null || cals.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            String basePath = this.getBasePath(uri);
            LinkedList<Object> data = new LinkedList<Object>();
            for (Calendar cal : cals) {
                data.add(this.extractObject(new CalendarResource(cal, basePath), fields));
            }
            CollectionResource calData = new CollectionResource(data, returnSize ? cals.getFullSize() : -1L);
            calData.setOffset(offset);
            calData.setLimit(limit);
            if (jsonp != null) {
                JsonValue value = new JsonGeneratorImpl().createJsonObject(calData);
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(value).append(");");
                okResult = Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript"));
            } else {
                okResult = Response.ok(calData, (String)"application/json");
            }
            if (returnSize) {
                okResult.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, calData.getSize()));
            }
            return okResult.cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/")
    public Response createCalendar(CalendarResource cal, @Context UriInfo uriInfo) {
        Response error;
        Calendar calendar = new Calendar();
        if (cal.getName() == null) {
            cal.setName(DEFAULT_CAL_NAME);
        }
        if ((error = this.buildCalendar(calendar, cal)) != null) {
            return error;
        }
        if (cal.getGroups() != null && cal.getGroups().length > 0) {
            if (!this.isInGroups(cal.getGroups())) return Response.status((int)401).cacheControl(nc).build();
            CalendarRestApi.calendarServiceInstance().savePublicCalendar(calendar, true);
            return Response.status((int)201).header(HEADER_LOCATION, (Object)(uriInfo.getAbsolutePath() + cal.getId())).cacheControl(nc).build();
        } else {
            if (cal.getOwner() != null && !cal.getOwner().equals(this.currentUserId())) {
                return Response.status((int)401).cacheControl(nc).build();
            }
            CalendarRestApi.calendarServiceInstance().saveUserCalendar(this.currentUserId(), calendar, true);
        }
        return Response.status((int)201).header(HEADER_LOCATION, (Object)(uriInfo.getAbsolutePath() + cal.getId())).cacheControl(nc).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}")
    @Produces(value={"application/json"})
    public Response getCalendarById(@PathParam(value="id") String id, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            CalendarService service = CalendarRestApi.calendarServiceInstance();
            Calendar cal = service.getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            cal.setCalType(service.getTypeOfCalendar(this.currentUserId(), cal.getId()));
            Date lastModified = new Date(cal.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            CalendarResource calData = null;
            if (this.hasViewCalendarPermission(cal, this.currentUserId())) {
                calData = new CalendarResource(cal, this.getBasePath(uriInfo));
            }
            if (calData == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Object resource = this.extractObject(calData, fields);
            if (jsonp != null) {
                String json = null;
                if (resource instanceof Map) {
                    json = new JSONObject(resource).toString();
                } else {
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    json = generatorImpl.createJsonObject(resource).toString();
                }
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(json).append(");");
                return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.ok((Object)resource, (String)"application/json").cacheControl(this.cc).lastModified(lastModified).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}")
    public Response updateCalendarById(@PathParam(value="id") String id, CalendarResource calObj) {
        try {
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if ((this.currentUserId().equals(cal.getCalendarOwner()) || cal.getGroups() != null) && Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                Response error = this.buildCalendar(cal, calObj);
                if (error != null) {
                    return error;
                }
                int type = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), cal.getId());
                CalendarRestApi.calendarServiceInstance().saveCalendar(cal.getCalendarOwner(), cal, type, false);
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}")
    public Response deleteCalendarById(@PathParam(value="id") String id) {
        try {
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            cal.setCalType(CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id));
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal) || cal.getCalType() == 1) {
                switch (cal.getCalType()) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().removeUserCalendar(cal.getCalendarOwner(), id);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().removePublicCalendar(id);
                        break;
                    }
                    case 1: {
                        if (!this.hasViewCalendarPermission(cal, this.currentUserId())) break;
                        CalendarRestApi.calendarServiceInstance().removeSharedCalendar(this.currentUserId(), id);
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/ics")
    @Produces(value={"text/calendar"})
    public Response exportCalendarToIcs(@PathParam(value="id") String id, @Context Request request) {
        try {
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId())) {
                int type = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id);
                String username = this.currentUserId();
                if (type == -1) {
                    type = 0;
                    username = cal.getCalendarOwner();
                }
                CalendarImportExport iCalExport = CalendarRestApi.calendarServiceInstance().getCalendarImportExports("ICalendar(.ics)");
                ArrayList<String> calIds = new ArrayList<String>();
                calIds.add(id);
                OutputStream out = iCalExport.exportCalendar(username, calIds, String.valueOf(type), -1);
                byte[] data = out.toString().getBytes();
                byte[] hashCode = this.digest(data).getBytes();
                EntityTag tag = new EntityTag(new String(hashCode));
                Response.ResponseBuilder preCondition = request.evaluatePreconditions(tag);
                if (preCondition != null) {
                    return preCondition.build();
                }
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                return Response.ok((Object)in, (MediaType)TEXT_ICS_TYPE).header("Content-Disposition", (Object)("attachment;filename=\"" + cal.getName() + ".ics")).cacheControl(this.cc).tag(tag).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}")
    @Produces(value={"application/json"})
    public Response getEventById(@PathParam(value="id") String id, @QueryParam(value="fields") String fields, @QueryParam(value="expand") String expand, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            CalendarService service = CalendarRestApi.calendarServiceInstance();
            CalendarEvent ev = service.getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(ev.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            boolean inParticipant = false;
            Object[] participant = ev.getParticipant();
            if (participant != null) {
                Arrays.sort(participant);
                if (Arrays.binarySearch(participant, this.currentUserId()) > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                Object resource = this.buildEventResource(ev, uriInfo, expand, fields);
                return this.buildJsonP(resource, jsonp).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}")
    public Response updateEventById(@PathParam(value="id") String id, EventResource evObject) {
        try {
            CalendarEvent old = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (old == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(old.getCalendarId());
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                Response error = this.buildEvent(old, evObject);
                if (error != null) {
                    return error;
                }
                int calType = -1;
                try {
                    calType = Integer.parseInt(old.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), old.getCalendarId());
                }
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().saveUserEvent(this.currentUserId(), old.getCalendarId(), old, false);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().savePublicEvent(old.getCalendarId(), old, false);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().saveEventToSharedCalendar(this.currentUserId(), old.getCalendarId(), old, false);
                        break;
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}")
    public Response deleteEventById(@PathParam(value="id") String id) {
        try {
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                try {
                    calType = Integer.parseInt(ev.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), ev.getCalendarId());
                }
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().removeUserEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().removePublicEvent(ev.getCalendarId(), id);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().removeSharedEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/attachments")
    @Produces(value={"application/json"})
    public Response getAttachmentsFromEvent(@PathParam(value="id") String id, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo) {
        try {
            limit = this.parseLimit(limit);
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null || ev.getAttachment() == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            boolean inParticipant = false;
            if (ev.getParticipant() != null) {
                Object[] participant = ev.getParticipant();
                Arrays.sort(participant);
                int i = Arrays.binarySearch(participant, this.currentUserId());
                if (i > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                Iterator it = ev.getAttachment().iterator();
                ArrayList<Object> attResource = new ArrayList<Object>();
                Utils.skip(it, (long)offset);
                int counter = 0;
                String basePath = this.getBasePath(uriInfo);
                while (it.hasNext()) {
                    Attachment a = (Attachment)it.next();
                    attResource.add(this.extractObject(new AttachmentResource(a, basePath), fields));
                    if (++counter != limit) continue;
                    break;
                }
                CollectionResource evData = new CollectionResource(attResource, ev.getAttachment().size());
                evData.setOffset(offset);
                evData.setLimit(limit);
                if (jsonp != null) {
                    JsonValue value = new JsonGeneratorImpl().createJsonObject(evData);
                    StringBuilder sb = new StringBuilder(jsonp);
                    sb.append("(").append(value).append(");");
                    return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(nc).header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, evData.getSize())).build();
                }
                return Response.ok(evData, (String)"application/json").header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, evData.getSize())).cacheControl(nc).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/attachments")
    @Consumes(value={"multipart/*"})
    public Response createAttachmentForEvent(@Context UriInfo uriInfo, @PathParam(value="id") String id, Iterator<FileItem> iter) {
        try {
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                ArrayList<Attachment> attachment = new ArrayList<Attachment>();
                try {
                    calType = Integer.parseInt(ev.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), ev.getCalendarId());
                }
                attachment.addAll(ev.getAttachment());
                while (iter.hasNext()) {
                    FileItem file = iter.next();
                    String fileName = file.getName();
                    if (fileName == null) continue;
                    String mimeType = new MimeTypeResolver().getMimeType(fileName.toLowerCase());
                    Attachment at = new Attachment();
                    at.setMimeType(mimeType);
                    at.setSize(file.getSize());
                    at.setName(file.getName());
                    at.setInputStream(file.getInputStream());
                    attachment.add(at);
                }
                ev.setAttachment(attachment);
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().saveUserEvent(this.currentUserId(), ev.getCalendarId(), ev, false);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().savePublicEvent(ev.getCalendarId(), ev, false);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().saveEventToSharedCalendar(this.currentUserId(), ev.getCalendarId(), ev, false);
                        break;
                    }
                }
                StringBuilder attUri = new StringBuilder(this.getBasePath(uriInfo));
                attUri.append("/").append(ev.getId());
                attUri.append(ATTACHMENT_URI);
                return Response.status((int)201).header(HEADER_LOCATION, (Object)attUri.toString()).cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/events")
    @Produces(value={"application/json"})
    public Response getEventsByCalendar(@PathParam(value="id") String id, @QueryParam(value="startTime") String start, @QueryParam(value="endTime") String end, @QueryParam(value="category") String category, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @QueryParam(value="expand") String expand, @QueryParam(value="returnSize") boolean returnSize, @Context UriInfo uri) throws Exception {
        limit = this.parseLimit(limit);
        String username = this.currentUserId();
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        long fullSize = returnSize ? 0L : -1L;
        LinkedList<Object> data = new LinkedList<Object>();
        Calendar calendar = service.getCalendarById(id);
        if (calendar != null) {
            if (calendar.hasChildren()) {
                String participant = null;
                if (calendar.getPublicUrl() == null && !this.hasViewCalendarPermission(calendar, username)) {
                    participant = username;
                }
                EventQuery eventQuery = this.buildEventQuery(start, end, category, Arrays.asList(calendar), id, participant, CalendarEvent.TYPE_EVENT);
                ListAccess events = evtDAO.findEventsByQuery(eventQuery);
                for (CalendarEvent event : (CalendarEvent[])events.load(offset, limit)) {
                    data.add(this.buildEventResource(event, uri, expand, fields));
                }
                if (returnSize) {
                    fullSize = events.getSize();
                }
            }
        } else {
            return Response.status((int)404).cacheControl(nc).build();
        }
        CollectionResource evData = new CollectionResource(data, fullSize);
        evData.setOffset(offset);
        evData.setLimit(limit);
        Response.ResponseBuilder response = this.buildJsonP(evData, jsonp);
        if (returnSize) {
            response.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, fullSize));
        }
        return response.build();
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/events")
    public Response createEventForCalendar(@PathParam(value="id") String id, EventResource evObject, @Context UriInfo uriInfo) {
        try {
            Response error;
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            CalendarEvent evt = new CalendarEvent();
            if (evObject.getSubject() == null) {
                evObject.setSubject(DEFAULT_EVENT_NAME);
            }
            if (evObject.getCategoryId() == null) {
                evObject.setCategoryId("defaultEventCategoryIdAll");
            }
            if ((error = this.buildEvent(evt, evObject)) != null) {
                return error;
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id);
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().saveUserEvent(this.currentUserId(), id, evt, true);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().savePublicEvent(id, evt, true);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().saveEventToSharedCalendar(this.currentUserId(), id, evt, true);
                        break;
                    }
                }
                String location = this.getBasePath(uriInfo) + EVENT_URI + evt.getId();
                return Response.status((int)201).header(HEADER_LOCATION, (Object)location).cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/occurrences")
    @Produces(value={"application/json"})
    public Response getOccurrencesFromEvent(@PathParam(value="id") String id, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="start") String start, @QueryParam(value="end") String end, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @QueryParam(value="expand") String expand, @QueryParam(value="returnSize") boolean returnSize, @Context UriInfo uriInfo) {
        try {
            limit = this.parseLimit(limit);
            java.util.Calendar[] dates = this.parseDate(start, end);
            CalendarEvent recurEvent = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (recurEvent == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            TimeZone tz = java.util.Calendar.getInstance().getTimeZone();
            String timeZone = tz.getID();
            Map occMap = CalendarRestApi.calendarServiceInstance().getOccurrenceEvents(recurEvent, dates[0], dates[1], timeZone);
            if (occMap == null || occMap.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(recurEvent.getCalendarId());
            boolean inParticipant = false;
            if (recurEvent.getParticipant() != null) {
                Object[] participant = recurEvent.getParticipant();
                Arrays.sort(participant);
                int i = Arrays.binarySearch(participant, this.currentUserId());
                if (i > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                ArrayList<Object> data = new ArrayList<Object>();
                Iterator evIter = occMap.values().iterator();
                Utils.skip(evIter, (long)offset);
                int counter = 0;
                while (evIter.hasNext()) {
                    data.add(this.buildEventResource((CalendarEvent)evIter.next(), uriInfo, expand, fields));
                    if (++counter != limit) continue;
                }
                int fullSize = returnSize ? occMap.values().size() : -1;
                CollectionResource evData = new CollectionResource(data, fullSize);
                evData.setOffset(offset);
                evData.setOffset(limit);
                Response.ResponseBuilder response = this.buildJsonP(evData, jsonp);
                if (returnSize) {
                    response.header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, evData.getSize()));
                }
                return response.build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/tasks")
    @Produces(value={"application/json"})
    public Response getTasksByCalendar(@PathParam(value="id") String id, @QueryParam(value="startTime") String start, @QueryParam(value="endTime") String end, @QueryParam(value="category") String category, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @QueryParam(value="expand") String expand, @QueryParam(value="returnSize") boolean returnSize, @Context UriInfo uri) throws Exception {
        limit = this.parseLimit(limit);
        String username = this.currentUserId();
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        long fullSize = returnSize ? 0L : -1L;
        LinkedList<Object> data = new LinkedList<Object>();
        Calendar calendar = service.getCalendarById(id);
        if (calendar != null) {
            String participant = null;
            if (calendar.getPublicUrl() == null && !this.hasViewCalendarPermission(calendar, username)) {
                participant = username;
            }
            EventQuery eventQuery = this.buildEventQuery(start, end, category, Arrays.asList(calendar), id, participant, CalendarEvent.TYPE_TASK);
            ListAccess events = evtDAO.findEventsByQuery(eventQuery);
            for (CalendarEvent event : (CalendarEvent[])events.load(offset, limit)) {
                data.add(this.buildTaskResource(event, uri, expand, fields));
            }
            if (returnSize) {
                fullSize = events.getSize();
            }
        } else {
            return Response.status((int)404).cacheControl(nc).build();
        }
        CollectionResource evData = new CollectionResource(data, fullSize);
        evData.setOffset(offset);
        evData.setLimit(limit);
        Response.ResponseBuilder response = this.buildJsonP(evData, jsonp);
        if (returnSize) {
            response.header(HEADER_LINK, (Object)this.buildFullUrl(uri, offset, limit, fullSize));
        }
        return response.build();
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/calendars/{id}/tasks")
    public Response createTaskForCalendar(@PathParam(value="id") String id, TaskResource evObject, @Context UriInfo uriInfo) {
        try {
            Response error;
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(id);
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            CalendarEvent evt = new CalendarEvent();
            evt.setEventType(CalendarEvent.TYPE_TASK);
            if (evObject.getName() == null) {
                evObject.setName(DEFAULT_EVENT_NAME);
            }
            if (evObject.getCategoryId() == null) {
                evObject.setCategoryId("defaultEventCategoryIdAll");
            }
            if ((error = this.buildEventFromTask(evt, evObject)) != null) {
                return error;
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), id);
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().saveUserEvent(this.currentUserId(), id, evt, true);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().savePublicEvent(id, evt, true);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().saveEventToSharedCalendar(this.currentUserId(), id, evt, true);
                        break;
                    }
                }
                String location = this.getBasePath(uriInfo) + TASK_URI + evt.getId();
                return Response.status((int)201).header(HEADER_LOCATION, (Object)location).cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/tasks/{id}")
    @Produces(value={"application/json"})
    public Response getTaskById(@PathParam(value="id") String id, @QueryParam(value="fields") String fields, @QueryParam(value="expand") String expand, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(ev.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            boolean inParticipant = false;
            if (ev.getParticipant() != null) {
                Object[] participant = ev.getParticipant();
                Arrays.sort(participant);
                if (Arrays.binarySearch(participant, this.currentUserId()) > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                Object resource = this.buildTaskResource(ev, uriInfo, expand, fields);
                return this.buildJsonP(resource, jsonp).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/tasks/{id}")
    public Response updateTaskById(@PathParam(value="id") String id, TaskResource evObject) {
        try {
            CalendarEvent old = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (old == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(old.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                try {
                    calType = Integer.parseInt(old.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), old.getCalendarId());
                }
                this.buildEventFromTask(old, evObject);
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().saveUserEvent(this.currentUserId(), old.getCalendarId(), old, false);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().savePublicEvent(old.getCalendarId(), old, false);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().saveEventToSharedCalendar(this.currentUserId(), old.getCalendarId(), old, false);
                        break;
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/tasks/{id}")
    public Response deleteTaskById(@PathParam(value="id") String id) {
        try {
            CalendarEvent ev = CalendarRestApi.calendarServiceInstance().getEventById(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                int calType = -1;
                try {
                    calType = Integer.parseInt(ev.getCalType());
                }
                catch (NumberFormatException e) {
                    calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), ev.getCalendarId());
                }
                switch (calType) {
                    case 0: {
                        CalendarRestApi.calendarServiceInstance().removeUserEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                    case 2: {
                        CalendarRestApi.calendarServiceInstance().removePublicEvent(ev.getCalendarId(), id);
                        break;
                    }
                    case 1: {
                        CalendarRestApi.calendarServiceInstance().removeSharedEvent(this.currentUserId(), ev.getCalendarId(), id);
                        break;
                    }
                }
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/attachments/{id}")
    @Produces(value={"application/json"})
    public Response getAttachmentById(@PathParam(value="id") String id, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            id = AttachmentResource.decode(id);
            CalendarEvent ev = this.findEventAttachment(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Attachment att = CalendarRestApi.calendarServiceInstance().getAttachmentById(id);
            if (att == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(att.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            boolean inParticipant = false;
            if (ev.getParticipant() != null) {
                Object[] participant = ev.getParticipant();
                Arrays.sort(participant);
                int i = Arrays.binarySearch(participant, this.currentUserId());
                if (i > -1) {
                    inParticipant = true;
                }
            }
            if (cal.getPublicUrl() != null || this.hasViewCalendarPermission(cal, this.currentUserId()) || inParticipant) {
                AttachmentResource evData = new AttachmentResource(att, this.getBasePath(uriInfo));
                Object resource = this.extractObject(evData, fields);
                if (jsonp != null) {
                    String json = null;
                    if (resource instanceof Map) {
                        json = new JSONObject(resource).toString();
                    } else {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        json = generatorImpl.createJsonObject(resource).toString();
                    }
                    StringBuilder sb = new StringBuilder(jsonp);
                    sb.append("(").append(json).append(");");
                    return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(this.cc).lastModified(lastModified).build();
                }
                return Response.ok((Object)resource, (String)"application/json").cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.status((int)404).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/attachments/{id}")
    public Response deleteAttachmentById(@PathParam(value="id") String id) {
        try {
            id = AttachmentResource.decode(id);
            CalendarEvent ev = this.findEventAttachment(id);
            if (ev == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Calendar cal = CalendarRestApi.calendarServiceInstance().getCalendarById(ev.getCalendarId());
            if (cal == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            if (Utils.isCalendarEditable((String)this.currentUserId(), (Calendar)cal)) {
                CalendarRestApi.calendarServiceInstance().removeAttachmentById(id);
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/categories")
    @Produces(value={"application/json"})
    public Response getEventCategories(@QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo) {
        limit = this.parseLimit(limit);
        try {
            CalendarCollection ecData = CalendarRestApi.calendarServiceInstance().getEventCategories(this.currentUserId(), offset, limit);
            if (ecData == null || ecData.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            ArrayList<Object> data = new ArrayList<Object>();
            String basePath = this.getBasePath(uriInfo);
            for (EventCategory ec : ecData) {
                data.add(this.extractObject(new CategoryResource(ec, basePath), fields));
            }
            CollectionResource resource = new CollectionResource(data, ecData.size());
            resource.setOffset(offset);
            resource.setLimit(limit);
            if (jsonp != null) {
                JsonValue json = new JsonGeneratorImpl().createJsonObject(resource);
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(json).append(");");
                return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, resource.getSize())).cacheControl(nc).build();
            }
            return Response.ok(resource, (String)"application/json").header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, resource.getSize())).cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/categories/{id}")
    @Produces(value={"application/json"})
    public Response getEventCategoryById(@PathParam(value="id") String id, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            List data = CalendarRestApi.calendarServiceInstance().getEventCategories(this.currentUserId());
            if (data == null || data.isEmpty()) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            EventCategory category = null;
            for (int i = 0; i < data.size(); ++i) {
                if (!id.equals(((EventCategory)data.get(i)).getId())) continue;
                category = (EventCategory)data.get(i);
                break;
            }
            if (category == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            Date lastModified = new Date(category.getLastModified());
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(lastModified);
            if (preCondition != null) {
                return preCondition.build();
            }
            CategoryResource categoryR = new CategoryResource(category, this.getBasePath(uriInfo));
            Object resource = this.extractObject(categoryR, fields);
            if (jsonp != null) {
                String json = null;
                if (resource instanceof Map) {
                    json = new JSONObject((Map)resource).toString();
                } else {
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    json = generatorImpl.createJsonObject(resource).toString();
                }
                StringBuilder sb = new StringBuilder(jsonp);
                sb.append("(").append(json).append(");");
                return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(this.cc).lastModified(lastModified).build();
            }
            return Response.ok((Object)resource, (String)"application/json").cacheControl(this.cc).lastModified(lastModified).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}")
    @Produces(value={"application/json"})
    public Response getFeedById(@PathParam(value="id") String id, @QueryParam(value="fields") String fields, @QueryParam(value="expand") String expand, @QueryParam(value="jsonp") String jsonp, @Context UriInfo uriInfo, @Context Request request) {
        try {
            FeedData feed = null;
            for (FeedData feedData : CalendarRestApi.calendarServiceInstance().getFeeds(this.currentUserId())) {
                if (!feedData.getTitle().equals(id)) continue;
                feed = feedData;
                break;
            }
            if (feed == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            byte[] data = feed.getContent();
            byte[] hashCode = this.digest(data).getBytes();
            EntityTag tag = new EntityTag(new String(hashCode));
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(tag);
            if (preCondition != null) {
                return preCondition.build();
            }
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(data)));
            ArrayList entries = new ArrayList(syndFeed.getEntries());
            ArrayList<String> calIds = new ArrayList<String>();
            for (SyndEntry entry : entries) {
                String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                calIds.add(calendarId);
            }
            Object resource = this.buildFeedResource(feed, calIds, uriInfo, expand, fields);
            return this.buildJsonP(resource, jsonp).cacheControl(this.cc).tag(tag).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}")
    public Response updateFeedById(@PathParam(value="id") String id, FeedResource feedResource) {
        try {
            FeedData feed = null;
            for (FeedData feedData : CalendarRestApi.calendarServiceInstance().getFeeds(this.currentUserId())) {
                if (!feedData.getTitle().equals(id)) continue;
                feed = feedData;
                break;
            }
            if (feed == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            LinkedHashMap<String, Calendar> calendars = new LinkedHashMap<String, Calendar>();
            if (feedResource.getCalendarIds() != null) {
                block8: for (String calendarId : feedResource.getCalendarIds()) {
                    Calendar calendar = CalendarRestApi.calendarServiceInstance().getCalendarById(calendarId);
                    int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), calendarId);
                    switch (calType) {
                        case 0: {
                            calendars.put("0:" + calendarId, calendar);
                            continue block8;
                        }
                        case 2: {
                            calendars.put("2:" + calendarId, calendar);
                            continue block8;
                        }
                        case 1: {
                            calendars.put("1:" + calendarId, calendar);
                            continue block8;
                        }
                    }
                }
            }
            CalendarRestApi.calendarServiceInstance().removeFeedData(this.currentUserId(), id);
            RssData rssData = new RssData();
            if (feedResource.getName() != null) {
                rssData.setName(feedResource.getName() + ".rss");
                rssData.setTitle(feedResource.getName());
                rssData.setDescription(feedResource.getName());
            }
            rssData.setUrl(feed.getUrl());
            rssData.setLink(feed.getUrl());
            rssData.setVersion("rss_2.0");
            CalendarRestApi.calendarServiceInstance().generateRss(this.currentUserId(), calendars, rssData);
            return Response.ok().cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}")
    public Response deleteFeedById(@PathParam(value="id") String id) {
        try {
            CalendarRestApi.calendarServiceInstance().removeFeedData(this.currentUserId(), id);
            return Response.ok().cacheControl(nc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/feeds/{id}/rss")
    @Produces(value={"application/xml"})
    public Response getRssFromFeed(@PathParam(value="id") String id, @Context UriInfo uri, @Context Request request) {
        try {
            String username = this.currentUserId();
            String feedname = id;
            FeedData feed = null;
            for (FeedData feedData : CalendarRestApi.calendarServiceInstance().getFeeds(username)) {
                if (!feedData.getTitle().equals(feedname)) continue;
                feed = feedData;
                break;
            }
            if (feed == null) {
                return Response.status((int)404).cacheControl(nc).build();
            }
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(feed.getContent())));
            ArrayList entries = new ArrayList(syndFeed.getEntries());
            ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            for (SyndEntry entry : entries) {
                String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                calendars.add(CalendarRestApi.calendarServiceInstance().getCalendarById(calendarId));
            }
            for (Calendar cal : calendars) {
                if (cal.getPublicUrl() == null && !this.hasViewCalendarPermission(cal, username)) continue;
                int calType = CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(username, cal.getId());
                switch (calType) {
                    case 0: {
                        events.addAll(CalendarRestApi.calendarServiceInstance().getUserEventByCalendar(username, Arrays.asList(cal.getId())));
                        break;
                    }
                    case 1: {
                        events.addAll(CalendarRestApi.calendarServiceInstance().getSharedEventByCalendars(username, Arrays.asList(cal.getId())));
                        break;
                    }
                    case 2: {
                        EventQuery eventQuery = new EventQuery();
                        eventQuery.setCalendarId(new String[]{cal.getId()});
                        events.addAll(CalendarRestApi.calendarServiceInstance().getPublicEvents(eventQuery));
                        break;
                    }
                }
            }
            if (events.size() == 0) {
                return Response.status((int)404).entity((Object)("Feed " + feedname + "is removed")).cacheControl(nc).build();
            }
            String xml = this.makeFeed(username, events, feed, uri);
            byte[] hashCode = this.digest(xml.getBytes()).getBytes();
            EntityTag tag = new EntityTag(new String(hashCode));
            Response.ResponseBuilder preCondition = request.evaluatePreconditions(tag);
            if (preCondition != null) {
                return preCondition.build();
            }
            return Response.ok((Object)xml, (String)"application/xml").cacheControl(this.cc).tag(tag).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)503).cacheControl(nc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/invitations/{id}")
    @Produces(value={"application/json"})
    public Response getInvitationById(@PathParam(value="id") String id, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @QueryParam(value="expand") String expand, @Context UriInfo uriInfo, @Context Request request) throws Exception {
        CalendarEvent event;
        Calendar calendar;
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        String username = this.currentUserId();
        Invitation invitation = evtDAO.getInvitationById(id);
        if (invitation == null) {
            return Response.status((int)404).cacheControl(nc).build();
        }
        EntityTag tag = new EntityTag(String.valueOf(invitation.hashCode()));
        Response.ResponseBuilder preCondition = request.evaluatePreconditions(tag);
        if (preCondition != null) {
            return preCondition.build();
        }
        if (!username.equals(invitation.getParticipant()) && !Utils.isCalendarEditable((String)username, (Calendar)(calendar = service.getCalendarById((event = service.getEventById(invitation.getEventId())).getCalendarId())))) {
            return Response.status((int)404).cacheControl(nc).build();
        }
        Object resource = this.buildInvitationResource(invitation, uriInfo, expand, fields);
        return this.buildJsonP(resource, jsonp).cacheControl(this.cc).tag(tag).build();
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/invitations/{id}")
    public Response updateInvitationById(@PathParam(value="id") String id, @QueryParam(value="status") String status) {
        if (Arrays.binarySearch(INVITATION_STATUS, status) < 0) {
            return this.buildBadResponse(new ErrorResource("status must be one of: " + StringUtils.join((Object[])INVITATION_STATUS, (String)","), "status"));
        }
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        String username = this.currentUserId();
        Invitation invitation = evtDAO.getInvitationById(id);
        if (invitation != null) {
            if (invitation.getParticipant().equals(username)) {
                evtDAO.updateInvitation(id, status);
                return Response.ok().cacheControl(nc).build();
            }
            return Response.status((int)401).cacheControl(nc).build();
        }
        return Response.status((int)404).cacheControl(nc).build();
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/invitations/{id}")
    public Response deleteInvitationById(@PathParam(value="id") String id) throws Exception {
        CalendarService calService = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = calService.getEventDAO();
        String username = this.currentUserId();
        Invitation invitation = evtDAO.getInvitationById(id);
        if (invitation == null) {
            return Response.status((int)404).cacheControl(nc).build();
        }
        CalendarEvent event = calService.getEventById(invitation.getEventId());
        Calendar calendar = calService.getCalendarById(event.getCalendarId());
        if (Utils.isCalendarEditable((String)username, (Calendar)calendar)) {
            evtDAO.removeInvitation(id);
            return Response.ok().cacheControl(nc).build();
        }
        return Response.status((int)401).cacheControl(nc).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/invitations/")
    @Produces(value={"application/json"})
    public Response getInvitationsFromEvent(@PathParam(value="id") String id, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="returnSize") boolean returnSize, @QueryParam(value="status") String status, @QueryParam(value="fields") String fields, @QueryParam(value="jsonp") String jsonp, @QueryParam(value="expand") String expand, @Context UriInfo uriInfo) throws Exception {
        limit = this.parseLimit(limit);
        CalendarService calService = CalendarRestApi.calendarServiceInstance();
        CalendarEvent event = calService.getEventById(id);
        String username = this.currentUserId();
        List invitations = Collections.emptyList();
        if (event != null) {
            Iterator iter;
            invitations = new LinkedList<Invitation>(Arrays.asList(event.getInvitations()));
            Calendar calendar = calService.getCalendarById(event.getCalendarId());
            if (!Utils.isCalendarEditable((String)username, (Calendar)calendar)) {
                iter = invitations.iterator();
                while (iter.hasNext()) {
                    if (((Invitation)iter.next()).getParticipant().equals(username)) continue;
                    iter.remove();
                }
            }
            if (status != null) {
                iter = invitations.iterator();
                while (iter.hasNext()) {
                    if (((Invitation)iter.next()).getStatus().equals(status)) continue;
                    iter.remove();
                }
            }
        }
        LinkedList<Object> data = new LinkedList<Object>();
        for (Invitation invitation : Utils.subList(invitations, (int)offset, (int)limit)) {
            data.add(this.buildInvitationResource(invitation, uriInfo, expand, fields));
        }
        int fullSize = invitations.size();
        CollectionResource ivData = new CollectionResource(data, returnSize ? (long)fullSize : -1L);
        ivData.setOffset(offset);
        ivData.setLimit(limit);
        Response.ResponseBuilder response = this.buildJsonP(ivData, jsonp);
        if (returnSize) {
            response.header(HEADER_LINK, (Object)this.buildFullUrl(uriInfo, offset, limit, fullSize));
        }
        return response.build();
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/events/{id}/invitations/")
    public Response createInvitationForEvent(@PathParam(value="id") String id, InvitationResource invitation, @Context UriInfo uriInfo) throws Exception {
        if (invitation == null) {
            return this.buildBadResponse(new ErrorResource("Invitation information must not null", "invitation"));
        }
        String participant = invitation.getParticipant();
        String status = invitation.getStatus();
        if (participant == null || participant.trim().isEmpty()) {
            return this.buildBadResponse(new ErrorResource("participant must not null or empty", "participant"));
        }
        if (Arrays.binarySearch(INVITATION_STATUS, status) < 0) {
            return this.buildBadResponse(new ErrorResource("status must be one of: " + StringUtils.join((Object[])INVITATION_STATUS, (String)","), "status"));
        }
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        EventDAO evtDAO = service.getEventDAO();
        String username = this.currentUserId();
        CalendarEvent event = service.getEventById(id);
        if (event != null) {
            Calendar calendar = service.getCalendarById(event.getCalendarId());
            if (!Utils.isCalendarEditable((String)username, (Calendar)calendar)) {
                return Response.status((int)401).cacheControl(nc).build();
            }
            Invitation invite = evtDAO.createInvitation(id, participant, status);
            if (invite != null) {
                String location = this.getBasePath(uriInfo) + INVITATION_URI + invite.getId();
                return Response.status((int)201).header(HEADER_LOCATION, (Object)location).cacheControl(nc).build();
            }
            return this.buildBadResponse(new ErrorResource(participant + " has already been participant, can't create more", "participant"));
        }
        return Response.status((int)404).cacheControl(nc).build();
    }

    private Response buildBadResponse(ErrorResource error) {
        return Response.status((int)400).entity((Object)error).type("application/json").cacheControl(nc).build();
    }

    private java.util.Calendar[] parseDate(String start, String end) {
        java.util.Calendar from = GregorianCalendar.getInstance();
        java.util.Calendar to = GregorianCalendar.getInstance();
        if (Utils.isEmpty((String)start)) {
            from = java.util.Calendar.getInstance();
            from.set(10, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
        } else {
            from = ISO8601.parse((String)start);
        }
        if (Utils.isEmpty((String)end)) {
            to.add(4, 1);
            to.set(10, 0);
            to.set(12, 0);
            to.set(13, 0);
            to.set(14, 0);
        } else {
            to = ISO8601.parse((String)end);
        }
        return new java.util.Calendar[]{from, to};
    }

    private int parseLimit(int limit) {
        return limit <= 0 || limit > this.query_limit ? this.query_limit : limit;
    }

    private String getBasePath(UriInfo uriInfo) {
        StringBuilder path = new StringBuilder(uriInfo.getBaseUri().toString());
        path.append(CAL_BASE_URI);
        return path.toString();
    }

    private String buildFullUrl(UriInfo uriInfo, int offset, int limit, long fullSize) {
        long next;
        if (fullSize <= 0L) {
            return "";
        }
        offset = offset < 0 ? 0 : offset;
        long prev = offset - limit;
        prev = offset > 0 && prev < 0L ? 0L : prev;
        long prevLimit = (long)offset - prev;
        StringBuilder sb = new StringBuilder();
        if (prev >= 0L) {
            sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=");
            sb.append(prev).append("&limit=").append(prevLimit).append(">").append(";").append("rel=\"previous\",");
        }
        if ((next = (long)(offset + limit)) < fullSize) {
            sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=");
            sb.append(next).append("&limit=").append(limit).append(">").append(";").append("rel=\"next\",");
        }
        long firstLimit = (long)limit > fullSize ? fullSize : (long)limit;
        sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=0&limit=").append(firstLimit).append(">");
        sb.append(";").append("rel=\"first\",");
        long lastIndex = fullSize - fullSize % firstLimit;
        if (lastIndex == fullSize) {
            lastIndex = fullSize - firstLimit;
        }
        if (lastIndex > 0L) {
            sb.append("<").append(uriInfo.getAbsolutePath()).append("?offset=").append(lastIndex);
            sb.append("&limit=").append(fullSize - lastIndex).append(">");
            sb.append(";").append("rel=\"last\"");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static CalendarService calendarServiceInstance() {
        return (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
    }

    private String makeFeed(String author, List<CalendarEvent> events, FeedData feedData, UriInfo uri) throws Exception {
        URI baseUri = uri.getBaseUri();
        String baseURL = baseUri.getScheme() + "://" + baseUri.getHost() + ":" + Integer.toString(baseUri.getPort());
        String baseRestURL = baseUri.toString();
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(feedData.getTitle());
        feed.setLink(baseURL + feedData.getUrl());
        feed.setDescription(feedData.getTitle());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (CalendarEvent event : events) {
            if (Utils.EVENT_NUMBER > 0 && Utils.EVENT_NUMBER <= entries.size()) break;
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(event.getSummary());
            entry.setLink(baseRestURL + BASE_EVENT_URL + "/" + author + "/" + event.getId() + "splitter" + event.getCalType() + ".ics");
            entry.setAuthor(author);
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(event.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            entry.getEnclosures();
        }
        feed.setEntries(entries);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        String feedXML = output.outputString((SyndFeed)feed);
        feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
        return feedXML;
    }

    private boolean isInGroups(String[] groups) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        for (String group : groups) {
            if (!identity.isMemberOf(group)) continue;
            return true;
        }
        return false;
    }

    private boolean hasViewCalendarPermission(Calendar cal, String username) throws Exception {
        if (cal.getCalendarOwner() != null && cal.getCalendarOwner().equals(username)) {
            return true;
        }
        if (cal.getGroups() != null) {
            return this.isInGroups(cal.getGroups());
        }
        if (cal.getViewPermission() != null) {
            return Utils.canEdit((OrganizationService)this.orgService, (String[])cal.getViewPermission(), (String)username);
        }
        return false;
    }

    private List<Calendar> findViewableCalendars(String username) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        List uCals = service.getUserCalendars(username, true);
        Set groupIds = ConversationState.getCurrent().getIdentity().getGroups();
        List gCals = service.getGroupCalendars(groupIds.toArray(new String[groupIds.size()]), true, username);
        GroupCalendarData sCals = service.getSharedCalendars(username, true);
        if (sCals != null) {
            gCals.add(sCals);
        }
        Calendar[] publicCals = (Calendar[])service.getPublicCalendars().load(0, -1);
        LinkedList<Calendar> results = new LinkedList<Calendar>();
        results.addAll(Arrays.asList(publicCals));
        for (GroupCalendarData data : gCals) {
            if (data.getCalendars() == null) continue;
            for (Calendar cal : data.getCalendars()) {
                results.add(cal);
            }
        }
        results.addAll(uCals);
        return results;
    }

    private List<Calendar> findEditableCalendars(String username) throws Exception {
        List<Calendar> calendars = this.findViewableCalendars(username);
        Iterator<Calendar> iter = calendars.iterator();
        while (iter.hasNext()) {
            if (Utils.isCalendarEditable((String)username, (Calendar)iter.next())) continue;
            iter.remove();
        }
        return calendars;
    }

    private EventQuery buildEventQuery(String start, String end, String category, List<Calendar> calendars, String calendarPath, String participant, String eventType) {
        java.util.Calendar[] dates = this.parseDate(start, end);
        RestEventQuery uQuery = new RestEventQuery();
        uQuery.setQueryType("sql");
        uQuery.setCalendarPath(calendarPath);
        LinkedList<String> calIds = new LinkedList<String>();
        if (calendars != null) {
            for (Calendar cal : calendars) {
                calIds.add(cal.getId());
            }
            uQuery.setCalendarId(calIds.toArray(new String[calIds.size()]));
        }
        if (category != null) {
            uQuery.setCategoryId(new String[]{category});
        }
        if (participant != null) {
            uQuery.setParticipants(new String[]{participant});
        }
        uQuery.setEventType(eventType);
        uQuery.setFromDate(dates[0]);
        uQuery.setToDate(dates[1]);
        uQuery.setOrderType("ASC");
        uQuery.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        return uQuery;
    }

    private CalendarEvent findEventAttachment(String attachmentID) throws Exception {
        int idx = attachmentID.indexOf(CALENDAR_URI);
        if (idx != -1) {
            int calendars = idx + CALENDAR_URI.length();
            int calendar = attachmentID.indexOf(47, calendars) + 1;
            int event = attachmentID.indexOf(47, calendar);
            if (calendar != -1 && event != -1) {
                String eventId = attachmentID.substring(calendar, event);
                return CalendarRestApi.calendarServiceInstance().getEventById(eventId);
            }
        }
        return null;
    }

    private Object extractObject(Resource iv, String fields) {
        String[] f;
        if (fields != null && iv != null && (f = fields.split(",")).length > 0) {
            JSONObject obj = new JSONObject((Object)iv);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : f) {
                try {
                    map.put(name, obj.get(name));
                }
                catch (JSONException e) {
                    this.log.warn("Can't extract property {} from object {}", new Object[]{name, iv});
                }
            }
            return map;
        }
        return iv;
    }

    private String currentUserId() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    private Response buildEvent(CalendarEvent old, EventResource evObject) {
        String subject;
        String privacy;
        String priority;
        java.util.Calendar[] fromTo;
        String eventState;
        String catId = evObject.getCategoryId();
        this.setEventCategory(old, catId);
        if (evObject.getDescription() != null) {
            old.setDescription(evObject.getDescription());
        }
        if ((eventState = evObject.getAvailability()) != null) {
            if (Arrays.binarySearch(EVENT_AVAILABILITY, eventState) < 0) {
                return this.buildBadResponse(new ErrorResource("availability must be one of " + StringUtils.join((Object[])EVENT_AVAILABILITY, (String)","), "availability"));
            }
            old.setEventState(eventState);
        }
        if (evObject.getRepeat() != null) {
            int every;
            RepeatResource repeat = evObject.getRepeat();
            if (repeat.getExclude() != null) {
                old.setExceptionIds(Arrays.asList(repeat.getExclude()));
            }
            if (repeat.getRepeatOn() != null) {
                String[] reptOns;
                for (String on : reptOns = repeat.getRepeatOn().split(",")) {
                    if (Arrays.binarySearch(RP_WEEKLY_BYDAY, on) >= 0) continue;
                    return this.buildBadResponse(new ErrorResource("repeatOn can only contains " + StringUtils.join((Object[])RP_WEEKLY_BYDAY, (String)","), "repeatOn"));
                }
                old.setRepeatByDay(reptOns);
            }
            if (repeat.getRepeateBy() != null) {
                String[] repeatBy = repeat.getRepeateBy().split(",");
                long[] by = new long[repeatBy.length];
                for (int i = 0; i < repeatBy.length; ++i) {
                    try {
                        by[i] = Integer.parseInt(repeatBy[i]);
                        if (by[i] >= 1L && by[i] <= 31L) continue;
                        return this.buildBadResponse(new ErrorResource("repeatBy must be >= 1 and <= 31", "repeatBy"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                old.setRepeatByMonthDay(by);
            }
            if (repeat.getEnd() != null) {
                String reptType;
                End end = repeat.getEnd();
                String val = end.getValue();
                if (val != null) {
                    try {
                        old.setRepeatUntilDate(ISO8601.parse((String)val).getTime());
                    }
                    catch (Exception e) {
                        try {
                            old.setRepeatCount(Long.parseLong(end.getValue()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                if ((reptType = end.getType()) != null) {
                    if (Arrays.binarySearch(REPEATTYPES, reptType) < 0) {
                        return this.buildBadResponse(new ErrorResource("repeat type must be one of " + StringUtils.join((Object[])REPEATTYPES, (String)","), "end.type"));
                    }
                    old.setRepeatType(end.getType());
                }
            }
            if ((every = repeat.getEvery()) < 1 || every > 30) {
                every = 1;
            }
            old.setRepeatInterval((long)repeat.getEvery());
        }
        if ((fromTo = this.parseDate(evObject.getFrom(), evObject.getTo()))[0].after(fromTo[1]) || fromTo[0].equals(fromTo[1])) {
            return this.buildBadResponse(new ErrorResource("\"from\" date must be before \"to\" date", "from"));
        }
        old.setFromDateTime(fromTo[0].getTime());
        if (evObject.getLocation() != null) {
            old.setLocation(evObject.getLocation());
        }
        if ((priority = evObject.getPriority()) != null) {
            if (Arrays.binarySearch(PRIORITY, priority) < 0) {
                return this.buildBadResponse(new ErrorResource("priority must be one of " + StringUtils.join((Object[])PRIORITY, (String)","), "priority"));
            }
            old.setPriority(evObject.getPriority());
        }
        if (evObject.getReminder() != null) {
            old.setReminders(Arrays.asList(evObject.getReminder()));
        }
        if ((privacy = evObject.getPrivacy()) != null) {
            if (!CalendarEvent.IS_PRIVATE.equals(privacy) && !CalendarEvent.IS_PUBLIC.equals(privacy)) {
                return this.buildBadResponse(new ErrorResource("privacy can only be public or private", "privacy"));
            }
            old.setPrivate(CalendarEvent.IS_PRIVATE.equals(privacy));
        }
        if ((subject = evObject.getSubject()) != null) {
            if ((subject = subject.trim()).isEmpty()) {
                return this.buildBadResponse(new ErrorResource("subject must not be empty", "subject"));
            }
            old.setSummary(subject);
        }
        old.setToDateTime(fromTo[1].getTime());
        return null;
    }

    private Response buildEventFromTask(CalendarEvent old, TaskResource evObject) {
        String name;
        String status;
        java.util.Calendar[] fromTo;
        String catId = evObject.getCategoryId();
        this.setEventCategory(old, catId);
        if (evObject.getNote() != null) {
            old.setDescription(evObject.getNote());
        }
        if ((fromTo = this.parseDate(evObject.getFrom(), evObject.getTo()))[0].after(fromTo[1]) || fromTo[0].equals(fromTo[1])) {
            return this.buildBadResponse(new ErrorResource("\"from\" date must be before \"to\" date", "from"));
        }
        old.setFromDateTime(fromTo[0].getTime());
        String priority = evObject.getPriority();
        if (priority != null) {
            if (Arrays.binarySearch(PRIORITY, priority) < 0) {
                return this.buildBadResponse(new ErrorResource("priority must be one of " + StringUtils.join((Object[])PRIORITY, (String)","), "priority"));
            }
            old.setPriority(evObject.getPriority());
        }
        if (evObject.getReminder() != null) {
            old.setReminders(Arrays.asList(evObject.getReminder()));
        }
        if ((status = evObject.getStatus()) != null && !status.isEmpty()) {
            if (Arrays.binarySearch(TASK_STATUS, status) < 0) {
                return this.buildBadResponse(new ErrorResource("status must be one of " + StringUtils.join((Object[])TASK_STATUS, (String)","), "status"));
            }
            old.setStatus(status);
        }
        if ((name = evObject.getName()) != null) {
            if ((name = name.trim()).isEmpty()) {
                return this.buildBadResponse(new ErrorResource("name must not be empty", "name"));
            }
            old.setSummary(evObject.getName());
        }
        old.setToDateTime(fromTo[1].getTime());
        if (evObject.getDelegation() != null) {
            old.setTaskDelegator(StringUtils.join((Object[])evObject.getDelegation(), (String)","));
        }
        return null;
    }

    private void setEventCategory(CalendarEvent old, String catId) {
        if (catId != null) {
            try {
                EventCategory cat = CalendarRestApi.calendarServiceInstance().getEventCategory(this.currentUserId(), catId);
                if (cat != null) {
                    old.setEventCategoryId(cat.getId());
                    old.setEventCategoryName(cat.getName());
                }
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Response buildCalendar(Calendar cal, CalendarResource calR) {
        String name;
        if (calR.getColor() != null) {
            cal.setCalendarColor(calR.getColor());
        }
        if (calR.getOwner() != null) {
            cal.setCalendarOwner(calR.getOwner());
        }
        if (calR.getDescription() != null) {
            cal.setDescription(calR.getDescription());
        }
        if (calR.getEditPermission() != null) {
            cal.setEditPermission(calR.getEditPermission().split(";"));
        }
        if (calR.getGroups() != null) {
            cal.setGroups(calR.getGroups());
        }
        if ((name = calR.getName()) != null) {
            if ((name = name.trim()).isEmpty() || this.containSpecialChar(name)) {
                return this.buildBadResponse(new ErrorResource("calendar name is empty or contains special characters", "name"));
            }
            cal.setName(calR.getName());
        }
        if (calR.getPrivateURL() != null) {
            cal.setPrivateUrl(calR.getPrivateURL());
        }
        if (calR.getPublicURL() != null) {
            cal.setPublicUrl(calR.getPublicURL());
        }
        if (calR.getTimeZone() != null) {
            cal.setTimeZone(calR.getTimeZone());
        }
        if (calR.getViewPermission() != null) {
            cal.setViewPermission(calR.getViewPermission().split(";"));
        }
        return null;
    }

    private boolean containSpecialChar(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return true;
        }
        return false;
    }

    private Response.ResponseBuilder buildJsonP(Object resource, String jsonp) throws Exception {
        Response.ResponseBuilder response = null;
        if (jsonp != null) {
            String json = null;
            if (resource instanceof Map) {
                json = new JSONObject((Map)resource).toString();
            } else {
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                json = generatorImpl.createJsonObject(resource).toString();
            }
            StringBuilder sb = new StringBuilder(jsonp);
            sb.append("(").append(json).append(");");
            response = Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript")).cacheControl(nc);
        } else {
            response = Response.ok((Object)resource, (String)"application/json").cacheControl(nc);
        }
        return response;
    }

    private Object buildTaskResource(CalendarEvent event, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        TaskResource evtResource = new TaskResource(event, basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (DEFAULT_CAL_NAME.equals(exp.getField())) {
                Calendar cal = service.getCalendarById(event.getCalendarId());
                cal.setCalType(CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), cal.getId()));
                evtResource.setCal(new CalendarResource(cal, basePath));
                continue;
            }
            if ("categories".equals(exp.getField())) {
                EventCategory evCat;
                String categoryId = event.getEventCategoryId();
                if (categoryId == null || (evCat = service.getEventCategory(this.currentUserId(), categoryId)) == null) continue;
                Object[] catRs = new CategoryResource[]{new CategoryResource(evCat, basePath)};
                evtResource.setCats((Serializable[])Utils.subArray((Object[])catRs, (int)exp.getOffset(), (int)exp.getLimit()));
                continue;
            }
            if (!"attachments".equals(exp.getField()) || event.getAttachment() == null) continue;
            List attRs = new LinkedList<AttachmentResource>();
            for (Attachment att : event.getAttachment()) {
                attRs.add(new AttachmentResource(att, basePath));
            }
            attRs = Utils.subList(attRs, (int)exp.getOffset(), (int)exp.getLimit());
            evtResource.setAtts(attRs.toArray(new AttachmentResource[attRs.size()]));
        }
        return this.extractObject(evtResource, fields);
    }

    private Object buildEventResource(CalendarEvent ev, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        EventResource evtResource = new EventResource(ev, basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (DEFAULT_CAL_NAME.equals(exp.getField())) {
                Calendar cal = service.getCalendarById(ev.getCalendarId());
                cal.setCalType(CalendarRestApi.calendarServiceInstance().getTypeOfCalendar(this.currentUserId(), cal.getId()));
                evtResource.setCal(new CalendarResource(cal, basePath));
                continue;
            }
            if ("categories".equals(exp.getField())) {
                EventCategory evCat;
                String categoryId = ev.getEventCategoryId();
                if (categoryId == null || (evCat = service.getEventCategory(this.currentUserId(), categoryId)) == null) continue;
                Object[] catRs = new CategoryResource[]{new CategoryResource(evCat, basePath)};
                evtResource.setCats((Serializable[])Utils.subArray((Object[])catRs, (int)exp.getOffset(), (int)exp.getLimit()));
                continue;
            }
            if ("originalEvent".equals(exp.getField())) {
                CalendarEvent orgEv;
                String orgId = ev.getOriginalReference();
                if (orgId == null || (orgEv = service.getEventById(orgId)) == null) continue;
                evtResource.setOEvent(new EventResource(orgEv, basePath));
                continue;
            }
            if (!"attachments".equals(exp.getField()) || ev.getAttachment() == null) continue;
            List attRs = new LinkedList<AttachmentResource>();
            for (Attachment att : ev.getAttachment()) {
                attRs.add(new AttachmentResource(att, basePath));
            }
            attRs = Utils.subList(attRs, (int)exp.getOffset(), (int)exp.getLimit());
            evtResource.setAtts(attRs.toArray(new AttachmentResource[attRs.size()]));
        }
        return this.extractObject(evtResource, fields);
    }

    private Object buildFeedResource(FeedData feed, List<String> calIds, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        FeedResource feedResource = new FeedResource(feed, calIds.toArray(new String[calIds.size()]), basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (!"calendars".equals(exp.getField())) continue;
            ArrayList<CalendarResource> calendars = new ArrayList<CalendarResource>();
            for (String calId : Utils.subList(calIds, (int)exp.getOffset(), (int)exp.getLimit())) {
                calendars.add(new CalendarResource(service.getCalendarById(calId), this.getBasePath(uriInfo)));
            }
            feedResource.setCals(Utils.subList(calendars, (int)exp.getOffset(), (int)exp.getLimit()));
        }
        return this.extractObject(feedResource, fields);
    }

    private Object buildInvitationResource(Invitation invitation, UriInfo uriInfo, String expand, String fields) throws Exception {
        CalendarService service = CalendarRestApi.calendarServiceInstance();
        String basePath = this.getBasePath(uriInfo);
        InvitationResource ivtResource = new InvitationResource(invitation, basePath);
        List<Expand> expands = Expand.parse(expand);
        for (Expand exp : expands) {
            if (!"event".equals(exp.getField())) continue;
            CalendarEvent event = service.getEventById(invitation.getEventId());
            ivtResource.setEvt(new EventResource(event, basePath));
        }
        return this.extractObject(ivtResource, fields);
    }

    private String digest(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] hashCode = md5.digest(data);
        return String.valueOf(hashCode);
    }

    static {
        Arrays.sort(RP_WEEKLY_BYDAY);
        Arrays.sort(EVENT_AVAILABILITY);
        Arrays.sort(REPEATTYPES);
        Arrays.sort(PRIORITY);
        Arrays.sort(TASK_STATUS);
        Arrays.sort(INVITATION_STATUS);
        nc.setNoCache(true);
        nc.setNoStore(true);
    }

    public static class Expand {
        private String field;
        private int offset;
        private int limit;

        public Expand(String field, int offset, int limit) {
            this.field = field;
            this.offset = offset;
            this.limit = limit;
        }

        public static List<Expand> parse(String expand) {
            LinkedList<Expand> expands = new LinkedList<Expand>();
            if (expand != null) {
                String[] frags = expand.split(",");
                LinkedList<String> tmp = new LinkedList<String>();
                for (int i = 0; i < frags.length; ++i) {
                    String str = frags[i].trim();
                    if (!str.contains("(") && str.contains("")) {
                        tmp.add(str);
                        continue;
                    }
                    if (!str.contains("(") || i + 1 >= frags.length) continue;
                    tmp.add(str + "," + frags[++i]);
                }
                for (String exp : tmp) {
                    String fieldName = null;
                    int offset = 0;
                    int limit = -1;
                    if (exp != null) {
                        int i = (exp = exp.trim()).indexOf(40);
                        if (i > 0) {
                            fieldName = exp.substring(0, i).trim();
                            try {
                                offset = Integer.parseInt(exp.substring(exp.indexOf("offset:") + "offset:".length(), exp.indexOf(",")).trim());
                                limit = Integer.parseInt(exp.substring(exp.indexOf("limit:") + "limit:".length(), exp.indexOf(")")).trim());
                            }
                            catch (Exception ex) {}
                        } else {
                            fieldName = exp;
                        }
                    }
                    expands.add(new Expand(fieldName, offset, limit));
                }
            }
            return expands;
        }

        public String getField() {
            return this.field;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

